/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.work;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import oracle.j2ee.connector.work.WorkManagerImpl;
import oracle.j2ee.connector.work.WorkWrapper;

public class BoundedTimeoutQueue
extends BoundedBuffer {
    private WorkQueueReaper m_reaper;
    private Object m_putLock = new Object();
    private static final int TIMEOUT_BUFFER = 50;
    private long m_nextTimeout = Long.MAX_VALUE;

    public BoundedTimeoutQueue(int capacity) {
        super(capacity);
        this.m_reaper = new WorkQueueReaper();
        Thread t = new Thread((Runnable)this.m_reaper, "BoundedTimeoutQueueReaper");
        t.setDaemon(true);
        t.start();
    }

    public void put(Object work) throws InterruptedException {
        this.put(work, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Object work, boolean notify) throws InterruptedException {
        Object object = this.m_putLock;
        synchronized (object) {
            super.put(work);
        }
        if (notify) {
            this.resetNextTimeout(((WorkWrapper)work).clockTimeOnTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object work, long msecs) throws InterruptedException {
        boolean retValue;
        Object object = this.m_putLock;
        synchronized (object) {
            retValue = super.offer(work, msecs);
        }
        if (!retValue) {
            return false;
        }
        this.resetNextTimeout(((WorkWrapper)work).clockTimeOnTimeout());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetNextTimeout(long timeout) {
        WorkQueueReaper workQueueReaper = this.m_reaper;
        synchronized (workQueueReaper) {
            if (timeout < this.m_nextTimeout) {
                this.m_nextTimeout = timeout;
                this.m_reaper.notify();
            }
        }
    }

    void destroy() {
        this.m_reaper.destroy();
    }

    public synchronized int size() {
        return super.size();
    }

    private class WorkQueueReaper
    implements Runnable {
        boolean m_done = false;

        private WorkQueueReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            this.m_done = true;
            WorkQueueReaper workQueueReaper = this;
            synchronized (workQueueReaper) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.m_done) {
                this.removeTimedOutEntries();
                WorkQueueReaper workQueueReaper = this;
                synchronized (workQueueReaper) {
                    try {
                        long waitTime = BoundedTimeoutQueue.this.m_nextTimeout - System.currentTimeMillis();
                        if (waitTime > 0L) {
                            this.wait(waitTime);
                        }
                    }
                    catch (InterruptedException e) {
                        WorkManagerImpl.log("WorkQueue thread interupted");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeTimedOutEntries() {
            int queueSize = this.getQueueSize();
            long nextWorkTimeout = Long.MAX_VALUE;
            for (int i = 0; i < queueSize; ++i) {
                long workInstanceTimeout;
                WorkWrapper work = null;
                Object object = BoundedTimeoutQueue.this.m_putLock;
                synchronized (object) {
                    work = this.getWorkItemFromQueue();
                    if (work == null) {
                        break;
                    }
                    workInstanceTimeout = work.millisUntilTimeout();
                    if (workInstanceTimeout > 50L) {
                        long workClockTimeout = work.clockTimeOnTimeout();
                        if (this.putWorkBackIntoQueue(work) && workClockTimeout < nextWorkTimeout) {
                            nextWorkTimeout = workClockTimeout;
                        }
                    }
                }
                if (workInstanceTimeout > 50L) continue;
                work.runTimedOutEntry();
            }
            this.setNextTimeout(nextWorkTimeout);
        }

        private WorkWrapper getWorkItemFromQueue() {
            WorkWrapper work = null;
            try {
                work = (WorkWrapper)BoundedTimeoutQueue.this.poll(0L);
            }
            catch (InterruptedException e) {
                WorkManagerImpl.log("WorkQueueReaper: poll() interrupted");
            }
            return work;
        }

        private boolean putWorkBackIntoQueue(WorkWrapper work) {
            try {
                BoundedTimeoutQueue.this.put(work, false);
                return true;
            }
            catch (InterruptedException e) {
                WorkManagerImpl.log("WorkQueueReaper: put() interrupted");
                work.runTimedOutEntry();
                return false;
            }
        }

        private synchronized void setNextTimeout(long nextWorkTimeout) {
            if (nextWorkTimeout < BoundedTimeoutQueue.this.m_nextTimeout) {
                BoundedTimeoutQueue.this.m_nextTimeout = nextWorkTimeout;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getQueueSize() {
            int size;
            WorkQueueReaper workQueueReaper = this;
            synchronized (workQueueReaper) {
                BoundedTimeoutQueue.this.m_nextTimeout = Long.MAX_VALUE;
                size = BoundedTimeoutQueue.this.size();
            }
            return size;
        }
    }
}

