/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import oracle.j2ee.connector.logging.JCATransactionMessageBundle;
import oracle.j2ee.util.CustomerLogger;

public class JCATransactionMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.connector.transaction", JCATransactionMessageBundle.class.getName());

    public static Logger getLogger() {
        return m_logger;
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void fineConnectCalled(String s) {
        m_logger.log(Level.FINE, "J2EE JCA-05001", new Object[]{s});
    }

    public static void warningInvalidConnectArg(String s, Exception e) {
        m_logger.log(Level.WARNING, "J2EE JCA-05002", new Object[]{s, e});
    }

    public static void warningNullRecoveryUser(String s) {
        m_logger.log(Level.WARNING, "J2EE JCA-05003", s);
    }

    public static void warningRecoveryFailed(String msg, ResourceException rootException) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-05004", new Object[]{msg, rootException == null ? "" : rootException.getMessage()});
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JCA-05004", new Object[]{msg, rootException});
        }
    }

    public static void warningResourceExceptionFromProtocolErrorNotification(ResourceException rootException) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-05005", new Object[]{rootException == null ? "" : rootException.getMessage()});
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE JCA-05005", new Object[]{rootException});
        }
    }
}

