/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.FieldDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TypeUtil {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static Hashtable primitiveClasses_ = new Hashtable();
    private static final byte[] charval;

    public static int intGetChars(int src, char[] buf, int offset) {
        int power = 1000000000;
        boolean have_emitted = false;
        int init_offset = offset;
        if (src == 0) {
            buf[offset] = digits[0];
            return 1;
        }
        if (src < 0) {
            if (src == Integer.MIN_VALUE) {
                throw new IllegalArgumentException();
            }
            buf[offset++] = 45;
            src = Math.abs(src);
        }
        while (power > 0) {
            int this_digit = src / power;
            if (this_digit != 0 || have_emitted) {
                have_emitted = true;
                buf[offset++] = digits[this_digit];
            }
            src %= power;
            power /= 10;
        }
        return offset - init_offset;
    }

    public static int intGetBytes(int src, byte[] buf, int offset) {
        int power = 1000000000;
        boolean have_emitted = false;
        int init_offset = offset;
        if (src == 0) {
            buf[offset] = charval[0];
            return 1;
        }
        if (src < 0) {
            if (src == Integer.MIN_VALUE) {
                throw new IllegalArgumentException();
            }
            buf[offset++] = 45;
            src = Math.abs(src);
        }
        while (power > 0) {
            int this_digit = src / power;
            if (this_digit != 0 || have_emitted) {
                have_emitted = true;
                buf[offset++] = charval[this_digit];
            }
            src %= power;
            power /= 10;
        }
        return offset - init_offset;
    }

    public static int hashCode(String s) {
        int length = s.length();
        int h = 1;
        int i = 0;
        while (i < length) {
            h = h * 37 + s.charAt(i);
            ++i;
        }
        return h;
    }

    public static String[] wordWrap(String msg, int widthInChars) {
        int length;
        int width = widthInChars;
        int nextBreak = 0;
        int lastBreak = 0;
        int lengthLeft = length = msg.length();
        boolean breakFound = true;
        Vector<String> v = new Vector<String>();
        int nextNewline = msg.indexOf("\n");
        while (lengthLeft > width || nextNewline != -1) {
            nextBreak = nextNewline;
            if (nextBreak == -1 || nextBreak <= lastBreak || nextBreak > lastBreak + width) {
                nextBreak = msg.lastIndexOf(" ", lastBreak + width);
            }
            if (nextBreak == -1 || nextBreak <= lastBreak) {
                nextBreak = lastBreak + width - 1;
                breakFound = false;
                if (nextBreak > length) break;
            }
            String substr = msg.substring(lastBreak, nextBreak);
            v.addElement(substr);
            lengthLeft -= substr.length();
            lastBreak = nextBreak;
            if (breakFound) {
                ++lastBreak;
            }
            breakFound = true;
            nextNewline = msg.indexOf("\n", lastBreak);
        }
        v.addElement(msg.substring(lastBreak));
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        return lines;
    }

    public static String arrayToString(String[] from, String separator) {
        StringBuffer sb = new StringBuffer(100);
        String sep = "";
        int i = 0;
        while (i < from.length) {
            sb.append(sep);
            sb.append(from[i]);
            sep = separator;
            ++i;
        }
        return sb.toString();
    }

    public static String[] stringToArray(String from, String separator) {
        if (from == null) {
            return null;
        }
        if (separator == null) {
            separator = " ";
        }
        StringTokenizer toks = new StringTokenizer(from, separator);
        String[] result = new String[toks.countTokens()];
        int i = 0;
        while (toks.hasMoreTokens()) {
            result[i++] = toks.nextToken().trim();
        }
        return result;
    }

    public static String truncateFloat(float f, int digits) {
        double factor = Math.pow(10.0, digits);
        f = (float)((double)Math.round((double)f * factor) / factor);
        return Float.toString(f);
    }

    public static String addCommas(float f) {
        String floatStr = TypeUtil.truncateFloat(f, 0);
        return TypeUtil.addCommas(floatStr);
    }

    public static String addCommas(String numStr) {
        String n;
        int dotIndex = numStr.lastIndexOf(46);
        String fraction = "";
        if (dotIndex >= 0) {
            fraction = numStr.substring(dotIndex);
            n = numStr.substring(0, dotIndex);
        } else {
            n = numStr;
        }
        String val = "";
        int lastIndex = 0;
        int i = n.length();
        while (i > 0) {
            String comma = i > 3 ? "," : "";
            int start = Math.max(i - 3, 0);
            val = comma + n.substring(start, i) + val;
            lastIndex = start;
            i -= 3;
        }
        val = n.substring(0, lastIndex) + val + fraction;
        return val;
    }

    public static boolean isSubclassOf(Class sub, Class sup) {
        if (sub == sup) {
            return true;
        }
        Class superclass = sub.getSuperclass();
        while (superclass != null && superclass != sup) {
            superclass = superclass.getSuperclass();
        }
        return superclass != null;
    }

    public static Set getSuperInterfaces(ClassLoader cl, String className, String baseClassName) throws ClassNotFoundException {
        HashSet<String> allSuper = new HashSet<String>();
        if (!className.equals(baseClassName)) {
            Class<?> theClass = cl.loadClass(className);
            Class<?>[] superInterfaces = theClass.getInterfaces();
            int superIndex = 0;
            while (superIndex < superInterfaces.length) {
                Class<?> currentClass = superInterfaces[superIndex];
                String currentClassName = currentClass.getName();
                if (!currentClassName.equals(baseClassName)) {
                    allSuper.add(currentClassName);
                    allSuper.addAll(TypeUtil.getSuperInterfaces(cl, currentClassName, baseClassName));
                }
                ++superIndex;
            }
        }
        return allSuper;
    }

    public static Method getMethod(Class declaringClass, ClassLoader loader, String name, String[] paramClassNames) throws Exception {
        Class[] parameterTypes = null;
        if (paramClassNames != null) {
            parameterTypes = new Class[paramClassNames.length];
            int pIndex = 0;
            while (pIndex < parameterTypes.length) {
                String next = paramClassNames[pIndex];
                parameterTypes[pIndex] = primitiveClasses_.containsKey(next) ? (Class)primitiveClasses_.get(next) : loader.loadClass(next);
                ++pIndex;
            }
        }
        return declaringClass.getMethod(name, parameterTypes);
    }

    public static Vector getPossibleCmpCmrFields(ClassLoader cl, String className) throws Exception {
        Vector<FieldDescriptor> fieldDescriptors = new Vector<FieldDescriptor>();
        Class<?> theClass = cl.loadClass(className);
        Method[] methods = theClass.getMethods();
        int mIndex = 0;
        while (mIndex < methods.length) {
            Method next = methods[mIndex];
            String nextName = next.getName();
            int nextModifiers = next.getModifiers();
            if (Modifier.isAbstract(nextModifiers) && nextName.startsWith("get") && nextName.length() > 3) {
                String field = nextName.substring(3, 4).toLowerCase() + nextName.substring(4);
                fieldDescriptors.add(new FieldDescriptor(field));
            }
            ++mIndex;
        }
        return fieldDescriptors;
    }

    static {
        primitiveClasses_.put(Character.TYPE.getName(), Character.TYPE);
        primitiveClasses_.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveClasses_.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveClasses_.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveClasses_.put(Long.TYPE.getName(), Long.TYPE);
        primitiveClasses_.put(Short.TYPE.getName(), Short.TYPE);
        primitiveClasses_.put(Float.TYPE.getName(), Float.TYPE);
        primitiveClasses_.put(Double.TYPE.getName(), Double.TYPE);
        charval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }
}

