/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EJBClassLoader
extends ClassLoader {
    private List urlSet = new ArrayList();
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$EJBClassLoader == null ? (class$com$sun$enterprise$util$EJBClassLoader = EJBClassLoader.class$("com.sun.enterprise.util.EJBClassLoader")) : class$com$sun$enterprise$util$EJBClassLoader);
    static /* synthetic */ Class class$com$sun$enterprise$util$EJBClassLoader;

    public EJBClassLoader() {
    }

    public EJBClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected List getUrlSet() {
        return this.urlSet;
    }

    public synchronized void addURL(URL url) throws IOException {
        this.urlSet.add(url);
    }

    public URL[] getURLs() {
        return this.getUrlSet().toArray(new URL[0]);
    }

    /*
     * Loose catch block
     */
    protected URL findResource(String name) {
        this.print("findResource : " + name);
        URL resource = null;
        Iterator itr = this.getUrlSet().iterator();
        while (itr.hasNext()) {
            URL classpathURL = (URL)itr.next();
            File thisFile = new File(classpathURL.getFile());
            if (thisFile.isFile()) {
                IOException ioe2222;
                Object var10_11;
                ZipFile jarFile;
                block15: {
                    jarFile = null;
                    URL resourceURL = new URL("jar:" + classpathURL + "!/" + name);
                    jarFile = new JarFile(thisFile);
                    JarEntry jarEntry = ((JarFile)jarFile).getJarEntry(name);
                    if (jarEntry == null) break block15;
                    this.print("Found resource : " + resourceURL);
                    resource = resourceURL;
                    var10_11 = null;
                    if (jarFile == null) break;
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe2222) {
                        this.print("Error closing jarFile " + jarFile);
                    }
                    break;
                }
                var10_11 = null;
                if (jarFile == null) continue;
                try {
                    jarFile.close();
                }
                catch (IOException ioe2222) {
                    this.print("Error closing jarFile " + jarFile);
                }
                continue;
                {
                    catch (IOException e) {
                        this.print("Couldn't find " + name + " in " + classpathURL);
                        var10_11 = null;
                        if (jarFile == null) continue;
                        try {
                            jarFile.close();
                        }
                        catch (IOException ioe2222) {
                            this.print("Error closing jarFile " + jarFile);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException ioe2222) {
                            this.print("Error closing jarFile " + jarFile);
                        }
                    }
                    throw throwable;
                }
            }
            File resourceFile = new File(thisFile.toString() + File.separator + name);
            if (resourceFile.exists()) {
                try {
                    resource = resourceFile.toURL();
                    break;
                }
                catch (IOException e) {
                    this.print(e.toString());
                    continue;
                }
            }
            this.print("Couldn't find " + resourceFile);
        }
        return resource;
    }

    private byte[] loadClassData(String name) {
        this.print("JCL: load " + name);
        InputStream classStream = null;
        String entryName = name.replace('.', '/') + ".class";
        Iterator itr = this.getUrlSet().iterator();
        while (itr.hasNext()) {
            URL thisURL = (URL)itr.next();
            File thisFile = new File(thisURL.getFile());
            try {
                if (!thisFile.exists()) {
                    throw new FileNotFoundException(thisFile.toString());
                }
                if (thisFile.isFile()) {
                    this.print("JCL: opening " + thisFile);
                    ZipFile zip = new ZipFile(thisFile);
                    ZipEntry entry = zip.getEntry(entryName);
                    if (entry != null) {
                        this.print("JCL: yes !");
                        classStream = zip.getInputStream(entry);
                        byte[] classData = this.getClassData(classStream);
                        zip.close();
                        return classData;
                    }
                    this.print("JCL: no - closing");
                    zip.close();
                    continue;
                }
                File classFile = new File(thisFile, entryName.replace('/', File.separatorChar));
                if (!classFile.exists()) continue;
                classStream = new FileInputStream(classFile);
                byte[] classData = this.getClassData(classStream);
                ((InputStream)classStream).close();
                return classData;
            }
            catch (IOException ioe) {
                this.print("JCL: Class Could not be loaded");
            }
        }
        return null;
    }

    private byte[] getClassData(InputStream istream) throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout.toByteArray();
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        this.print("Loading class " + name + " using the classLoader " + this);
        byte[] data = this.loadClassData(name);
        Class<?> c = null;
        if (data != null) {
            this.print("Read the class data ");
            c = this.defineClass(null, data, 0, data.length);
            if (!name.equals(c.getName())) {
                throw new ClassNotFoundException(localStrings.getLocalString("classloader.wrongpackage", "", new Object[]{name, c.getName()}));
            }
        }
        if (c == null) {
            this.print("JarClassLoader: could not find " + name + " in  " + this.getUrlSet());
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    private void print(Object o) {
    }

    protected void finalize() {
        this.print("ClassLoader: " + this + " is getting garbage collected");
    }

    public String toString() {
        return "JCL: \n " + this.getUrlSet() + " \n ";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

