/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBInternalInputStream;
import com.evermind.server.ejb.EJBInternalOutputStream;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.oracle.bricks.Local;
import com.oracle.bricks.LocalObject;
import com.oracle.bricks.Replica;
import com.oracle.bricks.j2ee.EJBSession;
import com.oracle.bricks.j2ee.EJBSessionFacade;
import com.oracle.bricks.j2ee.EJBSessionReplica;
import com.oracle.jgroups.ChannelAdapter;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.Address;
import org.jgroups.ChannelException;

public class EJBLiveSession
extends LocalObject
implements EJBSession {
    private static Logger m_logger = ClusteringTraceLogger.getEJBTraceLogger(EJBLiveSession.class);
    protected long lastAccessed;
    protected long creationTime;
    private int maxInactiveTime = Integer.MAX_VALUE;
    private StatefulSessionEJBObject sfsbObj;
    private StatefulSessionEJBHome sfsbHome;
    private EJBSessionFacade facade = new EJBSessionFacade(this);
    private String user;
    private EJBContainer container;
    private byte[] sfsbBytes;
    private String location;
    private long checksum;
    private long sfsbId;
    private boolean passivate = false;
    protected HashMap propertyDeltas = null;

    public EJBLiveSession(Serializable id) {
        super(id);
    }

    public EJBLiveSession(long id, long creationTime) {
        this(new Long(id), creationTime);
    }

    public EJBLiveSession(Serializable id, long creationTime) {
        this(id);
        this.creationTime = creationTime;
        this.lastAccessed = creationTime;
    }

    protected EJBLiveSession(EJBSessionReplica replica) {
        super(replica);
        this.lastAccessed = replica.getLastAccessed();
        this.maxInactiveTime = replica.getLifetime();
        this.user = replica.getUser();
        this.creationTime = replica.getCreationTime();
        this.location = replica.location;
        this.sfsbBytes = replica.sfsbBytes;
        this.checksum = replica.sfsbChecksum;
        this.sfsbId = replica.sfsbId;
        if (replica.contextPropertyDeltas != null) {
            this.propertyDeltas = new HashMap(replica.contextPropertyDeltas);
        }
    }

    public Local getFacade() {
        return this.facade;
    }

    protected void kill() {
        this.facade.setSession(EJBSession.DeadSession.getSingleton());
    }

    protected Replica getReplica(Address address) throws Exception {
        return new EJBSessionReplica(this);
    }

    public void dropped() {
        if (this.sfsbObj == null) {
            return;
        }
        this.sfsbHome.remove(this.sfsbObj.OC4J_getId());
        this.sfsbObj = null;
    }

    public void setEJBObject(StatefulSessionEJBObject object) throws InterruptedException, NamingException {
        this.sfsbObj = object;
        this.checksum = this.sfsbObj.OC4J_getChecksum();
        this.location = ((ExposableBeanDescriptor)this.sfsbObj.getBeanDescriptor()).getQualifiedLocation();
        this.sfsbId = this.sfsbObj.OC4J_getId();
        this.sfsbHome = (StatefulSessionEJBHome)this.container.getApplication().getContext().lookup(this.location);
    }

    public void unmarshall() throws NamingException {
        if (this.container == null) {
            throw new IllegalStateException("must set container");
        }
        if (this.location == null) {
            throw new IllegalStateException("must set location");
        }
        Object object = this.container.getApplication().getContext().lookup(this.location);
        if (!(object instanceof StatefulSessionEJBHome)) {
            if (m_logger.isLoggable(Level.WARNING)) {
                m_logger.log(Level.WARNING, "unmarshalling, object at " + this.location + " not StatefulSessionEJBHome");
            }
            return;
        }
        StatefulSessionEJBHome home = (StatefulSessionEJBHome)object;
        if (this.sfsbBytes == null || this.sfsbBytes.length == 0) {
            throw new IllegalStateException("nothing to unmarshall");
        }
        try {
            EJBInternalInputStream in = new EJBInternalInputStream((InputStream)new ByteArrayInputStream(this.sfsbBytes), home);
            in.readSession(home, this.sfsbId, this.checksum);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected byte[] getBytes() {
        if (this.sfsbObj == null && this.sfsbBytes != null) {
            return this.sfsbBytes;
        }
        try {
            return EJBLiveSession.extractBytes(this.sfsbObj, this.passivate);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new byte[0];
    }

    public void setContainer(EJBContainer container) {
        this.container = container;
    }

    public void setContextAttribute(String name, Serializable value) throws InterruptedException {
        if (this.propertyDeltas == null) {
            this.propertyDeltas = new HashMap();
        }
        this.propertyDeltas.put(name, value);
        this.send(this.createApplyDeltaMessage(this.getId(), name, value));
    }

    protected Replica.Message createApplyDeltaMessage(Serializable id, String name, Serializable value) {
        return new EJBSessionReplica.ApplyDelta(id, name, value);
    }

    public Serializable getContextAttribute(String name) {
        if (this.propertyDeltas == null) {
            return null;
        }
        Object value = this.propertyDeltas.get(name);
        if (value != null && ObjectMarshaller.isMarshalled(value)) {
            block4: {
                try {
                    value = this.deSerializeAttribute(value);
                }
                catch (Throwable t) {
                    if (!m_logger.isLoggable(Level.FINEST)) break block4;
                    m_logger.log(Level.FINEST, "Cannot deserialize property: " + name, t);
                }
            }
            this.propertyDeltas.put(name, value);
        }
        return (Serializable)value;
    }

    protected boolean shouldReap(long currentTime) {
        return false;
    }

    public synchronized void flush() throws InterruptedException {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean passivate) throws InterruptedException {
        Object object = this.stateChangeSync.freeze();
        synchronized (object) {
            try {
                this.passivate = passivate;
                this.send(this.createBroadcastState());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.stateChangeSync.thaw();
            }
        }
    }

    protected EJBSessionReplica.BroadcastState createBroadcastState() {
        return new EJBSessionReplica.BroadcastState(this);
    }

    protected void reaped() {
        this.disconnect();
        this.kill();
    }

    protected void ownedBy(Address newOwner, ChannelAdapter adapter) throws ChannelException {
        super.ownedBy(newOwner, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastAccessed() {
        this.stateChangeSync.acquire();
        try {
            long l = this.lastAccessed;
            this.stateChangeSync.release();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateChangeSync.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "Cannot access state", e);
                }
                throw (IllegalStateException)new IllegalStateException("Cannot access state").initCause(e);
            }
        }
    }

    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public String getUser() {
        if (this.sfsbObj != null) {
            return this.sfsbObj.OC4J_getUserName();
        }
        return this.user;
    }

    public long getCreationTime() {
        if (this.sfsbObj != null) {
            return this.sfsbObj.OC4J_getCreationTime();
        }
        return this.creationTime;
    }

    public String getLocation() {
        return this.location;
    }

    public long getSFSBId() {
        if (this.sfsbObj != null) {
            return this.sfsbObj.OC4J_getId();
        }
        return this.sfsbId;
    }

    public long getChecksum() {
        if (this.sfsbObj != null) {
            return this.sfsbObj.OC4J_getChecksum();
        }
        return this.checksum;
    }

    protected static byte[] extractBytes(StatefulSessionEJBObject sfsbObj, boolean passivate) throws Exception {
        if (sfsbObj == null) {
            return new byte[0];
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        EJBInternalOutputStream ejbOut = new EJBInternalOutputStream(o);
        ejbOut.writeUTF(sfsbObj.OC4J_getUserName());
        ejbOut.writeLong(sfsbObj.OC4J_getCreationTime());
        ejbOut.writeLong(sfsbObj.OC4J_getLastAccessedTime());
        ejbOut.sessionContext = sfsbObj.getContext();
        ejbOut.writeObject(sfsbObj.getContext().attributes);
        ejbOut.writeObject(passivate ? sfsbObj.passivate() : sfsbObj.getObject());
        ejbOut.writeObject(sfsbObj.getContext().getUserInterceptorInstances());
        ejbOut.close();
        return o.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove() throws InterruptedException {
        super.remove();
        this.stateChangeSync.acquire();
        try {
            this.kill();
            this.clear();
        }
        finally {
            this.stateChangeSync.release();
        }
    }

    private void clear() {
        this.sfsbObj = null;
        this.sfsbHome = null;
        this.sfsbBytes = null;
        this.container = null;
        if (this.propertyDeltas != null) {
            this.propertyDeltas.clear();
        }
    }
}

