/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import oracle.j2ee.xml.XMLMessages;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BasicEntityResolver
implements EntityResolver {
    protected Hashtable m_publicEntities = new Hashtable();
    protected Hashtable m_systemEntities = new Hashtable();

    protected boolean isEmpty(String obj) {
        boolean retVal = false;
        if (obj == null || obj.trim().length() == 0) {
            retVal = true;
        }
        return retVal;
    }

    public void registerEntity(String publicId, String systemId, String location) {
        if (!this.isEmpty(location)) {
            if (!this.isEmpty(publicId)) {
                this.m_publicEntities.put(publicId, location);
                XMLMessages.finerRegisterEntityPublicId(publicId, location);
            }
            if (!this.isEmpty(systemId)) {
                this.m_systemEntities.put(systemId, location);
                XMLMessages.finerRegisterEntitySystemId(systemId, location);
            }
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource = null;
        String location = null;
        if (!this.isEmpty(publicId) && (location = (String)this.m_publicEntities.get(publicId)) != null) {
            inputSource = this.getLocalEntity(location);
        }
        if (location == null && inputSource == null && !this.isEmpty(systemId) && (location = (String)this.m_systemEntities.get(systemId)) != null) {
            inputSource = this.getLocalEntity(location);
        }
        if (inputSource == null && (inputSource = this.getLocalEntity(publicId)) == null) {
            inputSource = this.getLocalEntity(systemId);
        }
        if (inputSource != null) {
            XMLMessages.finerSucessfullyResolvedEntity(publicId, systemId, location);
            inputSource.setPublicId(publicId);
            inputSource.setSystemId(systemId);
        }
        return inputSource;
    }

    protected InputSource getLocalEntity(String entity) {
        InputSource retVal = null;
        if (!this.isEmpty(entity)) {
            try {
                File file = new File(entity);
                if (file.canRead()) {
                    retVal = new InputSource(new FileInputStream(file));
                } else {
                    URL url = new URL(entity);
                    String protocol = url.getProtocol();
                    if (protocol.equals("file")) {
                        retVal = new InputSource(url.openStream());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (retVal == null) {
                XMLMessages.finerEntityNotFoundAsFileCheckClassPath(entity);
                retVal = this.getClasspathEntity(entity);
            } else {
                XMLMessages.finerEntityFoundAsFile(entity);
            }
        }
        return retVal;
    }

    protected InputSource getClasspathEntity(String entity) {
        InputSource retVal = null;
        InputStream inputStream = null;
        if (entity != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null && (inputStream = classLoader.getResourceAsStream(entity)) == null && (inputStream = this.getClass().getResourceAsStream(entity)) == null) {
                inputStream = ClassLoader.getSystemResourceAsStream(entity);
            }
            if (inputStream != null) {
                retVal = new InputSource(inputStream);
                XMLMessages.finerEntityFoundInClasspath(entity);
            } else {
                XMLMessages.finerEntityNotFoundInClasspath(entity);
            }
        }
        return retVal;
    }

    static final Document parse(InputStream stream, String systemId) throws SAXException, IOException, XMLParseException {
        InputSource source = new InputSource(stream);
        source.setSystemId(systemId);
        DOMParser parser = new DOMParser();
        parser.parse(source);
        return parser.getDocument();
    }
}

