/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ThreadState;
import com.evermind.util.ReleasableResource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import oracle.oc4j.admin.management.shared.UserInfo;

public class ReleasableResourcePooledExecutor
extends PooledExecutor {
    public ReleasableResourcePooledExecutor() {
    }

    public ReleasableResourcePooledExecutor(int maxPoolSize) {
        super(maxPoolSize);
    }

    public ReleasableResourcePooledExecutor(Channel channel) {
        super(channel);
    }

    public ReleasableResourcePooledExecutor(Channel channel, int maxPoolSize) {
        super(channel, maxPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void interruptAll() {
        try {
            Iterator it = this.threads_.keySet().iterator();
            while (it.hasNext()) {
                MyWorker worker = (MyWorker)it.next();
                Runnable currentTask = worker.getCurrentTask();
                if (!(currentTask instanceof ReleasableResource)) continue;
                ReleasableResource runnable = (ReleasableResource)((Object)currentTask);
                runnable.releaseResource();
            }
        }
        finally {
            super.interruptAll();
        }
    }

    public synchronized String[] getExecutingThreadNames() {
        String[] th = new String[this.threads_.size()];
        int i = 0;
        Iterator it = this.threads_.entrySet().iterator();
        while (it.hasNext()) {
            th[i++] = it.next().toString();
        }
        return th;
    }

    public synchronized Set getConnectedUsers() {
        HashSet<UserInfo> users = new HashSet<UserInfo>();
        boolean i = false;
        Iterator it = this.threads_.entrySet().iterator();
        while (it.hasNext()) {
            ThreadState ts;
            Map.Entry t = it.next();
            Object thr = t.getValue();
            if (thr == null || !(thr instanceof ApplicationServerThread) || (ts = ((ApplicationServerThread)thr).state) == null || ts.getUser() == null) continue;
            String userName = ts.getUser().getName();
            String appName = null;
            try {
                if (ts.getContextContainer() != null && ts.getContextContainer().getApplication() != null) {
                    appName = ts.getContextContainer().getApplication().getName();
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (appName == null) continue;
            users.add(new UserInfo(userName, appName));
        }
        return users;
    }

    public synchronized Map getApplicationsInUse() {
        HashMap<String, HashSet<UserInfo>> users = new HashMap<String, HashSet<UserInfo>>();
        boolean i = false;
        Iterator it = this.threads_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry t = it.next();
            Object thr = t.getValue();
            if (thr == null || !(thr instanceof ApplicationServerThread)) continue;
            try {
                ThreadState ts = ((ApplicationServerThread)thr).state;
                String userName = null;
                String appName = null;
                try {
                    if (ts.getContextContainer() != null && ts.getContextContainer().getApplication() != null) {
                        appName = ts.getContextContainer().getApplication().getName();
                    }
                }
                catch (NamingException e) {
                    // empty catch block
                }
                if (ts != null && ts.getUser() != null) {
                    userName = ts.getUser().getName();
                }
                if (appName == null) continue;
                HashSet<UserInfo> s = (HashSet<UserInfo>)users.get(appName);
                if (s == null) {
                    s = new HashSet<UserInfo>();
                }
                s.add(new UserInfo(userName, appName));
                users.put(appName, s);
            }
            catch (Throwable te) {}
        }
        return users;
    }

    protected void addThread(Runnable command) {
        MyWorker worker = new MyWorker(command);
        Thread thread = this.getThreadFactory().newThread(worker);
        this.threads_.put(worker, thread);
        ++this.poolSize_;
        thread.start();
    }

    private boolean myKeepWorkerAlive() {
        return super.keepWorkerAlive();
    }

    private void workerDone(MyWorker w) {
        super.workerDone(w);
    }

    private Runnable myGetTask() throws InterruptedException {
        return super.getTask();
    }

    protected class MyWorker
    extends PooledExecutor.Worker {
        private Runnable m_currentTask;

        protected MyWorker(Runnable firstTask) {
            super(ReleasableResourcePooledExecutor.this, firstTask);
            this.m_currentTask = null;
        }

        public Runnable getCurrentTask() {
            return this.m_currentTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                do {
                    this.m_currentTask = this.firstTask_;
                    this.firstTask_ = null;
                    if (this.m_currentTask != null) {
                        this.m_currentTask.run();
                        this.m_currentTask = null;
                    }
                    while ((this.m_currentTask = ReleasableResourcePooledExecutor.this.myGetTask()) != null) {
                        this.m_currentTask.run();
                        this.m_currentTask = null;
                    }
                } while (ReleasableResourcePooledExecutor.this.myKeepWorkerAlive());
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                ReleasableResourcePooledExecutor.this.workerDone(this);
            }
        }
    }
}

