/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ObjectArrayPairMapEntry;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class PathTreeMap
extends AbstractMap {
    protected int length;
    protected Object[] entries = new Object[8];

    public Set entrySet() {
        return new PathTreeMapEntrySet(this);
    }

    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String name = (String)key;
        for (int i = 0; i < this.length; ++i) {
            if (!name.startsWith((String)this.entries[i * 2])) continue;
            return this.entries[i * 2 + 1];
        }
        return null;
    }

    public String getRootPath(String name) {
        for (int i = 0; i < this.length; ++i) {
            if (!name.startsWith((String)this.entries[i * 2])) continue;
            return (String)this.entries[i * 2];
        }
        return null;
    }

    public Object put(Object key, Object value) {
        int i;
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Keys must be strings");
        }
        String name = (String)key;
        for (i = 0; i < this.length; ++i) {
            if (name.length() < ((String)this.entries[i * 2]).length()) continue;
            if (name.length() > ((String)this.entries[i * 2]).length()) break;
            if (!this.entries[i * 2].equals(name)) continue;
            Object previous = this.entries[i * 2 + 1];
            this.entries[i * 2 + 1] = value;
            return previous;
        }
        if (this.length * 2 >= this.entries.length) {
            Object[] newEntries = new Object[this.entries.length * 2];
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
            this.entries = newEntries;
        }
        System.arraycopy(this.entries, i * 2, this.entries, i * 2 + 2, this.length - i);
        this.entries[i * 2] = name;
        this.entries[i * 2 + 1] = value;
        ++this.length;
        return null;
    }

    public void remove(int pos) {
        if (pos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("Invalid map index");
        }
        System.arraycopy(this.entries, pos * 2 + 2, this.entries, pos * 2, this.length - (pos * 2 + 2));
        --this.length;
    }

    class PathTreeMapEntrySetIterator
    implements Iterator {
        private PathTreeMap map;
        private int pos;

        public PathTreeMapEntrySetIterator(PathTreeMap map) {
            this.map = map;
        }

        public Object next() {
            if (this.pos >= this.map.length) {
                throw new NoSuchElementException();
            }
            return new ObjectArrayPairMapEntry(this.map.entries, this.pos++);
        }

        public void remove() {
            this.map.remove(this.pos);
        }

        public boolean hasNext() {
            return this.pos < this.map.length;
        }
    }

    class PathTreeMapEntrySet
    extends AbstractSet {
        private PathTreeMap map;

        public PathTreeMapEntrySet(PathTreeMap map) {
            this.map = map;
        }

        public int size() {
            return this.map.length;
        }

        public Iterator iterator() {
            return new PathTreeMapEntrySetIterator(this.map);
        }
    }
}

