/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.OC4JPropertiesResource;
import com.evermind.util.OC4JPropertyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class OC4JProperty {
    private String name;
    private String description;
    private String value = null;
    private boolean isImmutable;
    private String defaultValue;
    private String primitiveType;
    private boolean logValueChange;
    private ArrayList propertyListeners;
    private boolean deprecated;
    private boolean isInternal;
    private String componentCategory;
    private static ResourceBundle descriptionsResourceBundle = ResourceBundle.getBundle(OC4JPropertiesResource.class.getName());
    private boolean booleanValue;
    private int intValue;
    private double doubleValue;
    private long longValue;
    public static final String fBooleanType = "Boolean";
    public static final String fIntegerType = "Int";
    public static final String fLongType = "Long";
    public static final String fDoubleType = "Double";
    public static final String fStringType = "String";
    public static final String fUnknown = "Unknown";
    public static final String fCompiler = "Compiler";
    public static final String fDB = "DB";
    public static final String fHTTP = "HTTP";
    public static final String fDatasources = "Datasources";
    public static final String fEJB = "EJB";
    public static final String fJCA = "JCA";
    public static final String fJDBC = "JDBC";
    public static final String fJMX = "JMX";
    public static final String fJMS = "JMS";
    public static final String fJNDI = "JNDI";
    public static final String fJSP = "JSP";
    public static final String fJTA = "JTA";
    public static final String fOC4JRuntime = "OC4JRuntime";
    public static final String fORB = "ORB";
    public static final String fRMI = "RMI";
    public static final String fIIOP = "IIOP";
    public static final String fServlet = "Servlet";
    public static final String fWebServices = "WebServices";
    public static final String fJVM = "JVM";
    public static final String fServer = "Server";
    public static final String fSecurity = "Security";
    public static final String fServices = "Services";
    public static final String[] fCategories = new String[]{"Unknown", "Compiler", "DB", "HTTP", "Datasources", "EJB", "JCA", "JDBC", "JMX", "JMS", "JNDI", "JSP", "JTA", "OC4JRuntime", "ORB", "RMI", "IIOP", "Servlet", "WebServices", "JVM", "Server", "Security", "Services"};

    public OC4JProperty(String nameArg, String defaultValueArg, String initValue, String primitiveTypeArg, String categoryArg, boolean isImmutableArg) {
        this.name = nameArg;
        if (defaultValueArg != null && defaultValueArg.equalsIgnoreCase("null")) {
            defaultValueArg = null;
        }
        this.defaultValue = defaultValueArg;
        this.primitiveType = primitiveTypeArg;
        this.value = initValue;
        if (this.value == null) {
            this.value = defaultValueArg;
        }
        this.setCachedValue(this.value);
        this.isImmutable = isImmutableArg;
        this.componentCategory = categoryArg;
        try {
            this.description = (String)descriptionsResourceBundle.getObject(nameArg);
        }
        catch (MissingResourceException e) {
            this.description = "No description available";
        }
        this.isInternal = false;
        this.deprecated = false;
    }

    public OC4JProperty(String nameArg, String defaultValueArg, String initValue, String primitiveTypeArg, String categoryArg, boolean isImmutableArg, boolean isInternal, boolean isDeprecated, boolean logValueChanges) {
        this(nameArg, defaultValueArg, initValue, primitiveTypeArg, categoryArg, isImmutableArg);
        this.setInternal(isInternal);
        this.setDeprecated(isDeprecated);
        this.setLogValueChange(logValueChanges);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public void setInternal(boolean internal) {
        this.isInternal = internal;
    }

    public String getComponentCategory() {
        return this.componentCategory;
    }

    public void setComponentCategory(String componentCategory) {
        this.componentCategory = componentCategory;
    }

    public String getPrimitiveType() {
        return this.primitiveType;
    }

    public boolean isSystemProperty() {
        return this.componentCategory == fJVM;
    }

    public void logValueChange(boolean b) {
        if (!this.isImmutable) {
            this.logValueChange = b;
        } else if (b) {
            this.log("Cannot log value change since property: " + this.name + " is a immutable property");
        }
    }

    public void addPropertyListener(OC4JPropertyListener listener) {
        if (!this.isImmutable) {
            if (this.propertyListeners == null) {
                this.propertyListeners = new ArrayList();
            }
            this.propertyListeners.add(listener);
        } else {
            this.log("Cannot set listener class since property: " + this.name + " is a static property");
        }
    }

    public void removePropertyListener(OC4JPropertyListener listener) {
        if (!this.isImmutable) {
            if (this.propertyListeners != null) {
                if (!this.propertyListeners.remove(listener)) {
                    this.log("Listener class: " + listener + " is not an active listener of property: " + this.name);
                }
            } else {
                this.log("Cannot remove property listener: " + listener + " since this property had no property listeners registered");
            }
        } else {
            this.log("Cannot set listener class since property: " + this.name + " is a static property");
        }
    }

    public ArrayList getPropertyListeners() {
        return this.propertyListeners;
    }

    public void setValue(String valueArg) {
        if (this.logValueChange) {
            if (this.isImmutable) {
                System.out.print("Immutable ");
            }
            System.out.println("Property: " + this.name + " has changed from: " + this.value + " to: " + valueArg);
        }
        String oldValue = this.value;
        this.value = valueArg;
        if (oldValue == null || !oldValue.equals(this.value) && this.value != null) {
            this.setCachedValue(this.value);
        }
        if (this.propertyListeners != null) {
            Iterator i = this.propertyListeners.iterator();
            while (i.hasNext()) {
                OC4JPropertyListener listener = (OC4JPropertyListener)i.next();
                listener.propertyChanged(this.name, oldValue, this.value);
            }
        }
    }

    private void setCachedValue(String value) {
        if (this.primitiveType.equals(fBooleanType)) {
            this.booleanValue = value == null ? false : value.equalsIgnoreCase("true");
        } else if (this.primitiveType.equals(fIntegerType)) {
            this.intValue = value == null ? -1 : Integer.parseInt(value);
        } else if (this.primitiveType.equals(fLongType)) {
            this.longValue = value == null ? -1L : Long.parseLong(value);
        } else if (this.primitiveType.equals(fDoubleType)) {
            this.doubleValue = value == null ? -1.0 : Double.parseDouble(value);
        }
    }

    public void log(String s) {
        System.out.println("OC4JProperty: " + s);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public void setImmutable(boolean b) {
        this.isImmutable = b;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setLogValueChange(boolean logValueChange) {
        this.logValueChange = logValueChange;
    }

    public boolean isLogValueChange() {
        return this.logValueChange;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = this.defaultValue;
        }
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public String getStringValue() {
        return this.value;
    }

    public void setBooleanValue(boolean bool) {
        this.setValue(Boolean.toString(bool));
        this.booleanValue = bool;
    }

    public void setIntValue(int i) {
        this.setValue(Integer.toString(i));
        this.intValue = i;
    }

    public void setDoubleValue(double d) {
        this.setValue(Double.toString(d));
        this.doubleValue = d;
    }

    public void setLongValue(long l) {
        this.setValue(Long.toString(l));
        this.longValue = l;
    }

    public void setStringValue(String s) {
        this.setValue(s);
    }

    public void dumpPropertyInfo() {
        System.out.println("Property name: " + this.name);
        System.out.println("Description: " + this.description);
        System.out.println("Default value: " + this.defaultValue);
        System.out.println("Primitive type: " + this.primitiveType);
        System.out.println("Deprecated: " + this.deprecated);
        System.out.println("Log value change: " + this.logValueChange);
        System.out.println("Is static: " + this.isImmutable);
    }
}

