/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static ArrayList getFileList(File directory, String endsWith) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (endsWith != null) {
            File[] fileArray = directory.listFiles(new FileFilterImpl(endsWith));
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    fileList.addAll(FileUtils.getFileList(fileArray[i], endsWith));
                    continue;
                }
                fileList.add(fileArray[i]);
            }
        }
        return fileList;
    }

    public static ArrayList getFileList(File directory) {
        ArrayList<String> fileList = new ArrayList<String>();
        File[] fileArray = directory.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                fileList.addAll(FileUtils.getFileList(fileArray[i]));
                continue;
            }
            fileList.add(fileArray[i].getAbsolutePath());
        }
        return fileList;
    }

    public static List getURLList(File directory) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (directory != null) {
            File[] fileArray = directory.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    urlList.addAll(FileUtils.getURLList(fileArray[i]));
                    continue;
                }
                urlList.add(fileArray[i].toURL());
            }
        }
        return urlList;
    }

    public static boolean deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            return dir.delete();
        }
        boolean ret = true;
        File[] childFiles = dir.listFiles();
        for (int i = 0; i < childFiles.length; ++i) {
            ret = ret && FileUtils.deleteDirectory(childFiles[i]);
        }
        ret = ret && dir.delete();
        return ret;
    }

    private static class FileFilterImpl
    implements FileFilter {
        private String m_endsWith = null;

        FileFilterImpl(String endsWith) {
            this.m_endsWith = endsWith;
        }

        public boolean accept(File file) {
            if (file.isDirectory() || this.m_endsWith.equals("*")) {
                return true;
            }
            String filename = file.getAbsolutePath();
            return filename.endsWith(this.m_endsWith);
        }
    }
}

