/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileLock {
    private File _lock = null;
    private long _lastModified = 0L;
    private long _uniqueId = 0L;

    public FileLock(String path, long uniqueId) {
        this._lock = new File(path, ".lock");
        this._uniqueId = uniqueId;
    }

    public final boolean acquire() {
        boolean status = false;
        try {
            if (this._lock.createNewFile()) {
                this._lastModified = this._lock.lastModified();
                long id = this.checkIdentity(true);
                if (id == this._uniqueId) {
                    status = true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return status;
    }

    private final long checkIdentity(boolean updateIfEmpty) {
        long id = 0L;
        try {
            RandomAccessFile rf;
            block6: {
                rf = null;
                rf = updateIfEmpty ? new RandomAccessFile(this._lock, "rws") : new RandomAccessFile(this._lock, "r");
                try {
                    id = rf.readLong();
                    if (id == this._uniqueId) {
                        System.out.println("Lock already acquired ...");
                    } else {
                        System.out.println("Not Owner !!! - node owner is " + id);
                    }
                }
                catch (EOFException ex) {
                    if (!updateIfEmpty || rf == null) break block6;
                    rf.writeLong(this._uniqueId);
                    id = this._uniqueId;
                }
            }
            rf.close();
            this._lastModified = this._lock.lastModified();
        }
        catch (IOException ex2) {
            System.err.println("Cannot access file " + this._lock.getAbsolutePath());
        }
        return id;
    }

    public final boolean release() {
        boolean status = false;
        if (this._lock.exists() && this.checkIdentity(false) == this._uniqueId && !(status = this._lock.delete())) {
            System.err.println("Unable to delete lock file " + this._lock.getAbsolutePath());
        }
        return status;
    }

    public final long getTimeStamp() {
        return this._lastModified;
    }

    protected final void finalize() throws Throwable {
        this.release();
        super.finalize();
    }
}

