/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.DoubleLinkedListNode;
import java.util.ArrayList;

public class DoubleLinkedList {
    DoubleLinkedListNode head = null;
    DoubleLinkedListNode tail = null;

    public synchronized void addLast(DoubleLinkedListNode newNode) {
        if (this.tail == null) {
            this.head = this.tail = newNode;
            newNode.prev = null;
        } else {
            this.tail.next = newNode;
            newNode.prev = this.tail;
            this.tail = newNode;
        }
        newNode.next = null;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public synchronized boolean moveToLast(DoubleLinkedListNode moved) {
        if (this.tail == moved) {
            return true;
        }
        if (!this.remove(moved)) {
            return false;
        }
        this.addLast(moved);
        return true;
    }

    public synchronized DoubleLinkedListNode peek() {
        return this.head;
    }

    public synchronized boolean remove(DoubleLinkedListNode removed) {
        if (removed == null) {
            return true;
        }
        if (removed.removed()) {
            return false;
        }
        if (removed.next != null) {
            removed.next.prev = removed.prev;
        } else {
            this.tail = removed.prev;
        }
        if (removed.prev != null) {
            removed.prev.next = removed.next;
        } else {
            this.head = removed.next;
        }
        removed.next = removed;
        return true;
    }

    public synchronized boolean removeFirst() {
        return this.remove(this.head);
    }

    public synchronized DoubleLinkedListNode[] getAll() {
        ArrayList<DoubleLinkedListNode> list = new ArrayList<DoubleLinkedListNode>();
        DoubleLinkedListNode current = this.head;
        while (current != null) {
            list.add(current);
            current = current.next;
        }
        DoubleLinkedListNode[] nodes = new DoubleLinkedListNode[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nodes[i] = (DoubleLinkedListNode)list.get(i);
        }
        return nodes;
    }
}

