/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.xml.XMLUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import oracle.j2ee.server.OC4JShutdown;
import oracle.j2ee.server.OC4JStartup;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassDescriptor {
    public boolean mFailureIsFatal;
    public String mClassName;
    public Hashtable mProperties;
    public int mExecutionOrder;
    protected OC4JStartup mOC4JStartup;
    protected OC4JShutdown mOC4JShutdown;

    public ClassDescriptor(String className, boolean failureIsFatal) {
        this.mClassName = className;
        this.mFailureIsFatal = failureIsFatal;
        this.mProperties = new Hashtable();
        this.mExecutionOrder = Integer.MAX_VALUE;
    }

    public void setExecutionOrder(int executionOrder) {
        this.mExecutionOrder = executionOrder;
    }

    public int getExecutionOrder() {
        return this.mExecutionOrder;
    }

    public void addProperty(String key, String value) {
        this.mProperties.put(key, value);
    }

    public Hashtable getArgs() {
        return this.mProperties;
    }

    public Enumeration getKeys() {
        return this.mProperties.keys();
    }

    public String getValue(String key) {
        return (String)this.mProperties.get(key);
    }

    public void executeStartupClass(Context context, ClassLoader classLoader) throws Exception {
        try {
            if (this.mOC4JStartup == null) {
                this.mOC4JStartup = (OC4JStartup)Class.forName(this.mClassName, false, classLoader).newInstance();
                this.mOC4JStartup.preDeploy(this.mProperties, context);
            } else {
                this.mOC4JStartup.postDeploy(this.mProperties, context);
            }
        }
        catch (Exception e) {
            if (this.mFailureIsFatal) {
                throw e;
            }
            e.printStackTrace();
        }
    }

    public void executeShutdownClass(Context context, ClassLoader classLoader) throws Exception {
        try {
            if (this.mOC4JShutdown == null) {
                this.mOC4JShutdown = (OC4JShutdown)Class.forName(this.mClassName, false, classLoader).newInstance();
                this.mOC4JShutdown.preUndeploy(this.mProperties, context);
            } else {
                this.mOC4JShutdown.postUndeploy(this.mProperties, context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeXML(PrintWriter out, String indention, boolean isStartup) {
        if (isStartup) {
            out.print(indention + "<startup-class ");
            out.print("classname=\"" + this.mClassName + "\"");
            out.print(" failure-is-fatal=\"" + this.mFailureIsFatal + "\" ");
            if (this.writeSubXML(out, indention)) {
                out.println(indention + "</startup-class>");
            }
        } else {
            out.print(indention + "<shutdown-class ");
            out.print("classname=\"" + this.mClassName + "\" ");
            if (this.writeSubXML(out, indention)) {
                out.println(indention + "</shutdown-class>");
            }
        }
    }

    public boolean writeSubXML(PrintWriter out, String indention) {
        if (this.mExecutionOrder == Integer.MAX_VALUE && this.mProperties.isEmpty()) {
            out.println("/>");
            return false;
        }
        out.println(">");
        if (this.mExecutionOrder != Integer.MAX_VALUE) {
            out.println(indention + "\t<execution-order>" + this.mExecutionOrder + "</execution-order>");
        }
        if (!this.mProperties.isEmpty()) {
            Enumeration enum5 = this.mProperties.keys();
            while (enum5.hasMoreElements()) {
                String key = (String)enum5.nextElement();
                String value = (String)this.mProperties.get(key);
                out.println(indention + "\t<init-param>");
                out.println(indention + "\t\t<param-name>" + key + "</param-name>");
                out.println(indention + "\t\t<param-value>" + value + "</param-value>");
                out.println(indention + "\t</init-param>");
            }
        }
        return true;
    }

    public static void parseClasses(Node parent, String classType, ArrayList classArrayList) {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (!name.equals(classType)) continue;
                ClassDescriptor classDescriptor = ClassDescriptor.parseClass(node);
                boolean insertedClassDescriptor = false;
                for (int j = 0; j < classArrayList.size(); ++j) {
                    ClassDescriptor cd = (ClassDescriptor)classArrayList.get(j);
                    if (cd.getExecutionOrder() <= classDescriptor.getExecutionOrder()) continue;
                    classArrayList.add(j, classDescriptor);
                    insertedClassDescriptor = true;
                    break;
                }
                if (insertedClassDescriptor) continue;
                classArrayList.add(classDescriptor);
            }
        }
    }

    public static ClassDescriptor parseClass(Node parent) {
        String className = XMLUtils.getNodeAttribute(parent, "classname");
        boolean failureIsFatal = false;
        failureIsFatal = XMLUtils.getBooleanNodeAttribute(parent, "failure-is-fatal") == 1;
        ClassDescriptor classDescriptor = new ClassDescriptor(className, failureIsFatal);
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("execution-order")) {
                    try {
                        classDescriptor.setExecutionOrder(Integer.valueOf(XMLUtils.getStringValue(node)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!name.equals("init-param")) continue;
                ClassDescriptor.parseInitParam(node, classDescriptor);
            }
        }
        return classDescriptor;
    }

    protected static void parseInitParam(Node parent, ClassDescriptor classDescriptor) {
        NodeList list = parent.getChildNodes();
        String paramName = null;
        String paramValue = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            String name = node.getNodeName();
            if (name.equals("param-name")) {
                paramName = XMLUtils.getStringValue(node);
            }
            if (!name.equals("param-value")) continue;
            paramValue = XMLUtils.getStringValue(node);
        }
        if (paramName != null) {
            classDescriptor.addProperty(paramName, paramValue);
        }
    }
}

