/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.servlet;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class JNDIServlet
extends HttpServlet {
    InitialContext context;

    public void init() throws ServletException {
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            throw new ServletException("NamingException: " + e.getMessage());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
        out.println("<HTML><HEAD><TITLE>JNDI lookup</TITLE></HEAD><BODY>");
        String path = request.getPathInfo();
        try {
            if (path == null) {
                out.println("JNDI values: <br>");
                NamingEnumeration<NameClassPair> enumeration = this.context.list("");
                while (enumeration.hasMore()) {
                    NameClassPair pair = (NameClassPair)enumeration.nextElement();
                    out.println(pair.getName() + ": <A HREF=\"" + HttpUtils.getRequestURL((HttpServletRequest)request) + "/" + pair.getName() + "\">" + this.context.lookup(pair.getName()) + "</A><br>");
                }
            } else {
                StringTokenizer tokenizer = new StringTokenizer(path, "/");
                Object bean = this.context.lookup(tokenizer.nextToken());
                while (tokenizer.hasMoreElements() && bean != null) {
                    String node = tokenizer.nextToken();
                    BeanInfo info = Introspector.getBeanInfo(bean.getClass());
                    PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
                    PropertyDescriptor descriptor = null;
                    for (int i = 0; i < descriptors.length; ++i) {
                        if (!descriptors[i].getName().equalsIgnoreCase(node)) continue;
                        descriptor = descriptors[i];
                        break;
                    }
                    if (descriptor == null) {
                        out.println("Property not found");
                        continue;
                    }
                    Method readMethod = descriptor.getReadMethod();
                    if (readMethod != null) {
                        bean = descriptor.getReadMethod().invoke(bean, new Object[0]);
                        continue;
                    }
                    bean = "Not readable";
                }
                out.println("Bean: " + bean + ":<br>");
                if (bean != null) {
                    BeanInfo info = Introspector.getBeanInfo(bean.getClass());
                    PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
                    Object descriptor = null;
                    for (int i = 0; i < descriptors.length; ++i) {
                        out.println("<A HREF=\"" + HttpUtils.getRequestURL((HttpServletRequest)request) + "/" + descriptors[i].getName() + "\">" + descriptors[i].getName() + "</A><BR>");
                    }
                }
            }
            out.println("</BODY></HTML>");
            out.close();
        }
        catch (NamingException e) {
            throw new ServletException((Throwable)e);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }
}

