/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi.administration;

import com.evermind.server.administration.DefaultServerAdministrator;
import com.evermind.server.cluster.ServerIdentification;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIServer;
import com.evermind.server.rmi.RMIServerConnection;
import com.evermind.server.rmi.administration.RMIConnectionInfo;
import com.evermind.server.rmi.administration.RMIServerAdministrator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultRMIServerAdministrator
extends DefaultServerAdministrator
implements RMIServerAdministrator {
    private RMIServer server;

    public DefaultRMIServerAdministrator(RMIServer server) {
        super(server);
        this.server = server;
    }

    public List getClientInfo(String applicationName, int clusterMode) {
        List handlers = this.server.getConnections();
        ArrayList<RMIConnectionInfo> response = new ArrayList<RMIConnectionInfo>();
        for (int i = 0; i < handlers.size(); ++i) {
            RMIServerConnection connection = (RMIServerConnection)handlers.get(i);
            RMIConnectionInfo connectionInfo = connection.getConnectionInfo();
            if (clusterMode == 3 && connectionInfo.isCluster() || clusterMode == 2 && !connectionInfo.isCluster() || applicationName != null && !applicationName.equals(connectionInfo.getLastUsedApplication())) continue;
            response.add(connectionInfo);
        }
        return response;
    }

    public void disconnectClients(List clients, String message) {
        List connections = this.server.getConnections();
        for (int i = 0; i < connections.size(); ++i) {
            RMIConnection connection = (RMIConnection)connections.get(i);
            connection.disconnect(message, false);
        }
    }

    public Map getConfigurationInfo() throws InstantiationException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("port", new Integer(this.server.getConfig().getPort()));
        response.put("address", this.server.getConfig().getAddress().getHostAddress());
        return response;
    }

    public void setConfigurationInfo(Map info) throws UnknownHostException, IOException, InstantiationException {
        InetAddress address;
        String addressString;
        Integer port = (Integer)info.get("port");
        boolean updated = false;
        boolean connectorUpdated = false;
        if (port.intValue() != this.server.getConfig().getPort()) {
            this.server.getConfig().setPort(port);
            updated = true;
            connectorUpdated = true;
        }
        if ((addressString = (String)info.get("address")).equalsIgnoreCase("[ALL]")) {
            addressString = "0.0.0.0";
        }
        if (!(address = InetAddress.getByName(addressString)).equals(this.server.getConfig().getAddress())) {
            this.server.getConfig().setAddress(address);
            updated = true;
            connectorUpdated = true;
        }
        if (updated) {
            this.server.getConfig().store();
        }
        if (connectorUpdated) {
            this.server.setConfig(this.server.getConfig());
        }
    }

    public ServerIdentification[] getKnownPeers() {
        if (this.server.getClusterManager() != null) {
            return this.server.getClusterManager().getKnownPeers();
        }
        return new ServerIdentification[0];
    }
}

