/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.reflect.InterfaceType;
import com.evermind.server.rmi.ClusterOnly;
import java.lang.reflect.Constructor;
import java.rmi.Remote;

public class RMIInterfaceType
extends InterfaceType {
    static final Class JAVA_RMI_REMOTE = Remote.class;
    static final Class CLUSTER_ONLY = ClusterOnly.class;
    private Class m_objectType;
    static /* synthetic */ Class class$java$lang$Object;

    public RMIInterfaceType(Class objectType) {
        this.m_objectType = objectType;
    }

    public RMIInterfaceType(Class[] interfaces, Constructor proxyConstructor) {
        super(interfaces, proxyConstructor);
    }

    public Class getObjectType() {
        return this.m_objectType;
    }

    public void initInterfaceTypes() {
        if (this.getInterfaces() != null) {
            return;
        }
        Class[] tempInterfaces = new Class[3];
        int count = 0;
        for (Class current = this.m_objectType; current != (class$java$lang$Object == null ? RMIInterfaceType.class$("java.lang.Object") : class$java$lang$Object); current = current.getSuperclass()) {
            Class<?>[] objectInterfaces = current.getInterfaces();
            for (int i = 0; i < objectInterfaces.length; ++i) {
                if (objectInterfaces[i] == JAVA_RMI_REMOTE || !JAVA_RMI_REMOTE.isAssignableFrom(objectInterfaces[i]) || CLUSTER_ONLY.isAssignableFrom(objectInterfaces[i])) continue;
                boolean contains = false;
                for (int y = 0; y < count; ++y) {
                    if (tempInterfaces[y].isAssignableFrom(objectInterfaces[i])) {
                        tempInterfaces[y] = objectInterfaces[i];
                        contains = true;
                        break;
                    }
                    if (!objectInterfaces[i].isAssignableFrom(tempInterfaces[y])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                if (count >= tempInterfaces.length) {
                    Class[] oldInterfaces = tempInterfaces;
                    tempInterfaces = new Class[oldInterfaces.length + 1];
                    System.arraycopy(oldInterfaces, 0, tempInterfaces, 0, oldInterfaces.length);
                }
                tempInterfaces[count++] = objectInterfaces[i];
            }
        }
        this.interfaces = new Class[count];
        System.arraycopy(tempInterfaces, 0, this.interfaces, 0, count);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RMIInterfaceType[ ");
        sb.append("proxyConstructor=").append(this.getProxyConstructor());
        sb.append("  interfaces={");
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.interfaces[i].getName());
        }
        sb.append('}');
        sb.append(']');
        return sb.toString();
    }

    boolean matchesType(Class type) {
        return this.m_objectType == type;
    }
}

