/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.administration.RemoteData;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIClientContext;
import java.io.IOException;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import javax.naming.NamingException;

public class RMIClassLoader
extends SecureClassLoader {
    private RMIClientConnection connection;
    private RMIClientContext m_context;

    RMIClassLoader(ClassLoader parent, RMIClientConnection connection, RMIClientContext context) {
        super(parent);
        if (parent == null) {
            throw new IllegalArgumentException("must specify parent classloader");
        }
        this.connection = connection;
        this.m_context = context;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (name.indexOf("__Proxy") < 0) {
            try {
                byte[] data;
                RemoteData remoteData = this.connection.getServerClass(this.m_context, name, this.getClassLastModified(name));
                byte[] byArray = data = remoteData == null ? null : remoteData.getData();
                if (data != null) {
                    return this.defineClass(name, data, 0, data.length, (CodeSource)null);
                }
            }
            catch (IOException e) {
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    public long getClassLastModified(String name) {
        return -1L;
    }
}

