/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIInterfaceType;
import com.evermind.server.rmi.RemoteInvocationHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;

public class ObjectInfo
implements Serializable,
Externalizable {
    long id;
    long checksum;
    int type;
    String[] interfaceNames;
    public static final long serialVersionUID = 2676799332747648088L;

    public RemoteInvocationHandler createRemoteInvocationHandler(RMIClientConnection connection, RMIContext context) {
        return new RemoteInvocationHandler(connection, context);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.interfaceNames == null ? 0 : this.interfaceNames.length);
        if (this.interfaceNames != null) {
            for (int i = 0; i < this.interfaceNames.length; ++i) {
                out.writeUTF(this.interfaceNames[i]);
            }
        }
        out.writeInt(this.type);
        out.writeLong(this.id);
        out.writeLong(this.checksum);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int numbers = in.read();
        if (numbers < 0 || numbers > 200) {
            throw new IOException("Invalid interface count");
        }
        this.interfaceNames = new String[numbers];
        for (int i = 0; i < this.interfaceNames.length; ++i) {
            this.interfaceNames[i] = in.readUTF();
        }
        this.type = in.readInt();
        this.id = in.readLong();
        this.checksum = in.readLong();
    }

    public int hashCode() {
        return this.type + (int)(this.id & 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ObjectInfo other = (ObjectInfo)obj;
        if (this.id != other.id || this.type != other.type || this.interfaceNames.length != other.interfaceNames.length) {
            return false;
        }
        for (int i = 0; i < this.interfaceNames.length; ++i) {
            if (this.interfaceNames[i].equals(other.interfaceNames[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "ObjectInfo [" + this.getContentString() + "]";
    }

    protected String getContentString() {
        StringBuffer sb = new StringBuffer("type=");
        sb.append(this.type).append(", id=").append(this.id).append(", checksum=").append(this.checksum);
        sb.append(", interfaces=").append(Arrays.asList(this.interfaceNames));
        return sb.toString();
    }

    public void initObjectInfo(long id, long checksum, int typeID, RMIInterfaceType type) {
        this.type = typeID;
        this.checksum = checksum;
        this.id = id;
        if (this.type < 0) {
            type.initInterfaceTypes();
            this.interfaceNames = new String[type.getInterfaces().length];
            for (int i = 0; i < this.interfaceNames.length; ++i) {
                this.interfaceNames[i] = type.getInterfaces()[i].getName();
            }
        }
    }
}

