/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.rmi.NamedObjectRemoteInvocationHandler;
import com.evermind.server.rmi.ObjectInfo;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RemoteInvocationHandler;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class NamedObjectInfo
extends ObjectInfo {
    private String contextName;
    public static final long serialVersionUID = 2676799332747648088L;

    public NamedObjectInfo() {
    }

    public NamedObjectInfo(String contextName) {
        this.contextName = contextName;
    }

    public RemoteInvocationHandler createRemoteInvocationHandler(RMIClientConnection connection, RMIContext context) {
        return new NamedObjectRemoteInvocationHandler(connection, context, this.contextName);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.contextName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.contextName = in.readUTF();
    }

    public int hashCode() {
        return super.hashCode() + this.contextName.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.contextName.equals(((NamedObjectInfo)obj).contextName);
    }

    public String toString() {
        return "NamedObjectInfo[ contextName=" + this.contextName + ", " + this.getContentString() + "]";
    }
}

