/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindTopicConnection;
import com.evermind.server.multicastjms.EvermindTopicSession;
import com.evermind.server.multicastjms.JMSTransactionParticipation;
import com.evermind.util.ExternalComparator;
import com.evermind.util.ExternalHashMap;
import java.util.ArrayList;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class EvermindXATopicSession
extends EvermindTopicSession
implements XATopicSession,
XAResource,
ExternalComparator {
    protected int timeout;
    protected Map transactions = new ExternalHashMap(this);
    protected JMSTransactionParticipation currentTransaction;
    protected int transactionTimeout;

    public XAResource getXAResource() {
        return this;
    }

    public synchronized void end(Xid xid, int i) {
    }

    public synchronized void forget(Xid xid1) {
    }

    public synchronized int prepare(Xid id) {
        return 0;
    }

    public int hashCode(Object object) {
        try {
            int i;
            Xid xid = (Xid)object;
            int code = 0;
            byte[] id = xid.getGlobalTransactionId();
            for (i = 0; i < id.length; ++i) {
                code = code * 2 + id[i];
            }
            id = xid.getBranchQualifier();
            for (i = 0; i < id.length; ++i) {
                code = code * 2 + id[i];
            }
            return code += xid.getFormatId();
        }
        catch (ClassCastException _ex) {
            return object.hashCode();
        }
    }

    public EvermindXATopicSession(EvermindTopicConnection connection) {
        super(connection, false, 1);
    }

    public boolean isSameRM(XAResource resource) {
        return resource instanceof EvermindTopicConnection;
    }

    public synchronized Xid[] recover(int status) {
        return new Xid[0];
    }

    public synchronized void rollback(Xid xid) throws XAException {
        JMSTransactionParticipation transaction = (JMSTransactionParticipation)this.transactions.remove(xid);
        if (transaction == null) {
            throw new XAException(-5);
        }
        if (transaction == this.currentTransaction) {
            this.currentTransaction = null;
        }
    }

    public void addTransactionMessage(EvermindMessage message) {
        if (this.currentTransaction != null) {
            if (this.currentTransaction.messages == null) {
                this.currentTransaction.messages = new ArrayList();
            }
            this.currentTransaction.messages.add(message);
            return;
        }
        super.addTransactionMessage(message);
    }

    public int getTransactionTimeout() {
        return this.timeout;
    }

    public boolean getTransacted() {
        if (this.currentTransaction != null) {
            return true;
        }
        return super.getTransacted();
    }

    public boolean setTransactionTimeout(int timeout) {
        this.timeout = timeout;
        return true;
    }

    public boolean equals(Object a, Object b) {
        try {
            int i;
            Xid xidA = (Xid)a;
            Xid xidB = (Xid)b;
            byte[] idA = xidA.getGlobalTransactionId();
            byte[] idB = xidB.getGlobalTransactionId();
            if (idA.length != idB.length) {
                return false;
            }
            for (i = 0; i < idA.length; ++i) {
                if (idA[i] == idB[i]) continue;
                return false;
            }
            idA = xidA.getBranchQualifier();
            if (idA.length != (idB = xidB.getBranchQualifier()).length) {
                return false;
            }
            for (i = 0; i < idA.length; ++i) {
                if (idA[i] == idB[i]) continue;
                return false;
            }
            return xidA.getFormatId() == xidB.getFormatId();
        }
        catch (ClassCastException _ex) {
            return a.equals(b);
        }
    }

    public void addTransactionAcknowledgedMessage(EvermindMessage message) {
        if (this.currentTransaction != null) {
            this.currentTransaction.addTransactionAcknowledgedMessage(message);
            return;
        }
        super.addTransactionAcknowledgedMessage(message);
    }

    public synchronized void start(Xid xid, int status) {
        this.currentTransaction = new JMSTransactionParticipation(xid);
        this.transactions.put(xid, this.currentTransaction);
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        JMSTransactionParticipation transaction = (JMSTransactionParticipation)this.transactions.remove(xid);
        if (transaction == null) {
            throw new XAException(-5);
        }
        if (transaction == this.currentTransaction) {
            this.currentTransaction = null;
        }
        try {
            if (transaction.messages != null) {
                this.publish(transaction.messages);
                return;
            }
        }
        catch (JMSException e) {
            XAException xae = new XAException("Error sending JMS-messages");
            xae.initCause(e);
            throw xae;
        }
    }

    public TopicSession getTopicSession() {
        return this;
    }

    public Session getSession() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }
}

