/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindTopicConnectionFactory;
import com.evermind.server.multicastjms.JMSServer;
import com.evermind.server.multicastjms.LocalXATopicConnection;
import com.evermind.server.multicastjms.MulticastXATopicConnection;
import com.evermind.server.multicastjms.PointcastXATopicConnection;
import com.evermind.server.multicastjms.deployment.TopicConnectionFactoryConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;

public class EvermindXATopicConnectionFactory
extends EvermindTopicConnectionFactory
implements XATopicConnectionFactory {
    public EvermindXATopicConnectionFactory(TopicConnectionFactoryConfig config, JMSServer server) throws UnknownHostException, InstantiationException {
        super(config, server);
    }

    public EvermindXATopicConnectionFactory(InetAddress address, int port, int id, String username, String password) {
        super(address, port, id, username, password);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        try {
            if (this.server != null && (this.address.equals(this.server.getConfig().getAddress()) || this.address.equals(InetAddress.getByName("127.0.0.1")) && this.server.getConfig().getAddress().equals(InetAddress.getByName("0.0.0.0")) && this.port == this.server.getConfig().getPort())) {
                return new LocalXATopicConnection(this.server);
            }
        }
        catch (IOException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        try {
            if (this.address.isMulticastAddress()) {
                return new MulticastXATopicConnection(this.address, this.port, this.id);
            }
            return new PointcastXATopicConnection(this.address, this.port, this.username, this.password);
        }
        catch (IOException e) {
            throw new JMSException("Unable to connect");
        }
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        try {
            if (this.server != null && (this.address.equals(this.server.getConfig().getAddress()) || this.address.equals(InetAddress.getByName("127.0.0.1")) && this.server.getConfig().getAddress().equals(InetAddress.getByName("0.0.0.0")) && this.port == this.server.getConfig().getPort())) {
                return new LocalXATopicConnection(this.server);
            }
        }
        catch (IOException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        try {
            if (this.address.isMulticastAddress()) {
                return new MulticastXATopicConnection(this.address, this.port, this.id);
            }
            return new PointcastXATopicConnection(this.address, this.port, username, password);
        }
        catch (IOException e) {
            throw new JMSException("Unable to connect");
        }
    }

    public XAConnection createXAConnection() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public XAConnection createXAConnection(String user, String pwd) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }
}

