/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindBytesMessage;
import com.evermind.server.multicastjms.EvermindMapMessage;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindObjectMessage;
import com.evermind.server.multicastjms.EvermindStreamMessage;
import com.evermind.server.multicastjms.EvermindTextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public abstract class EvermindSession
implements Session {
    protected static int currentID;
    protected int acknowledgeMode;
    protected MessageListener messageListener;
    int id;
    protected List transactionMessages;
    protected EvermindMessage[] unacknowledgedMessages;
    protected int unacknowledgedMessagesCount;
    protected EvermindMessage[] transactionAcknowledgedMessages;
    protected int transactionAcknowledgedMessagesCount;

    public EvermindSession(boolean transacted, int acknowledgeMode) {
        if (transacted) {
            this.transactionMessages = new ArrayList();
        }
        this.acknowledgeMode = acknowledgeMode;
        this.id = currentID++;
    }

    public Message createMessage() {
        return new EvermindMessage();
    }

    public MapMessage createMapMessage() {
        return new EvermindMapMessage();
    }

    public ObjectMessage createObjectMessage() {
        return new EvermindObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return new EvermindObjectMessage(object);
    }

    public TextMessage createTextMessage() {
        return new EvermindTextMessage();
    }

    public TextMessage createTextMessage(String text) {
        return new EvermindTextMessage(text);
    }

    public TextMessage createTextMessage(StringBuffer buffer) {
        return new EvermindTextMessage(buffer.toString());
    }

    public BytesMessage createBytesMessage() {
        EvermindBytesMessage message = new EvermindBytesMessage(true);
        return message;
    }

    public StreamMessage createStreamMessage() {
        EvermindStreamMessage message = new EvermindStreamMessage(true);
        return message;
    }

    public void setMessageListener(MessageListener listener) {
        this.messageListener = listener;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void close() throws JMSException {
    }

    public boolean getTransacted() {
        return this.transactionMessages != null;
    }

    protected void intercept() {
    }

    public synchronized void addUnacknowledgedMessage(EvermindMessage message) {
        if (this.unacknowledgedMessagesCount == 0) {
            if (this.unacknowledgedMessages == null) {
                this.unacknowledgedMessages = new EvermindMessage[2];
            }
            this.unacknowledgedMessages[0] = message;
            this.unacknowledgedMessagesCount = 1;
        } else {
            if (this.unacknowledgedMessagesCount >= this.unacknowledgedMessages.length) {
                EvermindMessage[] newMessages = new EvermindMessage[this.unacknowledgedMessages.length * 2];
                System.arraycopy(this.unacknowledgedMessages, 0, newMessages, 0, this.unacknowledgedMessages.length);
                this.unacknowledgedMessages = newMessages;
            }
            this.unacknowledgedMessages[this.unacknowledgedMessagesCount++] = message;
        }
    }

    public synchronized void addTransactionAcknowledgedMessage(EvermindMessage message) {
        if (this.transactionAcknowledgedMessagesCount == 0) {
            if (this.transactionAcknowledgedMessages == null) {
                this.transactionAcknowledgedMessages = new EvermindMessage[2];
            }
            this.transactionAcknowledgedMessages[0] = message;
            this.transactionAcknowledgedMessagesCount = 1;
        } else {
            if (this.transactionAcknowledgedMessagesCount >= this.transactionAcknowledgedMessages.length) {
                EvermindMessage[] newMessages = new EvermindMessage[this.transactionAcknowledgedMessages.length * 2];
                System.arraycopy(this.transactionAcknowledgedMessages, 0, newMessages, 0, this.transactionAcknowledgedMessages.length);
                this.transactionAcknowledgedMessages = newMessages;
            }
            this.transactionAcknowledgedMessages[this.transactionAcknowledgedMessagesCount++] = message;
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public MessageProducer createProducer(Destination d) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public MessageConsumer createConsumer(Destination d) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public MessageConsumer createConsumer(Destination d, String selector) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public MessageConsumer createConsumer(Destination d, String selector, boolean nolocal) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public Queue createQueue(String name) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public Topic createTopic(String name) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public TopicSubscriber createDurableSubscriber(Topic t, String name) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public TopicSubscriber createDurableSubscriber(Topic t, String name, String selector, boolean nolocal) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public QueueBrowser createBrowser(Queue q) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public QueueBrowser createBrowser(Queue q, String selector) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public void unsubscribe(String name) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }
}

