/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class EvermindBytesMessage
extends EvermindMessage
implements BytesMessage {
    protected byte[] data;
    protected int pos;
    protected int length;
    boolean inReadMode;

    public EvermindBytesMessage(boolean writeMode) {
        if (writeMode) {
            this.data = new byte[40];
        } else {
            this.inReadMode = true;
        }
    }

    public int getTypeID() {
        return 2;
    }

    public void read(InputStream in, DataInputStream dataIn) throws IOException {
        super.read(in, dataIn);
        this.inReadMode = true;
        this.length = dataIn.readInt();
        this.data = new byte[this.length];
        in.read(this.data);
    }

    public void write(OutputStream out, DataOutputStream dataOut) throws IOException {
        super.write(out, dataOut);
        dataOut.writeInt(this.length);
        out.write(this.data, 0, this.length);
    }

    public void writeBoolean(boolean value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = value ? (byte)1 : 0;
    }

    public void writeShort(short value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length >= this.data.length - 1) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeInt(int value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length >= this.data.length - 3) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeDouble(double doubleValue) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length >= this.data.length - 7) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        long value = Double.doubleToLongBits(doubleValue);
        this.data[this.length++] = (byte)(value >>> 56);
        this.data[this.length++] = (byte)(value >>> 48);
        this.data[this.length++] = (byte)(value >>> 40);
        this.data[this.length++] = (byte)(value >>> 32);
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeBytes(byte[] value) throws MessageNotWriteableException, JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length >= this.data.length - length) {
            int newLength = this.data.length * 2;
            while (this.length >= newLength - length) {
                newLength *= 2;
            }
            byte[] newData = new byte[newLength];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        System.arraycopy(value, offset, this.data, this.length, length);
        this.length += length;
    }

    public void writeChar(char value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length >= this.data.length - 1) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeByte(byte value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length >= this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = value;
    }

    public void writeLong(long value) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length >= this.data.length - 7) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = (byte)(value >>> 56);
        this.data[this.length++] = (byte)(value >>> 48);
        this.data[this.length++] = (byte)(value >>> 40);
        this.data[this.length++] = (byte)(value >>> 32);
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeFloat(float floatValue) throws MessageNotWriteableException, JMSException {
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        if (this.length >= this.data.length - 3) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        int value = Float.floatToIntBits(floatValue);
        this.data[this.length++] = (byte)(value >>> 24);
        this.data[this.length++] = (byte)(value >>> 16);
        this.data[this.length++] = (byte)(value >>> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeUTF(String string) throws MessageNotWriteableException, JMSException {
        char c;
        int i;
        if (this.inReadMode) {
            throw new MessageNotWriteableException("Not in write-mode");
        }
        int stringLength = string.length();
        int utfLength = 0;
        for (i = 0; i < stringLength; ++i) {
            c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLength;
                continue;
            }
            if (c > '\u07ff') {
                utfLength += 3;
                continue;
            }
            utfLength += 2;
        }
        if (utfLength > 65535) {
            throw new JMSException("Too long String");
        }
        while (this.length + 2 + stringLength > this.data.length) {
            byte[] newData = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.length++] = (byte)(utfLength >>> 8 & 0xFF);
        this.data[this.length++] = (byte)(utfLength >>> 0 & 0xFF);
        for (i = 0; i < stringLength; ++i) {
            c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.data[this.length++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.data[this.length++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.data[this.length++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.data[this.length++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.data[this.length++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.data[this.length++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public void writeObject(Object object) throws MessageNotWriteableException, JMSException {
        if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof String) {
            this.writeUTF((String)object);
        } else {
            throw new MessageFormatException("Invalid type");
        }
    }

    public boolean readBoolean() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        return this.data[this.pos++] == 1;
    }

    public byte readByte() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        return this.data[this.pos++];
    }

    public short readShort() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length - 1) {
            throw new MessageEOFException("End of message reached");
        }
        return (short)((((char)this.data[this.pos++] & 0xFF) << 8) + ((char)this.data[this.pos++] & 0xFF));
    }

    public int readUnsignedShort() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length - 1) {
            throw new MessageEOFException("End of message reached");
        }
        return (((char)this.data[this.pos++] & 0xFF) << 8) + ((char)this.data[this.pos++] & 0xFF);
    }

    public int readInt() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length - 3) {
            throw new MessageEOFException("End of message reached");
        }
        return (((char)this.data[this.pos++] & 0xFF) << 24) + (((char)this.data[this.pos++] & 0xFF) << 16) + (((char)this.data[this.pos++] & 0xFF) << 8) + ((char)this.data[this.pos++] & 0xFF);
    }

    public long readLong() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        return Float.intBitsToFloat(this.readInt());
    }

    public char readChar() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length - 1) {
            throw new MessageEOFException("End of message reached");
        }
        return (char)((((char)this.data[this.pos++] & 0xFF) << 8) + ((char)this.data[this.pos++] & 0xFF));
    }

    public String readUTF() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        int utfLength = this.readUnsignedShort();
        char[] string = new char[utfLength];
        int count = 0;
        int stringLength = 0;
        block5: while (count < utfLength) {
            int c = this.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    string[stringLength++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utfLength) {
                        throw new JMSException("UTFDataFormatException");
                    }
                    int char2 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new JMSException("UTFDataFormatException");
                    }
                    string[stringLength++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utfLength) {
                        throw new JMSException("UTFDataFormatException");
                    }
                    int char2 = this.readUnsignedByte();
                    int char3 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new JMSException("UTFDataFormatException");
                    }
                    string[stringLength++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new JMSException("UTFDataFormatException");
        }
        return new String(string, 0, stringLength);
    }

    public int readBytes(byte[] value) throws MessageNotReadableException, JMSException {
        return this.readBytes(value, 0, value.length);
    }

    public int readBytes(byte[] value, int start, int length) throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (length < 0 || length > value.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal length: " + length);
        }
        if (this.pos + length > this.length) {
            if (this.pos >= this.length) {
                return -1;
            }
            int left = this.length - this.pos;
            System.arraycopy(this.data, this.pos, value, start, left);
            this.pos = this.length;
            return left;
        }
        System.arraycopy(this.data, this.pos, value, start, length);
        this.pos += length;
        return length;
    }

    public int readBytes(byte[] value, int length) throws MessageNotReadableException, JMSException {
        return this.readBytes(value, 0, length);
    }

    public int readUnsignedByte() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        if (this.pos >= this.length) {
            throw new MessageEOFException("End of message reached");
        }
        return this.data[this.pos++] & 0xFF;
    }

    public double readDouble() throws MessageNotReadableException, JMSException {
        if (!this.inReadMode) {
            throw new MessageNotReadableException("not in read-mode");
        }
        return Double.longBitsToDouble(this.readLong());
    }

    public void reset() {
        this.inReadMode = true;
        this.pos = 0;
        if (this.data == null) {
            this.data = new byte[40];
        }
    }

    public EvermindMessage cloneMessage() {
        return this.clone(new EvermindBytesMessage(false));
    }

    public EvermindBytesMessage clone(EvermindBytesMessage other) {
        other.data = this.data;
        other.pos = 0;
        other.length = this.length;
        other.inReadMode = true;
        return (EvermindBytesMessage)super.clone(other);
    }

    public long getBodyLength() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }
}

