/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.multicastjms.CMTTopicPublisher;
import com.evermind.server.multicastjms.CMTTopicSubscriber;
import com.evermind.server.multicastjms.FilterSession;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XATopicSession;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class CMTTopicSession
extends FilterSession
implements TopicSession {
    private ApplicationServerTransaction currentTransaction;
    private XATopicSession session;

    public CMTTopicSession(XATopicSession session) {
        super((Session)session);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return new CMTTopicSubscriber(this, this.session.getTopicSession().createDurableSubscriber(topic, name));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return new CMTTopicSubscriber(this, this.session.getTopicSession().createDurableSubscriber(topic, name, messageSelector, noLocal));
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return new CMTTopicSubscriber(this, this.session.getTopicSession().createSubscriber(topic));
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return new CMTTopicSubscriber(this, this.session.getTopicSession().createSubscriber(topic, messageSelector, noLocal));
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return new CMTTopicPublisher(this, this.session.getTopicSession().createPublisher(topic));
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.session.getTopicSession().createTemporaryTopic();
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.session.getTopicSession().createTopic(topicName);
    }

    public void intercept() throws JMSException {
        Transaction tx = null;
        try {
            tx = ApplicationServer.getInstance().getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (tx != this.currentTransaction) {
            if (tx == null) {
                this.currentTransaction = null;
            } else {
                try {
                    JMSMessages.infoDirectEnlistment();
                    tx.enlistResource(this.session.getXAResource());
                }
                catch (RollbackException e) {
                    throw new JMSException("Transaction was rolled back while adding XAResource: " + e.getMessage());
                }
                catch (SystemException e) {
                    throw new JMSException("System error while adding XAResource: " + e.getMessage());
                }
            }
        }
    }

    public void unsubscribe(String name) throws JMSException {
        this.session.getTopicSession().unsubscribe(name);
    }
}

