/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.FieldAccess;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.NoSuchFieldException;
import com.evermind.server.jms.filter.StringExpression;
import javax.jms.Message;

class StringFieldName
extends StringExpression {
    private String m_fieldName;
    private FieldAccess acc;

    StringFieldName(String name, FieldAccess acc) {
        super(name);
        this.m_fieldName = name;
        this.acc = acc;
    }

    public void eval(Message m) {
        this.m_null = false;
        String s = null;
        try {
            Object o = this.acc.getValue(m);
            if (o instanceof String) {
                s = (String)o;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (s == null) {
            this.m_null = true;
        } else {
            this.m_val = s;
        }
    }

    public boolean equals(Object op) {
        if (op instanceof StringFieldName) {
            return this.m_fieldName.equals(((StringFieldName)op).m_fieldName);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        return app.apply(this);
    }
}

