/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServer;
import com.evermind.server.XMLApplicationServerConfig;
import com.evermind.server.XMLServerConfig;
import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindQueue;
import com.evermind.server.jms.EvermindTopic;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSServerUtils;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.KnobsController;
import com.evermind.server.jms.ServerConnectionFactory;
import com.evermind.server.jms.ServerDestination;
import com.evermind.server.jms.ServerQueueConnectionFactory;
import com.evermind.server.jms.ServerTopicConnectionFactory;
import com.evermind.server.jms.Tset;
import com.evermind.server.jms.XMLConfigBroadcaster;
import com.evermind.server.jms.XMLConfigPropertiesController;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.j2ee.jms.oc4j.v1.JMSServerConfig;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLJMSServerConfig
extends XMLServerConfig
implements JMSServerConfig,
ConfigPropertyListener {
    private final XMLConfigPropertiesController m_cpc = KnobsController.getKnobsController();
    private String m_version;
    private final Map m_queues = new HashMap();
    private final Map m_topics = new HashMap();
    private final List m_cfs = new ArrayList();
    private final List m_qcfs = new ArrayList();
    private final List m_tcfs = new ArrayList();
    private final Map m_n2L = new HashMap();
    private final Map m_n2O = new HashMap();
    private final List m_exList = new ArrayList();
    private String m_host = null;
    private String m_port = null;
    private boolean m_writeable = true;
    private final Tset m_isEnabled = new Tset(true);
    private final Tset m_isDirty = new Tset(false);
    private final XMLConfigBroadcaster m_broadcaster = XMLConfigBroadcaster.getBroadcaster();
    private String httpTunnelAuthentication = "required";
    private String httpTunnelAuthorization = "required";
    private boolean httpTunnelEnabled = false;
    private boolean tcpRelayEnabled = false;
    private String tcpRelayFilter = "auto";
    private int tcpRelayTimeout = 5000;
    private final List tcpRelayList = new ArrayList();
    private static final String AUTHENTICATION = "authentication";
    private static final String AUTHORIZATION = "authorization";
    private static final String FILTER = "filter";
    private static final String TIMEOUT = "timeout";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String DISABLED = "deactivated";
    private static final String INDENT = "    ";
    private static final String INDENT2 = "        ";
    private static final String VERSION_10_0 = "10.0";
    private static final String VERSION_10_1 = "10.1";
    static final long serialVersionUID = -6556696856015797395L;

    public XMLJMSServerConfig(XMLApplicationServerConfig parent) {
        super(parent);
    }

    public static void removeAllJMSResourceMBeans() {
    }

    public String toString() {
        return "XMLJMSServerConfig[" + super.toString() + "]";
    }

    public synchronized void init(URL url) throws InstantiationException, IOException {
        super.init(url);
        if (OC4JServer.getOPMNEnabled()) {
            this.setPort(JMSServerUtils.getPort(9127));
        }
    }

    protected synchronized void verifyDocumentType(String name) throws InstantiationException {
        if (name.equals("jms")) {
            this.m_version = VERSION_10_1;
        } else if (name.equals("jms-server")) {
            this.m_version = VERSION_10_0;
            JMSMessages.infoUpdatingSchemaVersion();
        } else {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03200", this, name));
        }
    }

    protected synchronized void writeConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println("");
        out.println("<jms xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.oracle.com/technology/oracleas/schema/jms-server-10_1.xsd\" " + (this.getEnabled() ? "" : "deactivated=\"true\" ") + "schema-major-version=\"10\" schema-minor-version=\"1\">");
        out.println("    <!-- configuration auto-generated [" + new Date() + "] -->");
        out.println("    <jms-server host=\"" + JMSUtils.normalize(this.m_host) + "\" " + "port=\"" + this.m_port + "\">");
        out.println("\n");
        out.println("");
        this.writeHttpTunneling(out);
        this.writeXML(out, "queues", this.m_queues);
        this.writeXML(out, "topics", this.m_topics);
        this.writeXML(out, "unified connection factories", this.m_cfs.iterator());
        this.writeXML(out, "queue   connection factories", this.m_qcfs.iterator());
        this.writeXML(out, "topic   connection factories", this.m_tcfs.iterator());
        out.println("        <!-- generic -->");
        if (this.logConfig != null) {
            this.logConfig.write(out, "\t");
        }
        this.m_cpc.writeXML(out, INDENT2);
        out.println("");
        out.println("    </jms-server>");
        this.m_broadcaster.writeConfigElements(out, INDENT);
        out.println("</jms>");
    }

    protected synchronized int getDefaultPort() {
        return 9127;
    }

    protected synchronized void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
        if (!this.m_writeable) {
            return;
        }
        if (HOST.equals(name)) {
            if (this.m_version.equals(VERSION_10_0)) {
                this.m_host = value;
            } else {
                JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03200", this, name));
            }
        } else if (PORT.equals(name) && this.m_version.equals(VERSION_10_0)) {
            if (this.m_version.equals(VERSION_10_0)) {
                this.m_port = value;
            } else {
                JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03200", this, name));
            }
        } else if (DISABLED.equals(name)) {
            Boolean disable = Boolean.valueOf(value);
            this.setEnabled(new Boolean(disable == false));
        } else {
            super.parseDeploymentRootNodeValue(name, value);
        }
    }

    protected synchronized void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        try {
            if (this.m_version.equals(VERSION_10_0)) {
                if (!this.m_writeable) {
                    return;
                }
                this.parseJmsServerNode(node);
            } else if (name.equals("jms-server")) {
                if (!this.m_writeable) {
                    return;
                }
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    for (int index = 0; index < attrs.getLength(); ++index) {
                        Node attr = attrs.item(index);
                        String attrName = attr.getNodeName();
                        if (HOST.equals(attrName)) {
                            this.m_host = attr.getNodeValue();
                            continue;
                        }
                        if (!PORT.equals(attrName)) continue;
                        this.m_port = attr.getNodeValue();
                    }
                }
                NodeList nodes = node.getChildNodes();
                for (int index = 0; index < nodes.getLength(); ++index) {
                    if (nodes.item(index).getNodeName().startsWith("#")) continue;
                    this.parseJmsServerNode(nodes.item(index));
                }
            } else {
                this.m_broadcaster.broadcastUpdate(this, node);
            }
        }
        catch (Throwable ex) {
            this.m_exList.add(ex);
        }
    }

    private void parseJmsServerNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        try {
            if (name.equals("queue")) {
                this.parseQueueNode(node);
            } else if (name.equals("topic")) {
                this.parseTopicNode(node);
            } else if (name.equals("connection-factory")) {
                this.m_cfs.add(new ServerConnectionFactory(node, false));
            } else if (name.equals("xa-connection-factory")) {
                this.m_cfs.add(new ServerConnectionFactory(node, true));
            } else if (name.equals("queue-connection-factory")) {
                this.m_qcfs.add(new ServerQueueConnectionFactory(node, false));
            } else if (name.equals("xa-queue-connection-factory")) {
                this.m_qcfs.add(new ServerQueueConnectionFactory(node, true));
            } else if (name.equals("topic-connection-factory")) {
                this.m_tcfs.add(new ServerTopicConnectionFactory(node, false));
            } else if (name.equals("xa-topic-connection-factory")) {
                this.m_tcfs.add(new ServerTopicConnectionFactory(node, true));
            } else if (name.equals("config-properties")) {
                this.setConfigProperties(node);
            } else if (name.equals("http-tunnel")) {
                this.parseHttpTunnelNode(node);
            } else {
                super.parseDeploymentMainNode(node);
            }
        }
        catch (Throwable ex) {
            this.m_exList.add(ex);
        }
    }

    private void parseHttpTunnelNode(Node node) throws InstantiationException {
        if (this.httpTunnelEnabled) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03311"));
        }
        this.httpTunnelEnabled = true;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int index = 0; index < attrs.getLength(); ++index) {
                Node attr = attrs.item(index);
                String attrName = attr.getNodeName();
                if (AUTHORIZATION.equals(attrName)) {
                    this.httpTunnelAuthorization = attr.getNodeValue();
                    continue;
                }
                if (!AUTHENTICATION.equals(attrName)) continue;
                this.httpTunnelAuthentication = attr.getNodeValue();
            }
            if (!this.httpTunnelAuthorization.equals("none") && !this.httpTunnelAuthorization.equals("required")) {
                JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03301", this, this.httpTunnelAuthorization));
            }
            if (!this.httpTunnelAuthentication.equals("none") && !this.httpTunnelAuthentication.equals("required")) {
                JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03300", this, this.httpTunnelAuthentication));
            }
        }
        NodeList nodes = node.getChildNodes();
        int numberOfTcpRelays = 0;
        for (int index = 0; index < nodes.getLength(); ++index) {
            if (nodes.item(index).getNodeName().startsWith("#")) continue;
            if (numberOfTcpRelays > 0) {
                JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03310"));
            } else {
                this.parseTcpRelayNode(nodes.item(index));
            }
            ++numberOfTcpRelays;
        }
    }

    private void parseTcpRelayNode(Node node) throws InstantiationException {
        NamedNodeMap attrs = node.getAttributes();
        if (!node.getNodeName().equals("tcp-relay")) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03303", this, node.getNodeName()));
        }
        this.tcpRelayEnabled = true;
        this.tcpRelayFilter = "list";
        if (attrs != null) {
            for (int index = 0; index < attrs.getLength(); ++index) {
                Node attr = attrs.item(index);
                String attrName = attr.getNodeName();
                if (FILTER.equals(attrName)) {
                    this.tcpRelayFilter = attr.getNodeValue();
                    continue;
                }
                if (!TIMEOUT.equals(attrName)) continue;
                try {
                    this.tcpRelayTimeout = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                catch (NumberFormatException ex) {
                    JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03305", this, attr.getNodeValue()));
                }
            }
            if (!this.tcpRelayFilter.equals("list") && !this.tcpRelayFilter.equals("auto")) {
                JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03304", this, this.tcpRelayFilter));
            }
            if (this.tcpRelayTimeout < 0) {
                JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03305", this, "" + this.tcpRelayTimeout));
            }
        }
        if (this.tcpRelayFilter.equals("list")) {
            NodeList nodes = node.getChildNodes();
            for (int index = 0; index < nodes.getLength(); ++index) {
                if (nodes.item(index).getNodeName().startsWith("#")) continue;
                this.parseTargetNode(nodes.item(index));
            }
        }
    }

    private void parseTargetNode(Node node) throws InstantiationException {
        NamedNodeMap attrs = node.getAttributes();
        if (!node.getNodeName().equals("target")) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03306", this, node.getNodeName()));
        }
        if (attrs != null) {
            String host = null;
            String port = null;
            for (int index = 0; index < attrs.getLength(); ++index) {
                Node attr = attrs.item(index);
                String attrName = attr.getNodeName();
                if (attrName.equals(HOST)) {
                    host = attr.getNodeValue();
                } else if (attrName.equals(PORT)) {
                    port = attr.getNodeValue();
                    try {
                        int foo = Integer.parseInt(port);
                    }
                    catch (NumberFormatException ex) {
                        JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03307", this, port));
                    }
                }
                if (host == null || port == null) continue;
                InetAddress inetHost = null;
                try {
                    inetHost = InetAddress.getByName(host);
                    this.tcpRelayList.add(inetHost.getCanonicalHostName() + ":" + port);
                }
                catch (UnknownHostException ex) {
                    JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03308", this, host));
                }
                host = null;
                port = null;
            }
        }
    }

    private void setConfigProperties(Node node) throws Exception {
        try {
            this.m_cpc.setConfigProperties(node);
        }
        catch (Exception ex) {
            this.store();
            throw ex;
        }
        finally {
            this.m_cpc.addConfigPropertyListener(this);
        }
    }

    public synchronized void refresh() throws InstantiationException {
        this.m_writeable = false;
        this.m_broadcaster.prepareForRefresh();
        this.update();
        this.m_broadcaster.commitRefresh();
        this.m_writeable = true;
        this.m_isDirty.set(true);
    }

    protected synchronized void postInit() throws InstantiationException {
        super.postInit();
        if (this.m_exList.size() != 0) {
            JMSUtils.toInstantiationException(this.m_exList);
        }
        this.buildMaps();
        this.m_isDirty.set(false);
    }

    protected synchronized void reset() {
        if (!this.m_writeable) {
            return;
        }
        super.reset();
        this.m_queues.clear();
        this.m_topics.clear();
        this.m_cfs.clear();
        this.m_qcfs.clear();
        this.m_tcfs.clear();
        this.m_n2L.clear();
        this.m_n2O.clear();
        this.m_isDirty.set(false);
    }

    public int getServerConnectionTimeout() {
        return 0;
    }

    private void autoAddDest(boolean isQueue, String name, String location, String persistence, String description) throws InstantiationException {
        if (!this.m_queues.containsKey(name) && !this.m_topics.containsKey(name)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", name);
            map.put("location", location);
            map.put("persistence-file", persistence);
            map.put("description", description);
            this.addDestination(isQueue, map);
        }
    }

    public synchronized void validate() throws InstantiationException {
        this.setAddress(JMSUtils.toAddress(this.m_host));
        if (!OC4JServer.getOPMNEnabled()) {
            this.setPort(JMSServerUtils.checkPort(this.m_port, 9127));
            this.m_port = "" + this.getPort();
        }
        if (this.m_exList.size() != 0) {
            JMSUtils.toInstantiationException(this.m_exList);
        }
        if (this.m_version.equals(VERSION_10_0)) {
            try {
                this.autoAddDest(true, "jms/RAExceptionQueue", "jms/RAExceptionQueue", null, "ResourceAdapter Exception Queue");
                this.autoAddDest(true, "jms/events", "jms/events", "scheduler_events", "Scheduler event queue SYSTEM DESTINATION - DO NOT DELETE");
                this.autoAddDest(true, "jms/jobstore", "jms/jobstore", "scheduler_jobstore", "Scheduler job store SYSTEM DESTINATION - DO NOT DELETE");
                this.autoAddDest(true, "jms/notifications", "jms/notifications", "scheduler_notifications", "Scheduler notification queue SYSTEM DESTINATION - DO NOT DELETE");
                this.store();
                this.m_version = VERSION_10_1;
            }
            catch (Throwable ex) {
                JMSUtils.toInstantiationException(ex.getMessage(), ex);
            }
        }
    }

    public synchronized Map getQueueMappings() {
        return this.m_queues;
    }

    public synchronized Map getTopicMappings() {
        return this.m_topics;
    }

    public synchronized List getConnectionFactories() {
        return this.m_cfs;
    }

    public synchronized List getQueueConnectionFactories() {
        return this.m_qcfs;
    }

    public synchronized List getTopicConnectionFactories() {
        return this.m_tcfs;
    }

    public synchronized boolean getEnabled() {
        return this.m_isEnabled.test();
    }

    public synchronized String getHttpTunnelAuthentication() {
        return this.httpTunnelAuthentication;
    }

    public synchronized String getHttpTunnelAuthorization() {
        return this.httpTunnelAuthorization;
    }

    public synchronized boolean getHttpTunnelEnabled() {
        return this.httpTunnelEnabled;
    }

    public synchronized boolean getTcpRelayEnabled() {
        return this.tcpRelayEnabled;
    }

    public synchronized String getTcpRelayFilter() {
        return this.tcpRelayFilter;
    }

    public synchronized int getTcpRelayTimeout() {
        return this.tcpRelayTimeout;
    }

    public synchronized List getTcpRelayList() {
        return this.tcpRelayList;
    }

    public boolean isDirty() {
        return this.m_isDirty.test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String list() throws IOException {
        String string;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            this.writeConfig(pw);
            pw.flush();
            sw.flush();
            string = sw.toString();
        }
        catch (Throwable throwable) {
            JMSUtils.closeIt(pw);
            JMSUtils.closeIt(sw);
            throw throwable;
        }
        JMSUtils.closeIt(pw);
        JMSUtils.closeIt(sw);
        return string;
    }

    public synchronized void sync() throws IOException, InstantiationException {
        this.store();
        this.m_isDirty.set(false);
    }

    public synchronized void server(String host, String port) throws InstantiationException {
        JMSServerUtils.checkPort(port, this.getPort());
        this.m_host = host;
        this.m_port = port;
        this.m_isDirty.set(true);
    }

    public void setEnabled(Boolean enable) {
        this.m_isEnabled.set(enable);
    }

    public synchronized ServerConnectionFactory addFactory(int domain, Map info) throws InstantiationException {
        ServerConnectionFactory cfg = null;
        String l = (String)info.get("location");
        if (this.m_n2O.containsKey(l)) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03201", this, l, info, this.m_n2O.get(l)));
        }
        switch (domain) {
            case 2: {
                cfg = new ServerConnectionFactory(info);
                this.m_cfs.add(cfg);
                break;
            }
            case 0: {
                cfg = new ServerQueueConnectionFactory(info);
                this.m_qcfs.add(cfg);
                break;
            }
            case 1: {
                cfg = new ServerTopicConnectionFactory(info);
                this.m_tcfs.add(cfg);
                break;
            }
            default: {
                JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03202", this, new Integer(domain)));
            }
        }
        this.buildMaps();
        this.m_isDirty.set(true);
        return cfg;
    }

    public synchronized void removeFactory(String location) throws InstantiationException {
        if (!this.m_n2O.containsKey(location)) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03203", this, location));
        }
        Object o = this.m_n2O.remove(location);
        List l = (List)this.m_n2L.remove(location);
        l.remove(o);
        this.m_isDirty.set(true);
    }

    public synchronized void addDestination(boolean isQ, Map info) throws InstantiationException {
        if (isQ) {
            EvermindQueue q = new EvermindQueue(info, this.getURL());
            this.add(q);
        } else {
            EvermindTopic t = new EvermindTopic(info, this.getURL());
            this.add(t);
        }
        this.m_isDirty.set(true);
    }

    public synchronized void removeDestination(String name) throws InstantiationException {
        if (this.m_queues.containsKey(name)) {
            this.m_queues.remove(name);
        } else if (this.m_topics.containsKey(name)) {
            this.m_topics.remove(name);
        } else {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03204", this, name));
        }
        this.m_isDirty.set(true);
    }

    public void onConfigPropertyChange(ConfigPropertyEvent event) {
        this.m_isDirty.set(true);
    }

    private void parseQueueNode(Node node) throws InstantiationException {
        EvermindQueue q = (EvermindQueue)ServerDestination.createDestination(node, true, this.getURL());
        this.add(q);
    }

    private void add(EvermindQueue q) throws InstantiationException {
        String name = q.getName();
        if (this.m_topics.containsKey(name)) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03205", this, "Queue", name, this.m_topics.get(name)));
        }
        if (this.m_queues.containsKey(name)) {
            throw new InstantiationException(JMSMessages.getMessage("J2EE JMS-02506", this, name));
        }
        this.m_queues.put(name, q);
    }

    private void parseTopicNode(Node node) throws InstantiationException {
        EvermindTopic t = (EvermindTopic)ServerDestination.createDestination(node, false, this.getURL());
        this.add(t);
    }

    private void add(EvermindTopic t) throws InstantiationException {
        String name = t.getName();
        if (this.m_queues.containsKey(name)) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03205", this, "Topic", name, this.m_queues.get(name)));
        }
        if (this.m_topics.containsKey(name)) {
            throw new InstantiationException(JMSMessages.getMessage("J2EE JMS-02506", this, name));
        }
        this.m_topics.put(name, t);
    }

    private void buildMaps() throws InstantiationException {
        this.m_n2L.clear();
        this.m_n2O.clear();
        this.buildMap(this.m_cfs);
        this.buildMap(this.m_qcfs);
        this.buildMap(this.m_tcfs);
    }

    private void buildMap(List list) throws InstantiationException {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ServerConnectionFactory c = (ServerConnectionFactory)iter.next();
            String l = c.getLocation();
            if (this.m_n2O.containsKey(l)) {
                JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-03201", this, l, c, this.m_n2O.get(l)));
            }
            this.m_n2L.put(l, list);
            this.m_n2O.put(l, c);
        }
    }

    private void writeHttpTunneling(PrintWriter out) throws IOException {
        if (!this.httpTunnelEnabled) {
            return;
        }
        out.println("        <!-- HTTP Tunnel -->");
        out.println("        <http-tunnel authentication=\"" + this.httpTunnelAuthentication + "\" authorization=\"" + this.httpTunnelAuthorization + "\">");
        if (this.tcpRelayEnabled) {
            out.println("            <tcp-relay filter=\"" + this.tcpRelayFilter + "\" timeout=\"" + this.tcpRelayTimeout + "\">");
            for (int i = 0; i < this.tcpRelayList.size(); ++i) {
                String target = (String)this.tcpRelayList.get(i);
                String host = target.substring(0, target.indexOf(":"));
                String port = target.substring(target.indexOf(":") + 1);
                out.println("                <target host=\"" + host + "\" port=\"" + port + "\"/>");
            }
            out.println("            </tcp-relay>");
        }
        out.println("        </http-tunnel>\n\n");
    }

    private void writeXML(PrintWriter out, String msg, Map map) throws IOException {
        out.println("        <!-- " + msg + " -->");
        Iterator iter = JMSUtils.sortXMLs(map.keySet().iterator());
        while (iter.hasNext()) {
            EvermindDestination dest = (EvermindDestination)map.get(iter.next());
            ServerDestination.writeXML(dest, out, INDENT2);
        }
        out.println("\n");
    }

    private void writeXML(PrintWriter out, String msg, Iterator iter) throws IOException {
        out.println("        <!-- " + msg + " -->");
        iter = JMSUtils.sortXMLs(iter);
        while (iter.hasNext()) {
            XMLizable xml = (XMLizable)iter.next();
            xml.writeXML(out, INDENT2);
        }
        out.println("\n");
    }

    protected void createDMSState(String dmsStr) {
        ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "jms_log", "", "JMS log file path", (Object)dmsStr);
    }
}

