/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.security.SecuritySensitive;
import com.evermind.server.jms.ConnectInfo;
import com.evermind.server.jms.EvermindConnectionFactory;
import com.evermind.server.jms.EvermindQueueConnectionFactory;
import com.evermind.server.jms.EvermindTopicConnectionFactory;
import com.evermind.server.jms.EvermindXAConnectionFactory;
import com.evermind.server.jms.EvermindXAQueueConnectionFactory;
import com.evermind.server.jms.EvermindXATopicConnectionFactory;
import com.evermind.server.jms.JMSServerUtils;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.ServerQueueConnectionFactory;
import com.evermind.server.jms.ServerTopicConnectionFactory;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public class ServerConnectionFactory
implements XMLizable {
    private final String m_location;
    private final String m_host;
    private final String m_port;
    private final String m_user;
    private final String m_pass;
    private final String m_clientID;
    private final String m_tunnel;
    private final String m_keystore;
    private final String m_keystorePassword;
    private final String m_truststore;
    private final String m_truststorePassword;
    private final String m_provider;
    private final boolean m_transactional;
    public static final String LOCATION = "location";
    public static final String DOMAIN = "domain";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String CLIENTID = "clientID";
    public static final String TUNNEL = "tunnel";
    public static final String KEYSTORE = "keystore";
    public static final String KEYSTORE_PASSWORD = "keystore-password";
    public static final String TRUSTSTORE = "truststore";
    public static final String TRUSTSTORE_PASSWORD = "truststore-password";
    public static final String PROVIDER = "provider";
    public static final String XA = "xa";
    public static final String UNIFIED = "unified";
    public static final String QUEUE = "queue";
    public static final String TOPIC = "topic";

    public ServerConnectionFactory(Node parent, boolean transactional) throws InstantiationException {
        this(ServerConnectionFactory.makeMap(parent, transactional));
    }

    public ServerConnectionFactory(Map info) throws InstantiationException {
        this.m_location = (String)info.get(LOCATION);
        this.m_host = (String)info.get(HOST);
        this.m_port = (String)info.get(PORT);
        this.m_tunnel = (String)info.get(TUNNEL);
        this.m_keystore = (String)info.get(KEYSTORE);
        this.m_keystorePassword = (String)info.get(KEYSTORE_PASSWORD);
        this.m_truststore = (String)info.get(TRUSTSTORE);
        this.m_truststorePassword = (String)info.get(TRUSTSTORE_PASSWORD);
        this.m_provider = (String)info.get(PROVIDER);
        this.m_user = (String)info.get(USERNAME);
        this.m_pass = (String)info.get(PASSWORD);
        this.m_clientID = (String)info.get(CLIENTID);
        this.m_transactional = info.containsKey(XA);
        JMSUtils.noNull(info, LOCATION, this.m_location);
        JMSServerUtils.checkPort(this.m_port, 9127);
        if (!JMSUtils.isNull(this.m_tunnel)) {
            JMSUtils.checkTunnelAttributes(info, this.m_location, this.m_tunnel, this.m_keystore, this.m_keystorePassword, this.m_truststore, this.m_truststorePassword, this.m_provider);
        }
    }

    public ConnectInfo getConnectionFactory(int domain) throws UnknownHostException, InstantiationException {
        return this.getConnectionFactory(InetAddress.getLocalHost(), 9127, domain);
    }

    public ConnectInfo getConnectionFactory(InetAddress defaultAddress, int defaultPort) throws UnknownHostException, InstantiationException {
        return this.getConnectionFactory(defaultAddress, defaultPort, 2);
    }

    public ConnectInfo getConnectionFactory(InetAddress defaultAddress, int defaultPort, int domain) throws UnknownHostException, InstantiationException {
        InetAddress connAddr = this.getConnectAddress(defaultAddress);
        int connPort = this.getConnectPort(defaultPort);
        if (!this.m_transactional) {
            if (domain == 0) {
                return new EvermindQueueConnectionFactory(connAddr, connPort, this.m_tunnel, this.m_keystore, this.m_keystorePassword, this.m_truststore, this.m_truststorePassword, this.m_provider, this.m_user, this.m_pass, this.m_clientID, false);
            }
            if (domain == 1) {
                return new EvermindTopicConnectionFactory(connAddr, connPort, this.m_tunnel, this.m_keystore, this.m_keystorePassword, this.m_truststore, this.m_truststorePassword, this.m_provider, this.m_user, this.m_pass, this.m_clientID, false);
            }
            return new EvermindConnectionFactory(connAddr, connPort, this.m_tunnel, this.m_keystore, this.m_keystorePassword, this.m_truststore, this.m_truststorePassword, this.m_provider, this.m_user, this.m_pass, this.m_clientID, false);
        }
        if (domain == 0) {
            return new EvermindXAQueueConnectionFactory(connAddr, connPort, this.m_tunnel, this.m_keystore, this.m_keystorePassword, this.m_truststore, this.m_truststorePassword, this.m_provider, this.m_user, this.m_pass, this.m_clientID);
        }
        if (domain == 1) {
            return new EvermindXATopicConnectionFactory(connAddr, connPort, this.m_tunnel, this.m_keystore, this.m_keystorePassword, this.m_truststore, this.m_truststorePassword, this.m_provider, this.m_user, this.m_pass, this.m_clientID);
        }
        return new EvermindXAConnectionFactory(connAddr, connPort, this.m_tunnel, this.m_keystore, this.m_keystorePassword, this.m_truststore, this.m_truststorePassword, this.m_provider, this.m_user, this.m_pass, this.m_clientID);
    }

    private InetAddress getConnectAddress(InetAddress defaultAddress) throws InstantiationException {
        if (!JMSUtils.isNull(this.m_host)) {
            return JMSUtils.toAddress(this.m_host);
        }
        return defaultAddress;
    }

    private int getConnectPort(int defaultPort) throws InstantiationException {
        int port = this.getPort();
        return port > 0 ? port : defaultPort;
    }

    public String toString() {
        return (this.m_transactional ? "XA" : "") + (this instanceof ServerQueueConnectionFactory ? "Queue" : (this instanceof ServerTopicConnectionFactory ? "Topic" : "")) + "ServerConnectionFactory[" + this.m_location + "]";
    }

    public final synchronized void writeXML(PrintWriter out, String indent) throws IOException {
        out.println(indent + "<" + this.getName());
        JMSUtils.encode(out, indent, LOCATION, this.m_location);
        JMSUtils.encode(out, indent, HOST, this.m_host);
        JMSUtils.encode(out, indent, PORT, this.m_port);
        JMSUtils.encode(out, indent, TUNNEL, this.m_tunnel);
        JMSUtils.encode(out, indent, KEYSTORE, this.m_keystore);
        JMSUtils.encode(out, indent, KEYSTORE_PASSWORD, this.m_keystorePassword);
        JMSUtils.encode(out, indent, TRUSTSTORE, this.m_truststore);
        JMSUtils.encode(out, indent, TRUSTSTORE_PASSWORD, this.m_truststorePassword);
        JMSUtils.encode(out, indent, PROVIDER, this.m_provider);
        JMSUtils.encode(out, indent, USERNAME, this.m_user);
        JMSUtils.encode(out, indent, PASSWORD, this.m_pass);
        JMSUtils.encode(out, indent, CLIENTID, this.m_clientID);
        this.write(out, indent);
        out.println(indent + "/>");
    }

    public final synchronized String getLocation() {
        return this.m_location;
    }

    public final synchronized String getHost() {
        return this.m_host;
    }

    public final synchronized int getPort() throws InstantiationException {
        return JMSUtils.isNull(this.m_port) ? 0 : Integer.parseInt(this.m_port);
    }

    public final synchronized String getTunnel() {
        return this.m_tunnel;
    }

    public final synchronized String getKeystore() {
        return this.m_keystore;
    }

    public final synchronized String getKeystorePassword() {
        return this.m_keystorePassword;
    }

    public final synchronized String getObfuscatedKeystorePassword() {
        return SecuritySensitive.global().decode(this.m_keystorePassword, null);
    }

    public final synchronized String getTruststore() {
        return this.m_truststore;
    }

    public final synchronized String getTruststorePassword() {
        return this.m_truststorePassword;
    }

    public final synchronized String getProvider() {
        return this.m_provider;
    }

    public final synchronized String getObfuscatedTruststorePassword() {
        return SecuritySensitive.global().decode(this.m_truststorePassword, null);
    }

    public final synchronized String getUsername() {
        return this.m_user;
    }

    public final synchronized String getPassword() {
        return this.m_pass;
    }

    public final synchronized String getObfuscatedPassword() {
        return SecuritySensitive.global().decode(this.m_pass, null);
    }

    public final synchronized String getClientID() {
        return this.m_clientID;
    }

    public final synchronized boolean isTransactional() {
        return this.m_transactional;
    }

    public synchronized Map getAttributeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(LOCATION, this.m_location);
        map.put(DOMAIN, UNIFIED);
        if (this.m_host != null) {
            map.put(HOST, this.m_host);
        }
        if (this.m_port != null) {
            map.put(PORT, this.m_port);
        }
        if (this.m_user != null) {
            map.put(USERNAME, this.m_user);
        }
        if (this.m_pass != null) {
            map.put(PASSWORD, this.m_pass);
        }
        if (this.m_tunnel != null) {
            map.put(TUNNEL, this.m_tunnel);
        }
        if (this.m_keystore != null) {
            map.put(KEYSTORE, this.m_keystore);
        }
        if (this.m_keystorePassword != null) {
            map.put(KEYSTORE_PASSWORD, this.m_keystorePassword);
        }
        if (this.m_truststore != null) {
            map.put(TRUSTSTORE, this.m_truststore);
        }
        if (this.m_truststorePassword != null) {
            map.put(TRUSTSTORE_PASSWORD, this.m_truststorePassword);
        }
        if (this.m_provider != null) {
            map.put(PROVIDER, this.m_provider);
        }
        if (this.m_clientID != null) {
            map.put(CLIENTID, this.m_clientID);
        }
        if (this.m_transactional) {
            map.put(XA, XA);
        }
        return map;
    }

    protected void write(PrintWriter out, String indent) throws IOException {
    }

    static Map makeMap(Node parent, boolean transactional) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(LOCATION, JMSUtils.get(parent, LOCATION, null));
        map.put(HOST, JMSUtils.get(parent, HOST, null));
        map.put(PORT, JMSUtils.get(parent, PORT, null));
        map.put(TUNNEL, JMSUtils.get(parent, TUNNEL, null));
        map.put(KEYSTORE, JMSUtils.get(parent, KEYSTORE, null));
        map.put(KEYSTORE_PASSWORD, JMSUtils.get(parent, KEYSTORE_PASSWORD, null));
        map.put(TRUSTSTORE, JMSUtils.get(parent, TRUSTSTORE, null));
        map.put(TRUSTSTORE_PASSWORD, JMSUtils.get(parent, TRUSTSTORE_PASSWORD, null));
        map.put(PROVIDER, JMSUtils.get(parent, PROVIDER, null));
        map.put(USERNAME, JMSUtils.get(parent, USERNAME, null));
        map.put(PASSWORD, JMSUtils.get(parent, PASSWORD, null));
        map.put(CLIENTID, JMSUtils.get(parent, CLIENTID, null));
        if (transactional) {
            map.put(XA, XA);
        }
        return map;
    }

    private String prefix() {
        return this instanceof ServerQueueConnectionFactory ? "queue-" : (this instanceof ServerTopicConnectionFactory ? "topic-" : "");
    }

    private String getName() {
        return (this.m_transactional ? "xa-" : "") + this.prefix() + "connection-factory";
    }
}

