/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.DMSSupport;
import com.evermind.server.jms.DummyStats;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMXSupport;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;

public final class JMSStats
extends DummyStats {
    private DummyStats m_dms = null;
    private J2EEManagedObjectBase m_mbean = null;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(JMSStats.class);

    static JMSStats create(String parent, String self, String type) {
        return new JMSStats(parent, self, type);
    }

    private JMSStats(String parent, String self, String type) {
        super(parent, self);
        this.m_dms = DMSSupport.create(parent, self, type);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void setMBean(J2EEManagedObjectBase mbean) {
        try {
            if (this.m_mbean != null) {
                JMXSupport.remove(this.m_mbean.getObjectName());
            }
            JMXSupport.add(mbean);
            this.m_mbean = mbean;
        }
        catch (Throwable ex) {
            s_traceLogger.fine("setMBean({0})", new Object[]{mbean}, ex);
        }
    }

    public J2EEManagedObjectBase getMBean() {
        return this.m_mbean;
    }

    public String getName() {
        return this.m_dms.getName();
    }

    public void close() {
        if (this.m_dms != null) {
            this.m_dms.close();
            this.m_dms = null;
        }
        try {
            if (this.m_mbean != null) {
                JMXSupport.remove(this.m_mbean.getObjectName());
                this.m_mbean = null;
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("close({0})", new Object[]{this.m_mbean}, ex);
        }
    }

    public void state(String state, Object val) {
        this.m_dms.state(state, val);
    }

    public void state(String state, Object val, boolean ctor) {
        this.m_dms.state(state, val, ctor);
    }

    public Object getStateValue(String state) {
        return this.m_dms.getStateValue(state);
    }

    public void initEvent(String event) {
        this.m_dms.initEvent(event);
    }

    public void event(String event) {
        this.m_dms.event(event);
    }

    public int getEventCount(String event) {
        return this.m_dms.getEventCount(event);
    }

    public void addPhase(String phase, long millis) {
        this.m_dms.addPhase(phase, millis);
    }

    public void initPhase(String phase) {
        this.m_dms.initPhase(phase);
    }

    public long phase(String phase) {
        return this.m_dms.phase(phase);
    }

    public void phase(String phase, long tok) {
        this.m_dms.phase(phase, tok);
    }

    public static String pp() {
        return DMSSupport.pp();
    }

    public static void dump() {
        DMSSupport.dump();
    }

    public static String stats() {
        return DMSSupport.stats();
    }
}

