/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.net.SocketNetworkConnection;
import com.evermind.security.User;
import com.evermind.server.AdministrationPermission;
import com.evermind.server.ApplicationContext;
import com.evermind.server.ApplicationServer;
import com.evermind.server.Refreshable;
import com.evermind.server.Server;
import com.evermind.server.ServerConfigBase;
import com.evermind.server.ThreadState;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.ConnectInfo;
import com.evermind.server.jms.ConsumerInfo;
import com.evermind.server.jms.EvermindConnectionFactory;
import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.EvermindQueue;
import com.evermind.server.jms.EvermindQueueConnectionFactory;
import com.evermind.server.jms.EvermindTopic;
import com.evermind.server.jms.EvermindTopicConnectionFactory;
import com.evermind.server.jms.EvermindXAConnectionFactory;
import com.evermind.server.jms.EvermindXAQueueConnectionFactory;
import com.evermind.server.jms.EvermindXATopicConnectionFactory;
import com.evermind.server.jms.InContainerProxy;
import com.evermind.server.jms.JMSCommands;
import com.evermind.server.jms.JMSProvider;
import com.evermind.server.jms.JMSServerMessages;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSServerUtils;
import com.evermind.server.jms.JMSStats;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.JMXSupport;
import com.evermind.server.jms.Knobs;
import com.evermind.server.jms.KnobsController;
import com.evermind.server.jms.NList;
import com.evermind.server.jms.PersistentMap;
import com.evermind.server.jms.ServerConnectionFactory;
import com.evermind.server.jms.ServerDestination;
import com.evermind.server.jms.ServerFile;
import com.evermind.server.jms.ServerQueueConnectionFactory;
import com.evermind.server.jms.ServerTopicConnectionFactory;
import com.evermind.server.jms.SessionID;
import com.evermind.server.jms.TCPHandler;
import com.evermind.server.jms.Tset;
import com.evermind.server.jms.TxDestinations;
import com.evermind.server.jms.TxMap;
import com.evermind.server.jms.XMLConfigBroadcaster;
import com.evermind.server.jms.config.XMLConfigElement;
import com.evermind.server.jms.config.XMLConfigElementFactory;
import com.evermind.server.jms.config.XMLConfigException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.JMSConnectionStats;
import javax.management.j2ee.statistics.Stats;
import javax.naming.NamingException;
import oracle.j2ee.jms.oc4j.v1.JMSServerConfig;
import oracle.oc4j.admin.management.callbackinterfaces.JMSAdministratorCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JMSCallBackIf;
import oracle.oc4j.admin.management.mbeans.JMS;
import oracle.oc4j.admin.management.mbeans.JMSAdministrator;
import oracle.oc4j.admin.management.shared.statistic.JMSStatsImpl;
import oracle.oc4j.security.OC4JSecurity;

public final class JMSServer
extends Server
implements Runnable,
Refreshable,
TxMap,
JMSAdministratorCallBackIf,
JMSCallBackIf {
    private ApplicationContext m_serverContext = null;
    private String m_name = "";
    private JMSStats m_jstats = null;
    private JMSStatsImpl m_stats = null;
    private final JMSProvider m_provider = new JMSProvider(this);
    private final ApplicationServer m_appServer;
    private ServerSocket m_serverSock = null;
    private JMSServerConfig m_config = null;
    private String m_pDir = "../persistence";
    private URL m_pURL = null;
    private long m_start = -1L;
    private User m_admin = null;
    private final Tset m_enabled = new Tset(true);
    private Runnable m_task = null;
    private int m_id = 0;
    private final Object threadControlLock = new Object();
    private boolean isAlive;
    private final NList tcpHandlers = new NList();
    final Map m_handlers = new HashMap();
    private final Map m_ctx = new HashMap();
    private String m_stateF = null;
    private Map m_stateM = null;
    private final Map m_tx = new HashMap();
    private final Map m_xt = new HashMap();
    private int m_txid = 1;
    private EvermindQueue m_eQueue = null;
    private ServerDestination m_eDest = null;
    private final List m_pDestList = new ArrayList();
    private final Map m_pFileMap = new HashMap();
    private final XMLConfigBroadcaster m_broadcaster = XMLConfigBroadcaster.getBroadcaster();
    final Map httpHandlers = new HashMap();
    static String s_instanceId;
    private static final JMSTraceLogger s_traceLogger;
    private static JMSServer s_jmsServer;
    private static final String CONFIGURATION = "OC4J JMS Destinations";
    private static final boolean BASIC_PERSISTENCE;
    private static final boolean FORCE_PERSISTENCE;
    public static final int DEFAULT_BACKLOG = 256;
    public static final int PORT_DONTLISTEN = -1;
    public static final String OPMN_JMS_PORT = "port.jms";
    public static final boolean INTRA_SESSION;
    private static boolean s_printStackTrace;
    private static boolean s_debug;
    private static boolean s_rememberAllXids;
    private static boolean s_checkPermissions;
    public static final boolean IN_OPMN;
    public static boolean USE_PERSISTENCE;
    public static final long EXPIRATION_INTERVAL;
    private static final String STATE_FILE = "jms.state";
    public static final String OBJECTNAME = "ObjectName";
    public static final String PERSISTENCE_OBJECTNAME = "PersistenceObjectName";

    public JMSServer(ApplicationServer appServer) throws InstantiationException {
        JMSServerProxy.setServer(new InContainerProxy(this));
        s_jmsServer = this;
        this.m_appServer = appServer;
        try {
            EnterpriseArchive ear = (EnterpriseArchive)this.m_appServer.getConfig().getDefaultApplicationConfig();
            this.m_pURL = ear.getPersistenceURL();
            this.m_pDir = this.m_pURL.getFile();
            s_instanceId = InetAddress.getLocalHost().getHostAddress() + ":" + this.m_pDir;
        }
        catch (Throwable ex) {
            JMSServerMessages.severeServerInstantiation(appServer, ex);
        }
    }

    public String toString() {
        return "JMSServer[" + this.m_name + "]";
    }

    public synchronized void setConfig(JMSServerConfig config) throws InstantiationException {
        try {
            this.internalSetConfig(config);
        }
        catch (InstantiationException ex) {
            JMSServerMessages.severeSetConfig(config, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSetConfig(JMSServerConfig config) throws InstantiationException {
        s_traceLogger.entering("internalSetConfig", new Object[]{config});
        super.setConfig((ServerConfigBase)config);
        this.m_config = config;
        this.m_enabled.set(this.m_config.getEnabled());
        this.m_config.validate();
        if (this.getEnabled()) {
            this.initStats();
            HashSet xaDest = new HashSet();
            HashMap xaState = new HashMap();
            boolean hasXA = this.recoverState(xaDest, xaState);
            this.initializeSocket();
            try {
                this.loadConnectionFactories();
            }
            catch (UnknownHostException ex) {
                JMSUtils.toInstantiationException("loadConnectionFactories", ex);
            }
            this.loadDestinations(hasXA, xaDest, xaState);
            Object object = this.threadControlLock;
            synchronized (object) {
                this.isAlive = true;
            }
            this.m_appServer.getConnectionThreadPool().launch(this);
            this.startExpirator();
        } else {
            JMSServerMessages.infoServerNotListening(this);
            try {
                this.bindConnectionFactories();
            }
            catch (UnknownHostException ex) {
                JMSUtils.toInstantiationException("bindConnectionFactories", ex);
            }
            this.bindDestinations();
        }
        JMSUtils.gc(true);
        this.dumpConfiguration();
        s_traceLogger.exiting("internalSetConfig");
    }

    public synchronized void bind(ApplicationContext context) throws InstantiationException {
        try {
            Iterator iterator = this.m_ctx.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                context.rebind((String)entry.getKey(), entry.getValue(), 0);
            }
            this.m_serverContext = context;
        }
        catch (NamingException ex) {
            JMSServerMessages.severeUnableToBind(context, this.m_ctx, ex);
        }
    }

    public void destroy(String reason) {
        s_traceLogger.entering("destroy", new Object[]{reason});
        this.stop(null);
        s_jmsServer = null;
        super.destroy(reason);
        s_traceLogger.exiting("destroy");
    }

    public ApplicationServer getApplicationServer() {
        return this.m_appServer;
    }

    public synchronized int getNextID() {
        return ++this.m_id;
    }

    protected String getVersion() {
        return ApplicationServer.VERSION;
    }

    public ServerSocket getSocket() {
        return this.m_serverSock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getClients() {
        Map map = this.m_handlers;
        synchronized (map) {
            return new ArrayList(this.m_handlers.keySet());
        }
    }

    public JMSStats getJMSStats() {
        return this.m_jstats;
    }

    public synchronized String getDefaultConnectionFactoryLocation(boolean trans) {
        return trans ? "jms/XAConnectionFactory" : "jms/ConnectionFactory";
    }

    public synchronized String getDefaultQueueConnectionFactoryLocation(boolean trans) {
        return trans ? "jms/XAQueueConnectionFactory" : "jms/QueueConnectionFactory";
    }

    public synchronized String getDefaultTopicConnectionFactoryLocation(boolean trans) {
        return trans ? "jms/XATopicConnectionFactory" : "jms/TopicConnectionFactory";
    }

    public synchronized String getDefaultQueueLocation() {
        return null;
    }

    public synchronized String getDefaultTopicLocation() {
        return null;
    }

    public synchronized Set getImplementations(Class type) {
        HashSet ret = new HashSet();
        Iterator iter = this.m_ctx.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!type.isAssignableFrom(entry.getValue().getClass())) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    public synchronized String list() throws Exception {
        return this.m_config.list();
    }

    public synchronized void sync() throws Exception {
        this.m_config.sync();
    }

    public synchronized String validateSelector(String selector) throws JMSException {
        return JMSServerUtils.check(selector);
    }

    public synchronized boolean areSelectorsEqual(String sel1, String sel2) throws JMSException {
        return JMSServerUtils.compare(sel1, sel2);
    }

    public synchronized boolean setEnabled(Boolean enable) throws Exception {
        boolean toenable;
        boolean bl = toenable = enable == null ? true : enable;
        if (this.getEnabled() != toenable) {
            this.m_config.setEnabled(enable);
            this.m_config.sync();
            if (this.m_enabled.testAndSet(toenable)) {
                this.stop("Administrator requested disable");
            } else {
                this.setConfig(this.m_config);
                this.rebind();
            }
        }
        return this.getEnabled();
    }

    public synchronized boolean getEnabled() {
        return this.m_enabled.test();
    }

    public synchronized void server(String host, String port) throws Exception {
        this.m_config.server(JMSUtils.unfold(host), JMSUtils.fold(port).trim());
    }

    public synchronized void addFactory(int domain, Map info) throws Exception {
        ServerConnectionFactory cfg = null;
        try {
            cfg = this.m_config.addFactory(domain, info);
            this.m_config.sync();
            if (this.isBindable(cfg)) {
                this.bindThrough(cfg.getLocation(), this.makeFactory(cfg));
            }
        }
        catch (Exception ex) {
            try {
                if (cfg != null) {
                    this.removeFactory(JMSUtils.unfold(cfg.getLocation()));
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw ex;
        }
    }

    public synchronized void removeFactory(String location) throws Exception {
        try {
            this.unbind(location);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_config.removeFactory(JMSUtils.unfold(location));
        this.m_config.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addDestination(boolean isQ, Map info) throws Exception {
        String name2;
        if (!(JMSUtils.isNull((String)info.get("persistence-file")) || USE_PERSISTENCE || IN_OPMN)) {
            JMSServerMessages.warningPersistenceDisabled(this, 1);
        }
        boolean need_undo = false;
        try {
            this.m_config.addDestination(isQ, info);
            need_undo = true;
            this.m_config.sync();
            EvermindDestination dest = isQ ? new EvermindQueue(info, null) : new EvermindTopic(info, null);
            this.loadDestination(dest);
            this.m_stateM.put(CONFIGURATION, this.m_pDestList);
            need_undo = false;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            String name2;
            Object var6_6 = null;
            if (need_undo && !JMSUtils.isNull(name2 = (String)info.get("name"))) {
                try {
                    this.removeDestination(name2);
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                try {
                    this.m_config.removeDestination(name2);
                    this.m_config.sync();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        if (need_undo && !JMSUtils.isNull(name2 = (String)info.get("name"))) {
            try {
                this.removeDestination(name2);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            try {
                this.m_config.removeDestination(name2);
                this.m_config.sync();
            }
            catch (Throwable ignored) {}
        }
    }

    public synchronized void removeDestination(String name) throws Exception {
        this.removeDestination(name, Boolean.TRUE, Boolean.TRUE);
    }

    public synchronized void removeDestination(String name, Boolean force, Boolean removePFile) throws Exception {
        name = JMSUtils.unfold(name);
        boolean boolForce = force == null ? false : force;
        boolean boolRemove = removePFile == null ? false : removePFile;
        Map destMap = this.m_provider.getDestinationMap();
        if (!destMap.containsKey(name)) {
            JMSUtils.toInstantiationException(JMSServerMessages.getMessage("J2EE JMS-03204", this, name));
        }
        EvermindDestination dest = (EvermindDestination)((ServerDestination)destMap.get(name)).getDestination();
        try {
            this.unloadDestination(dest, boolForce, boolRemove);
        }
        catch (Throwable tr) {
            // empty catch block
        }
        this.m_config.removeDestination(name);
        this.m_config.sync();
    }

    public synchronized List getDestinations() throws Exception {
        ArrayList<Map> destList = new ArrayList<Map>();
        Iterator iter = this.m_provider.getDestinationMap().entrySet().iterator();
        while (iter.hasNext()) {
            ServerDestination sdest = (ServerDestination)iter.next().getValue();
            EvermindDestination dest = (EvermindDestination)sdest.getDestination();
            Map destMap = dest.getAttributeMap();
            destMap.put(OBJECTNAME, sdest.getCanonicalName());
            if (!JMSUtils.isNull(dest.getPersistenceFile())) {
                destMap.put(PERSISTENCE_OBJECTNAME, sdest.getPersistenceCanonicalName());
            }
            destList.add(destMap);
        }
        return destList;
    }

    public synchronized List getConnectionFactories() throws Exception {
        ArrayList<Map> factList = new ArrayList<Map>();
        ArrayList facts = new ArrayList(this.m_config.getConnectionFactories());
        facts.addAll(this.m_config.getQueueConnectionFactories());
        facts.addAll(this.m_config.getTopicConnectionFactories());
        Iterator iter = facts.iterator();
        while (iter.hasNext()) {
            ServerConnectionFactory config = (ServerConnectionFactory)iter.next();
            factList.add(config.getAttributeMap());
        }
        return factList;
    }

    public synchronized Map getConfigProperties() throws Exception {
        return KnobsController.getKnobsController().getConfigProperties();
    }

    public synchronized void setConfigProperty(String property, String value) throws Exception {
        KnobsController.getKnobsController().setConfigProperty(property, value);
        this.m_config.sync();
    }

    public void addFactory(String domain, String location, String host, String port, String username, String password, String clientID, Boolean isXA) throws Exception {
        this.addFactory(domain, location, host, port, null, null, null, null, null, null, username, password, clientID, isXA);
    }

    public void addFactory(String domain, String location, String host, String port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String username, String password, String clientID, Boolean isXA) throws Exception {
        boolean boolXA = isXA == null ? false : isXA;
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("location", JMSUtils.unfold(location));
        if (JMSUtils.unfold(host) != null) {
            info.put("host", JMSUtils.unfold(host));
        }
        if (JMSUtils.unfold(port) != null) {
            info.put("port", JMSUtils.unfold(port));
        }
        if (JMSUtils.unfold(tunnel) != null) {
            info.put("tunnel", JMSUtils.unfold(tunnel));
        }
        if (JMSUtils.unfold(keystore) != null) {
            info.put("keystore", JMSUtils.unfold(keystore));
        }
        if (JMSUtils.unfold(keystorePassword) != null) {
            info.put("keystore-password", JMSUtils.unfold(keystorePassword));
        }
        if (JMSUtils.unfold(truststore) != null) {
            info.put("truststore", JMSUtils.unfold(truststore));
        }
        if (JMSUtils.unfold(truststorePassword) != null) {
            info.put("truststore-password", JMSUtils.unfold(truststorePassword));
        }
        if (JMSUtils.unfold(provider) != null) {
            info.put("provider", JMSUtils.unfold(provider));
        }
        if (JMSUtils.unfold(username) != null) {
            info.put("username", JMSUtils.unfold(username));
        }
        if (JMSUtils.unfold(password) != null) {
            info.put("password", JMSUtils.unfold(password));
        }
        if (JMSUtils.unfold(clientID) != null) {
            info.put("clientID", JMSUtils.unfold(clientID));
        }
        if (boolXA) {
            info.put("xa", "xa");
        }
        this.addFactory(JMSUtils.toDomain(domain), info);
    }

    public void addDestination(String domain, String name, String location, String pfile, String desc) throws Exception {
        if (!domain.equalsIgnoreCase("queue") && !domain.equalsIgnoreCase("topic")) {
            throw new JMSException(JMSServerMessages.getMessage("J2EE JMS-03202", this, domain));
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", JMSUtils.unfold(name));
        info.put("location", JMSUtils.unfold(location));
        info.put("persistence-file", JMSUtils.unfold(pfile));
        info.put("description", JMSUtils.unfold(desc));
        this.addDestination("queue".equalsIgnoreCase(domain), info);
    }

    static JMSServer getServer() {
        OC4JSecurity.assertIsSafe();
        return s_jmsServer;
    }

    public String getMetricPath() {
        return "/JMS";
    }

    public Stats getJSR77Stats() {
        return this.m_stats;
    }

    public int getNumConnections() {
        return this.m_jstats.getEventCount("connections");
    }

    public void addXMLConfigListener(ObjectName cbObjectName, XMLConfigElementFactory xceFact) throws XMLConfigException {
        this.m_broadcaster.addXMLConfigListener(cbObjectName, xceFact);
    }

    public void removeXMLConfigListener(ObjectName cbObjectName, XMLConfigElementFactory xceFact) throws XMLConfigException {
        this.m_broadcaster.removeXMLConfigListener(cbObjectName, xceFact);
    }

    public void setXMLConfigElement(XMLConfigElement config) throws XMLConfigException {
        this.m_broadcaster.setXMLConfigElement(config);
        try {
            this.m_config.sync();
        }
        catch (Throwable ex) {
            throw new XMLConfigException(ex);
        }
    }

    public void hasChanged(List componentsToRefresh) {
        if (this.m_config.isUpdated()) {
            s_traceLogger.fine("jms.xml has been modified on disk");
            componentsToRefresh.add(this);
        }
    }

    public void refresh() {
        try {
            this.m_config.refresh();
            s_traceLogger.fine("Merged internal config with manual changes to jms.xml");
            this.m_config.sync();
        }
        catch (Throwable ex) {
            JMSServerMessages.severeConfigUpdate(this.m_config, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        s_traceLogger.entering("run");
        Thread.currentThread().setName(this.toString());
        long startTime = System.currentTimeMillis();
        this.m_jstats.state("startTime", new Long(startTime), true);
        this.m_jstats.state("taskManagerInterval", new Long(this.m_config.getTaskManagerInterval()), true);
        JMS mbean = (JMS)this.m_jstats.getMBean();
        if (mbean != null) {
            mbean.setstartTime(startTime);
            mbean.settaskManagerInterval(this.m_config.getTaskManagerInterval());
        }
        if (this.m_serverSock != null) {
            while (true) {
                ServerSocket server_socket;
                Object object = this.threadControlLock;
                synchronized (object) {
                    if (!this.isAlive) {
                        break;
                    }
                    server_socket = this.m_serverSock;
                }
                try {
                    Socket socket = server_socket.accept();
                    socket.setTcpNoDelay(true);
                    SocketNetworkConnection connection = new SocketNetworkConnection(socket);
                    TCPHandler handler = new TCPHandler(this, connection);
                    this.launchTCPHandler(handler);
                }
                catch (IOException ex) {
                    Object object2 = this.threadControlLock;
                    synchronized (object2) {
                        if (!this.isAlive) {
                            break;
                        }
                    }
                    Thread.yield();
                }
            }
        }
        s_traceLogger.exiting("run");
    }

    public synchronized int getTx(Object sessionID) {
        if (JMSUtils.isNull(sessionID) || !this.m_tx.containsKey(sessionID)) {
            return 0;
        }
        return (Integer)this.m_tx.get(sessionID);
    }

    public synchronized Object getTxid(int tx) {
        Integer id = new Integer(tx);
        return tx == 0 ? null : this.m_xt.get(id);
    }

    public synchronized boolean isCommitted(int tx) {
        MyTrans t = (MyTrans)this.m_stateM.get(this.m_xt.get(new Integer(tx)));
        return t != null && t.isCommitted();
    }

    public synchronized boolean isRolledback(int tx) {
        MyTrans t = (MyTrans)this.m_stateM.get(this.m_xt.get(new Integer(tx)));
        return t != null && t.isRolledback();
    }

    public synchronized boolean isOpen(int tx) {
        MyTrans t = (MyTrans)this.m_stateM.get(this.m_xt.get(new Integer(tx)));
        return t != null && t.isOpen();
    }

    public void requestFromHTTPTunnel(DataInputStream dinp, DataOutputStream dout, String hostName, int port) {
        TCPHandler handler = new TCPHandler(this, hostName, port, dinp, dout);
        this.launchTCPHandler(handler);
    }

    public synchronized String getHttpTunnelAuthentication() {
        return this.m_config.getHttpTunnelAuthentication();
    }

    public synchronized String getHttpTunnelAuthorization() {
        return this.m_config.getHttpTunnelAuthorization();
    }

    public synchronized boolean getHttpTunnelEnabled() {
        return this.m_config.getHttpTunnelEnabled();
    }

    public synchronized boolean getTcpRelayEnabled() {
        return this.m_config.getTcpRelayEnabled();
    }

    public synchronized String getTcpRelayFilter() {
        return this.m_config.getTcpRelayFilter();
    }

    public synchronized int getTcpRelayTimeout() {
        return this.m_config.getTcpRelayTimeout();
    }

    public synchronized List getTcpRelayList() {
        return this.m_config.getTcpRelayList();
    }

    void prepare(SessionID xid, boolean isPersist) {
        if (!isPersist) {
            return;
        }
        if (this.m_stateM.containsKey(xid)) {
            return;
        }
        this.m_stateM.put(xid, new MyTrans(this.getTx(xid), 11));
    }

    SessionID[] recover() {
        HashSet xids = new HashSet();
        Iterator iter = this.m_stateM.entrySet().iterator();
        while (iter.hasNext()) {
            MyTrans t;
            Map.Entry entry = iter.next();
            Object xid = entry.getKey();
            if (!(xid instanceof SessionID) || !(t = (MyTrans)entry.getValue()).isXA() || !t.isOpen()) continue;
            xids.add(xid);
        }
        return xids.toArray(new SessionID[0]);
    }

    void preTx(Object sessionID, boolean isCommit, boolean isPersist) throws JMSException {
        if (!isPersist) {
            return;
        }
        try {
            int tx = this.getTx(sessionID);
            if (tx != 0) {
                this.m_stateM.put(sessionID, new MyTrans(tx, isCommit ? (byte)13 : 7));
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("preTx(" + sessionID + "," + isCommit + ")", ex);
        }
    }

    void postTx(Object sessionID, boolean isPersist) {
        try {
            this.m_xt.remove(this.m_tx.remove(sessionID));
            if (isPersist) {
                this.m_stateM.remove(sessionID);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("postTx({0})", new Object[]{sessionID}, ex);
        }
    }

    void addTx(SessionID sessionID, boolean isXA) {
        if (this.m_tx.containsKey(sessionID)) {
            return;
        }
        int start = this.m_txid;
        do {
            Integer i;
            if (!this.m_xt.containsKey(i = new Integer(isXA ? -this.m_txid : this.m_txid))) {
                this.m_tx.put(sessionID, i);
                this.m_xt.put(i, sessionID);
                return;
            }
            ++this.m_txid;
            if (this.m_txid > 0) continue;
            this.m_txid = 1;
        } while (start != this.m_txid);
        JMSUtils.toRuntimeException(JMSServerMessages.getMessage("J2EE JMS-02510", this, sessionID));
    }

    private void dumpConfiguration() {
        if (!JMSServer.getDebug()) {
            return;
        }
        try {
            String knobsMsg = "Control Knobs:\n";
            Object[] knobs = Knobs.getKnobs();
            Arrays.sort(knobs);
            for (int i = 0; i < knobs.length; ++i) {
                String k = ((Knobs)knobs[i]).getProperty();
                Object v = ((Knobs)knobs[i]).getValue();
                knobsMsg = knobsMsg + "    " + k + "=" + v + "\n";
            }
            s_traceLogger.fine(knobsMsg);
            Object[] keys = this.m_ctx.keySet().toArray();
            Arrays.sort(keys);
            String cfMsg = "Connection Factories:\n";
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                Object val = this.m_ctx.get(key);
                if (val instanceof Destination) continue;
                cfMsg = cfMsg + "    " + key + "=" + val + "\n";
            }
            s_traceLogger.fine(cfMsg);
            String dMsg = "Destinations:\n";
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                Object val = this.m_ctx.get(key);
                if (!(val instanceof Destination)) continue;
                dMsg = dMsg + "    " + key + "=" + val + "\n";
            }
            s_traceLogger.fine(dMsg);
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("dumpConfiguration", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTCPHandler(TCPHandler handler) {
        Object object = this.threadControlLock;
        synchronized (object) {
            if (this.isAlive) {
                this.tcpHandlers.add(handler.serverLink);
            } else {
                handler.close();
                handler = null;
            }
        }
        if (handler != null) {
            this.m_appServer.getRequestThreadPool().launch(handler);
        }
    }

    public static boolean getPrintStackTrace() {
        return s_printStackTrace;
    }

    private static void setPrintStackTrace(boolean printStackTrace) {
        s_printStackTrace = printStackTrace;
    }

    public static boolean getDebug() {
        return s_debug;
    }

    private static void setDebug(boolean debug) {
        s_debug = debug;
    }

    public static boolean getCheckPermissions() {
        return s_checkPermissions;
    }

    private static void setCheckPermissions(boolean checkPermissions) {
        s_checkPermissions = checkPermissions;
    }

    public static boolean getRememberAllXids() {
        return s_rememberAllXids;
    }

    private static void setRememberAllXids(boolean rememberAllXids) {
        s_rememberAllXids = rememberAllXids;
    }

    public synchronized void unbindall() {
        Iterator iterator = this.m_ctx.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                this.m_serverContext.destroy((String)entry.getKey());
            }
            catch (NamingException nex) {
                s_traceLogger.fine("unbindall", nex);
            }
        }
        this.m_ctx.clear();
    }

    public synchronized void unbind(String location) throws NamingException {
        if (this.m_serverContext != null) {
            this.m_serverContext.destroy(location);
        }
        this.m_ctx.remove(location);
    }

    public synchronized void rebind() throws InstantiationException {
        try {
            if (this.m_serverContext != null) {
                Iterator iterator = this.m_ctx.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    this.m_serverContext.rebind((String)entry.getKey(), entry.getValue(), 0);
                }
            }
        }
        catch (NamingException ex) {
            JMSServerMessages.severeUnableToBind(this.m_serverContext, this.m_ctx, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stop(String reason) {
        s_traceLogger.entering("stop(", new Object[]{JMSUtils.fold(reason)});
        try {
            Object object = this.threadControlLock;
            synchronized (object) {
                block15: {
                    if (this.isAlive) break block15;
                    return;
                }
                this.isAlive = false;
            }
            this.stopExpirator();
            try {
                if (this.m_serverSock != null) {
                    this.m_serverSock.close();
                    this.m_serverSock = null;
                }
            }
            catch (Throwable ex) {
                s_traceLogger.throwing("stop", ex);
            }
            this.shutHandlers();
            this.saveState();
            this.clearState();
            this.m_jstats.close();
            this.m_jstats = null;
            try {
                if (this.m_config.isDirty()) {
                    s_traceLogger.fine("JMSServer: saving new configuration({0})", new Object[]{this.m_config});
                    this.m_config.sync();
                }
            }
            catch (Throwable ex) {
                JMSServerMessages.severeStoreConfig(this.m_config, ex);
            }
            if (!JMSUtils.isNull(reason)) {
                super.destroy(reason);
            }
        }
        finally {
            s_traceLogger.exiting("stop");
        }
    }

    JMSStats getStats() {
        return this.m_jstats;
    }

    synchronized InetAddress getAddress() throws InstantiationException {
        InetAddress addr;
        if (this.m_serverSock == null) {
            JMSUtils.toInstantiationException(JMSServerMessages.getMessage("J2EE JMS-02500", this));
        }
        if (!(addr = this.m_serverSock.getInetAddress()).getHostAddress().equals("127.0.0.1")) {
            addr = JMSUtils.normalize(addr);
        }
        return addr;
    }

    synchronized boolean isBindable(ServerConnectionFactory config) {
        return !JMSUtils.isNull(config.getLocation());
    }

    synchronized int getPort() throws InstantiationException {
        return JMSServerUtils.getPort(this.m_config == null ? 9127 : this.m_config.getPort());
    }

    static synchronized void saveExpired(EvermindMessage msg, ConsumerInfo cons) {
        if (s_jmsServer == null || JMSServer.s_jmsServer.m_eDest == null) {
            return;
        }
        try {
            JMSServer.s_jmsServer.m_eDest.enq(null, null, false, JMSServerUtils.wrapExpired(msg, cons));
        }
        catch (Throwable ex) {
            s_traceLogger.fine("saveExpired", ex);
        }
    }

    static synchronized Object lookup(String name) {
        return s_jmsServer == null ? null : JMSServer.s_jmsServer.m_ctx.get(name);
    }

    JMSProvider getProvider() {
        return this.m_provider;
    }

    static synchronized JMSCommands getJMSServer(InetAddress addr, int port, String user, String pass) throws JMSException {
        if (s_jmsServer == null) {
            return null;
        }
        try {
            ServerSocket soc = JMSServer.s_jmsServer.m_serverSock;
            if (soc == null) {
                return null;
            }
            addr = JMSUtils.normalize(addr);
            if (!JMSUtils.normalize(soc.getInetAddress()).equals(addr) || soc.getLocalPort() != port) {
                return null;
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("getJMSServer", ex);
        }
        return JMSServer.getJMSServer(user, pass);
    }

    static synchronized JMSCommands getJMSServer(String user, String pass) throws JMSException {
        JMSProvider ret = null;
        try {
            User u = s_jmsServer.getUser(user);
            if (JMSUtils.isNull(user)) {
                if (u == null) {
                    u = JMSServer.getDefaultJMSUser();
                }
                if (u == null) {
                    JMSUtils.toJMSSecurityException(JMSServerMessages.getMessage("J2EE JMS-02501", s_jmsServer, user, pass));
                }
            } else {
                if (u == null) {
                    JMSUtils.toJMSSecurityException(JMSServerMessages.getMessage("J2EE JMS-02502", s_jmsServer, user, pass));
                }
                if (!u.authenticate(JMSUtils.fold(pass))) {
                    JMSUtils.toJMSSecurityException(JMSServerMessages.getMessage("J2EE JMS-02503", s_jmsServer, user, pass, u));
                }
            }
            ret = JMSServer.s_jmsServer.m_provider;
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("getJMSServer", ex);
        }
        return ret;
    }

    synchronized User getUser(String user) {
        User tUser = ThreadState.getUser(null);
        return JMSUtils.isNull(user) ? (tUser == null ? JMSServer.getDefaultJMSUser() : tUser) : this.m_appServer.getUser(user);
    }

    private static User getDefaultJMSUser() {
        return s_jmsServer.getApplicationServer().getAnonymousUser();
    }

    private User getAdmin() {
        if (this.m_admin == null) {
            this.m_admin = this.m_appServer.getAdminUser();
        }
        return this.m_admin;
    }

    synchronized void checkAdmin(String op, User user) throws JMSException {
        if (user != null && user.hasPermission(AdministrationPermission.INSTANCE)) {
            return;
        }
        if (this.getAdmin() == null || user == null || this.getAdmin() != user && !this.getAdmin().getName().equals(user.getName())) {
            JMSUtils.toJMSException(JMSServerMessages.getMessage("J2EE JMS-02504", this, user, op));
        }
    }

    static synchronized void verifyServer(JMSCommands svr) throws JMSException {
        if (s_jmsServer != null && JMSServer.s_jmsServer.m_provider != svr) {
            JMSUtils.toJMSException(JMSServerMessages.getMessage("J2EE JMS-02505", svr, JMSServer.s_jmsServer.m_provider));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTCPHandler(TCPHandler handler) {
        Object object = this.threadControlLock;
        synchronized (object) {
            handler.serverLink.remove();
        }
    }

    void expireMessages() {
        JMSUtils.gc(true);
        this.m_provider.expireMessages();
    }

    static synchronized void add(JMSConnectionStats s) {
        try {
            if (s_jmsServer != null && JMSServer.s_jmsServer.m_stats != null) {
                JMSServer.s_jmsServer.m_stats.add(s);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("add({0})", new Object[]{s}, ex);
        }
    }

    static synchronized void remove(JMSConnectionStats s) {
        try {
            if (s_jmsServer != null && JMSServer.s_jmsServer.m_stats != null) {
                JMSServer.s_jmsServer.m_stats.remove(s);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("remove({0})", new Object[]{s}, ex);
        }
    }

    private ConnectInfo makeFactory(ServerConnectionFactory config) throws InstantiationException, UnknownHostException {
        ConnectInfo ret = null;
        ret = config instanceof ServerQueueConnectionFactory ? ((ServerQueueConnectionFactory)config).getConnectionFactory(this.getAddress(), this.getPort()) : (config instanceof ServerTopicConnectionFactory ? ((ServerTopicConnectionFactory)config).getConnectionFactory(this.getAddress(), this.getPort()) : config.getConnectionFactory(this.getAddress(), this.getPort()));
        return ret;
    }

    private void startExpirator() {
        if (this.m_task == null) {
            final JMSServer me = this;
            this.m_task = new Runnable(){
                private long m_last = System.currentTimeMillis();

                public void run() {
                    if (System.currentTimeMillis() - this.m_last <= EXPIRATION_INTERVAL) {
                        return;
                    }
                    me.expireMessages();
                    this.m_last = System.currentTimeMillis();
                }
            };
            this.m_appServer.getTaskManager().addTask(this.m_task, this.m_config.getTaskManagerInterval());
        }
    }

    private void stopExpirator() {
        try {
            if (this.m_task != null) {
                this.m_appServer.getTaskManager().removeTask(this.m_task);
            }
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("stopExpirator", ex);
        }
    }

    private void initializeSocket() throws InstantiationException {
        int port = this.getPort();
        InetAddress addr = this.m_config.getAddress();
        if (this.m_serverSock != null) {
            int lport = this.m_serverSock.getLocalPort();
            InetAddress laddr = this.m_serverSock.getInetAddress();
            if (port == lport && addr.equals(laddr)) {
                return;
            }
            try {
                this.m_serverSock.close();
            }
            catch (Throwable ex) {
                s_traceLogger.fine("initializeSocket", ex);
            }
        }
        try {
            this.m_serverSock = new ServerSocket(port, 256, addr);
        }
        catch (BindException bex) {
            JMSServerMessages.severePortInUse(port);
        }
        catch (Throwable ex) {
            JMSUtils.toInstantiationException("initializeSocket", ex);
        }
        s_traceLogger.fine("JMSServer listening on port: {0}", new Object[]{new Integer(port)});
        InetAddress naddr = JMSUtils.normalize(addr);
        this.m_jstats.state("address", addr, true);
        this.m_jstats.state("host", naddr, true);
        this.m_jstats.state("port", new Integer(port), true);
        JMS mbean = (JMS)this.m_jstats.getMBean();
        if (mbean != null) {
            mbean.setaddress(addr);
            mbean.setport(port);
        }
        this.m_name = naddr.getHostName() + ":" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutHandlers() {
        Object object = this.threadControlLock;
        synchronized (object) {
            Iterator i = this.tcpHandlers.iterator();
            while (i.hasNext()) {
                ((TCPHandler)i.next()).close();
            }
        }
    }

    private void saveState() {
        JMSUtils.gc(true);
        try {
            this.m_provider.closeAllConnections();
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("saveState", ex);
        }
        try {
            this.saveDestinations();
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("saveState", ex);
        }
        try {
            if (this.m_stateM instanceof PersistentMap) {
                ((PersistentMap)this.m_stateM).close();
                if (this.m_tx.size() == 0) {
                    new File(this.m_stateF).delete();
                }
            }
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("saveState", ex);
        }
    }

    private void saveDestinations() throws Throwable {
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        Map dest = this.m_provider.getDestinationMap();
        Iterator iter = dest.entrySet().iterator();
        while (iter.hasNext()) {
            ServerDestination sdest = (ServerDestination)iter.next().getValue();
            try {
                sdest.close();
            }
            catch (Throwable ex) {
                exList.add(ex);
            }
        }
        if (exList.size() > 0) {
            JMSUtils.toJMSException("saveDestinations", exList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearState() {
        try {
            Object object = this.threadControlLock;
            synchronized (object) {
                this.tcpHandlers.clear();
            }
            this.m_handlers.clear();
            this.unbindall();
            this.m_provider.clearState();
            this.m_tx.clear();
            this.m_xt.clear();
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("clearState", ex);
        }
    }

    private void bindConnectionFactories() throws InstantiationException, UnknownHostException {
        ServerConnectionFactory config;
        Iterator iter = null;
        iter = this.m_config.getConnectionFactories().iterator();
        while (iter.hasNext()) {
            config = (ServerConnectionFactory)iter.next();
            if (!this.isBindable(config)) continue;
            this.bind(config.getLocation(), config.getConnectionFactory(this.getAddress(), this.getPort()));
        }
        iter = this.m_config.getQueueConnectionFactories().iterator();
        while (iter.hasNext()) {
            config = (ServerQueueConnectionFactory)iter.next();
            if (!this.isBindable(config)) continue;
            this.bind(config.getLocation(), ((ServerQueueConnectionFactory)config).getConnectionFactory(this.getAddress(), this.getPort()));
        }
        iter = this.m_config.getTopicConnectionFactories().iterator();
        while (iter.hasNext()) {
            config = (ServerTopicConnectionFactory)iter.next();
            if (!this.isBindable(config)) continue;
            this.bind(config.getLocation(), ((ServerTopicConnectionFactory)config).getConnectionFactory(this.getAddress(), this.getPort()));
        }
    }

    private void loadConnectionFactories() throws InstantiationException, UnknownHostException {
        this.bindConnectionFactories();
        this.createDefaultCF();
    }

    private void createDefaultCF() throws InstantiationException {
        if (!this.getEnabled()) {
            return;
        }
        int port = this.getPort();
        InetAddress addr = this.getAddress();
        this.weakBind("jms/ConnectionFactory", new EvermindConnectionFactory(addr, port, null, null, null, null, null, null, null, null, null, false, 2));
        this.weakBind("jms/XAConnectionFactory", new EvermindXAConnectionFactory(addr, port, null, null, null, null, null, null, null, null, null));
        this.weakBind("jms/QueueConnectionFactory", new EvermindQueueConnectionFactory(addr, port, null, null, null, null, null, null, null, null, null, false));
        this.weakBind("jms/XAQueueConnectionFactory", new EvermindXAQueueConnectionFactory(addr, port, null, null, null, null, null, null, null, null, null));
        this.weakBind("jms/TopicConnectionFactory", new EvermindTopicConnectionFactory(addr, port, null, null, null, null, null, null, null, null, null, false));
        this.weakBind("jms/XATopicConnectionFactory", new EvermindXATopicConnectionFactory(addr, port, null, null, null, null, null, null, null, null, null));
    }

    private boolean recoverState(Set xaDest, Map xaState) throws InstantiationException {
        this.clearState();
        boolean hasXA = false;
        try {
            this.m_stateF = this.m_pDir + (this.m_pDir.endsWith("/") ? "" : "/") + STATE_FILE;
            this.m_stateM = USE_PERSISTENCE ? new PersistentMap(this.m_stateF, true, true, true) : new HashMap();
            hasXA = this.recoverDestinations(xaDest, xaState);
        }
        catch (Throwable ex) {
            JMSUtils.toInstantiationException(ex.getMessage(), ex);
        }
        return hasXA;
    }

    private boolean recoverDestinations(Set xaDest, Map xaState) throws Throwable {
        List dest = null;
        int lCommit = 0;
        int lRollback = 0;
        int xaPrepared = 0;
        Iterator iter = null;
        iter = this.m_stateM.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            if (CONFIGURATION.equals(key)) {
                dest = (List)entry.getValue();
                continue;
            }
            MyTrans trans = (MyTrans)entry.getValue();
            Integer tx = new Integer(trans.getTxid());
            this.m_xt.put(tx, key);
            this.m_tx.put(key, tx);
            if (trans.isCommitted()) {
                ++lCommit;
            } else if (trans.isXA()) {
                ++xaPrepared;
            } else {
                ++lRollback;
            }
            if (!JMSServer.getRememberAllXids()) continue;
            xaState.put(key, new HashSet());
        }
        HashSet xaUsed = new HashSet();
        if (dest != null) {
            JMSServerMessages.infoRecoveringTxns(this, lCommit, lRollback, xaPrepared);
            this.recoverDestinations(dest, xaState, xaDest, xaUsed);
        }
        iter = this.m_stateM.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            if (CONFIGURATION.equals(key)) continue;
            MyTrans trans = (MyTrans)entry.getValue();
            Integer tx = new Integer(trans.getTxid());
            if (xaUsed.contains(key) || JMSServer.getRememberAllXids() && trans.isXA()) continue;
            this.m_xt.remove(tx);
            this.m_tx.remove(key);
            iter.remove();
        }
        return xaPrepared > 0;
    }

    private void recoverDestinations(List l, Map xaState, Set xaDest, Set xaUsed) throws Throwable {
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        for (int i = 0; i < l.size(); ++i) {
            try {
                EvermindDestination d = (EvermindDestination)l.get(i);
                JMSServerMessages.infoRecoveringLocalTxns(this, d);
                ServerDestination sdest = ServerDestination.createDestination(this, d);
                this.mergeState(sdest, xaState, xaDest, xaUsed, sdest.getFile().scanTransactions());
                sdest.close();
                continue;
            }
            catch (Throwable ex) {
                exList.add(ex);
            }
        }
        if (exList.size() != 0) {
            JMSUtils.toInstantiationException("recoverDestinations", exList);
        }
    }

    private void mergeState(ServerDestination sdest, Map xaState, Set xaDest, Set xaUsed, Integer[] trans) throws Throwable {
        if (trans == null || trans.length == 0) {
            return;
        }
        xaDest.add(sdest.getDestination());
        for (int i = 0; i < trans.length; ++i) {
            SessionID sessionID = (SessionID)this.m_xt.get(trans[i]);
            HashSet<String> sdests = (HashSet<String>)xaState.get(sessionID);
            if (sdests == null) {
                sdests = new HashSet<String>();
                xaState.put(sessionID, sdests);
            }
            sdests.add(JMSUtils.getName(sdest.getDestination()));
            xaUsed.add(sessionID);
        }
    }

    private void bindDestination(EvermindDestination d) throws InstantiationException {
        try {
            this.bindThrough(d.getLocation(), d);
        }
        catch (Throwable ex) {
            JMSUtils.toInstantiationException("bindDestination", ex);
        }
    }

    private void unbindDestination(EvermindDestination d) {
        try {
            this.unbind(d.getLocation());
        }
        catch (NamingException nex) {
            s_traceLogger.fine("unbindDestination", nex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadDestination(EvermindDestination d, boolean force, boolean removePFile) throws Exception {
        if (d.equals(this.m_eQueue)) {
            throw new IllegalArgumentException(JMSServerMessages.getMessage("J2EE JMS-02513"));
        }
        Map destMap = this.m_provider.getDestinationMap();
        if (destMap.containsKey(d.getName())) {
            ServerDestination sdest;
            ServerDestination serverDestination = sdest = (ServerDestination)destMap.get(d.getName());
            synchronized (serverDestination) {
                if (!force && sdest.isActive()) {
                    throw new IllegalStateException(JMSServerMessages.getMessage("J2EE JMS-02515", this, d.getName()));
                }
                try {
                    this.unbindDestination(d);
                }
                catch (Throwable tr) {
                    // empty catch block
                }
                try {
                    ConsumerInfo.unloadConsumers(sdest.listDurableConsumers());
                }
                catch (Throwable tr) {
                    // empty catch block
                }
                try {
                    sdest.close();
                }
                catch (Throwable tr) {
                    // empty catch block
                }
            }
            destMap.remove(d.getName());
            String file = d.getPersistenceFile();
            if (!JMSUtils.isNull(file)) {
                this.m_pFileMap.remove(file);
                this.m_pDestList.remove(d);
                this.m_stateM.put(CONFIGURATION, this.m_pDestList);
                if (removePFile && !new File(file).delete()) {
                    JMSServerMessages.warningPersistenceFileRemoval(this, file, d.getName());
                }
            }
        } else {
            throw new IllegalArgumentException(JMSServerMessages.getMessage("J2EE JMS-03204", this, d.getName()));
        }
    }

    private void loadDestination(EvermindDestination d) throws Exception {
        String file;
        String name;
        Map dest = this.m_provider.getDestinationMap();
        if (dest.containsKey(name = JMSUtils.getName(d))) {
            JMSUtils.toInstantiationException(JMSServerMessages.getMessage("J2EE JMS-02506", this, d));
        }
        if (this.m_pURL != null) {
            d.setPersistenceURL(this.m_pURL);
        }
        if (this.m_pFileMap.containsKey(file = d.getPersistenceFile())) {
            JMSUtils.toInstantiationException(JMSServerMessages.getMessage("J2EE JMS-02507", this, file, this.m_pFileMap.get(file)));
        }
        ServerDestination sdest = ServerDestination.createDestination(this, d);
        dest.put(name, sdest);
        ConsumerInfo.loadConsumers(sdest.listDurableConsumers());
        if (!JMSUtils.isNull(file)) {
            this.m_pFileMap.put(file, d);
            this.m_pDestList.add(d);
        }
        if (name.equals("jms/Oc4jJmsExceptionQueue")) {
            this.m_eQueue = (EvermindQueue)d;
            this.m_eDest = sdest;
        }
        this.bindDestination(d);
    }

    private void loadDestinations(boolean hasXA, Set xaDest, Map xaState) throws InstantiationException {
        this.m_pDestList.clear();
        this.m_pFileMap.clear();
        HashMap<String, EvermindQueue> destMap = new HashMap<String, EvermindQueue>();
        destMap.put("jms/Oc4jJmsExceptionQueue", new EvermindQueue("jms/Oc4jJmsExceptionQueue", "jms/Oc4jJmsExceptionQueue", USE_PERSISTENCE ? this.m_pDir + "Oc4jJmsExceptionQueue" : null));
        destMap.putAll(this.m_config.getQueueMappings());
        destMap.putAll(this.m_config.getTopicMappings());
        Iterator iter = destMap.entrySet().iterator();
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            EvermindDestination dest = (EvermindDestination)entry.getValue();
            try {
                this.loadDestination(dest);
            }
            catch (Throwable ex) {
                exList.add(ex);
            }
        }
        if (exList.size() != 0) {
            JMSUtils.toInstantiationException(exList);
        }
        if (this.m_pDestList.size() != 0 && !USE_PERSISTENCE && !IN_OPMN) {
            JMSServerMessages.warningPersistenceDisabled(this, this.m_pDestList.size());
        }
        if (hasXA) {
            this.checkChanges(xaDest);
        }
        this.m_stateM.put(CONFIGURATION, this.m_pDestList);
        this.updateXaState(xaState);
    }

    private void bindDestinations() throws InstantiationException {
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        Iterator iter = null;
        try {
            Map.Entry entry;
            iter = this.m_config.getQueueMappings().entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                EvermindQueue q = (EvermindQueue)entry.getValue();
                this.bindDestination(q);
            }
            iter = this.m_config.getTopicMappings().entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                EvermindTopic t = (EvermindTopic)entry.getValue();
                this.bindDestination(t);
            }
        }
        catch (Throwable ex) {
            exList.add(ex);
        }
        if (exList.size() != 0) {
            JMSUtils.toInstantiationException("bindDestinations", exList);
        }
    }

    private boolean isAnyDestinationPersistent() {
        Map.Entry entry;
        Iterator iter = null;
        iter = this.m_config.getQueueMappings().entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            EvermindQueue q = (EvermindQueue)entry.getValue();
            if (JMSUtils.isNull(q.getPersistenceFile())) continue;
            return true;
        }
        iter = this.m_config.getTopicMappings().entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            EvermindTopic t = (EvermindTopic)entry.getValue();
            if (JMSUtils.isNull(t.getPersistenceFile())) continue;
            return true;
        }
        return false;
    }

    private void checkChanges(Set xaDest) throws InstantiationException {
        List oList = (List)this.m_stateM.get(CONFIGURATION);
        if (oList == null || oList.size() == 0) {
            return;
        }
        HashSet oSet = new HashSet(oList);
        HashSet pSet = new HashSet(this.m_pDestList);
        Iterator iter = oSet.iterator();
        while (iter.hasNext()) {
            EvermindDestination d = (EvermindDestination)iter.next();
            if (d.getName().equals("jms/Oc4jJmsExceptionQueue") || JMSUtils.isNull(d.getPersistenceFile()) || !xaDest.contains(d) || pSet.contains(d)) continue;
            JMSUtils.toInstantiationException(JMSServerMessages.getMessage("J2EE JMS-02511", this, JMSServer.ppConfig(oList), JMSServer.ppConfig(this.m_pDestList)));
        }
    }

    private static String ppConfig(List l) {
        String ret = "";
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            EvermindDestination d = (EvermindDestination)iter.next();
            if (d.getName().equals("jms/Oc4jJmsExceptionQueue")) continue;
            ret = ret + ServerDestination.toXML(d);
        }
        return ret;
    }

    private void updateXaState(Map oldState) {
        Map dest = this.m_provider.getDestinationMap();
        Map xaState = this.m_provider.getXaState();
        xaState.clear();
        Iterator iter = oldState.keySet().iterator();
        while (iter.hasNext()) {
            SessionID sessionID = (SessionID)iter.next();
            Set oldDests = (Set)oldState.get(sessionID);
            TxDestinations newDests = (TxDestinations)xaState.get(sessionID);
            if (newDests == null) {
                newDests = new TxDestinations();
                xaState.put(sessionID, newDests);
            }
            Iterator niter = oldDests.iterator();
            while (niter.hasNext()) {
                newDests.add((ServerDestination)dest.get(niter.next()));
            }
        }
    }

    private void initStats() {
        try {
            JMXSupport.forceAdd(new JMSAdministrator(this));
        }
        catch (Throwable ex) {
            s_traceLogger.fine("initStats", ex);
        }
        this.m_jstats = JMSStats.create("", "JMS", "JMS");
        JMS m_jmsResource = new JMS(this);
        this.m_jstats.setMBean(m_jmsResource);
        this.m_stats = (JMSStatsImpl)m_jmsResource.getstats();
        this.m_jstats.initPhase("activeConnections");
        this.m_jstats.initPhase("activeHandlers");
        this.m_jstats.state("stats", this.m_stats, true);
        Knobs.state(this.m_jstats);
    }

    private void weakBind(String name, Object val) throws InstantiationException {
        if (!this.m_ctx.containsKey(name)) {
            this.m_ctx.put(name, val);
        }
    }

    private void bind(String name, Object val) throws InstantiationException {
        if (this.m_ctx.containsKey(name)) {
            JMSUtils.toInstantiationException(JMSServerMessages.getMessage("J2EE JMS-02509", this, name, this.m_ctx.get(name), val));
        }
        this.m_ctx.put(name, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindThrough(String name, Object val) throws InstantiationException, NamingException {
        this.bind(name, val);
        if (this.m_serverContext != null) {
            boolean success = false;
            try {
                this.m_serverContext.rebind(name, val);
                success = true;
            }
            finally {
                if (!success) {
                    this.m_ctx.remove(name);
                }
            }
        }
    }

    static {
        s_traceLogger = new JMSTraceLogger(JMSServer.class);
        s_jmsServer = null;
        BASIC_PERSISTENCE = (Boolean)JMSServerProxy.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.usePersistence");
        FORCE_PERSISTENCE = (Boolean)JMSServerProxy.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.forcePersistence");
        INTRA_SESSION = (Boolean)JMSServerProxy.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.intraSession");
        s_printStackTrace = (Boolean)KnobsController.getKnobsController().listenToConfigProperty("oc4j.jms.printStackTrace", new ConfigPropertyListener(){

            public void onConfigPropertyChange(ConfigPropertyEvent event) {
                JMSServer.setPrintStackTrace((Boolean)event.getPropertyValue());
            }
        });
        s_debug = (Boolean)KnobsController.getKnobsController().listenToConfigProperty("oc4j.jms.debug", new ConfigPropertyListener(){

            public void onConfigPropertyChange(ConfigPropertyEvent event) {
                JMSServer.setDebug((Boolean)event.getPropertyValue());
            }
        });
        s_rememberAllXids = (Boolean)KnobsController.getKnobsController().listenToConfigProperty("oc4j.jms.rememberAllXids", new ConfigPropertyListener(){

            public void onConfigPropertyChange(ConfigPropertyEvent event) {
                JMSServer.setRememberAllXids((Boolean)event.getPropertyValue());
            }
        });
        s_checkPermissions = (Boolean)KnobsController.getKnobsController().listenToConfigProperty("oc4j.jms.checkPermissions", new ConfigPropertyListener(){

            public void onConfigPropertyChange(ConfigPropertyEvent event) {
                JMSServer.setCheckPermissions((Boolean)event.getPropertyValue());
            }
        });
        IN_OPMN = System.getProperties().containsKey("OPMN");
        USE_PERSISTENCE = FORCE_PERSISTENCE || BASIC_PERSISTENCE && !IN_OPMN;
        EXPIRATION_INTERVAL = (Long)JMSServerProxy.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.expirationInterval");
    }

    private static final class MyTrans
    implements Serializable {
        private final int m_txid;
        private final byte m_state;

        MyTrans(int txid, byte state) {
            this.m_txid = txid;
            this.m_state = state;
        }

        public String toString() {
            return "MyTrans[txid=" + this.m_txid + "," + "state=" + ServerFile.pp(this.m_state) + "]";
        }

        public int getTxid() {
            return this.m_txid;
        }

        public boolean isXA() {
            return this.m_txid < 0;
        }

        public boolean isCommitted() {
            return this.m_state == 13;
        }

        public boolean isRolledback() {
            return this.m_state == 7;
        }

        public boolean isOpen() {
            return this.m_state == 11;
        }
    }
}

