/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConnectInfo;
import com.evermind.server.jms.EvermindXAConnection;
import com.evermind.server.jms.JMSDomain;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import java.io.Serializable;
import java.net.InetAddress;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;

public final class EvermindXAConnectionFactory
extends ConnectInfo
implements Serializable,
XAConnectionFactory,
JMSDomain {
    static final long serialVersionUID = 7182214197974786753L;

    EvermindXAConnectionFactory(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID) {
        super(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID);
    }

    public String toString() {
        return "XAConnectionFactory[" + this.getAddr() + "," + this.getPort() + "," + this.getUser() + "," + this.getClientID() + "]";
    }

    public final synchronized XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(this.getUser(), this.getPass());
    }

    public final synchronized XAConnection createXAConnection(final String user, final String pass) throws JMSException {
        XAConnection conn = null;
        try {
            conn = (XAConnection)this.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return EvermindXAConnectionFactory.this.unprivileged_createXAConnection(user, pass);
                }
            });
        }
        catch (JMSException jex) {
            throw jex;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            JMSUtils.toJMSSecurityException(ex.getMessage());
        }
        return conn;
    }

    private XAConnection unprivileged_createXAConnection(String user, String pass) throws JMSException {
        return new EvermindXAConnection(this.getAddr(), this.getPort(), this.getTunnel(), this.getKeystore(), this.getKeystorePassword(), this.getTruststore(), this.getTruststorePassword(), this.getProvider(), user, pass, this.getClientID(), 2);
    }

    public final synchronized boolean isXA() {
        return true;
    }

    public final synchronized int getDomain() {
        return 2;
    }
}

