/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindConnection;
import com.evermind.server.jms.EvermindSession;
import com.evermind.server.jms.EvermindTopicSession;
import com.evermind.server.jms.EvermindXATopicSession;
import java.net.InetAddress;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class EvermindTopicConnection
extends EvermindConnection
implements TopicConnection {
    public EvermindTopicConnection(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass) throws JMSException {
        this(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, null, false);
    }

    EvermindTopicConnection(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID, boolean isXA) throws JMSException {
        super(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID, isXA, 1);
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Topic t, String selector, ServerSessionPool pool, int maxMessages) throws JMSException {
        return super.createConnectionConsumer((Destination)t, selector, pool, maxMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        this.lock("createTopicSession");
        try {
            EvermindSession evermindSession = this.isXA() ? new EvermindXATopicSession(this) : new EvermindTopicSession(this, transacted, ackMode);
            return evermindSession;
        }
        finally {
            this.unlock();
        }
    }
}

