/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTSession;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public final class CMTTopicSubscriber
implements TopicSubscriber {
    private final CMTSession m_sess;
    private final TopicSubscriber m_sub;

    CMTTopicSubscriber(CMTSession sess, TopicSubscriber sub) {
        this.m_sess = sess;
        this.m_sub = sub;
    }

    public TopicSubscriber unwrap() {
        return this.m_sub;
    }

    public String toString() {
        return "CMTTopicSubscriber[" + this.m_sess + "," + this.m_sub + "]";
    }

    public void close() throws JMSException {
        this.m_sub.close();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.m_sub.getMessageListener();
    }

    public String getMessageSelector() throws JMSException {
        return this.m_sub.getMessageSelector();
    }

    public boolean getNoLocal() throws JMSException {
        return this.m_sub.getNoLocal();
    }

    public Topic getTopic() throws JMSException {
        return this.m_sub.getTopic();
    }

    public synchronized Message receive() throws JMSException {
        this.m_sess.checkForCMT();
        return this.m_sub.receive();
    }

    public synchronized Message receive(long ms) throws JMSException {
        this.m_sess.checkForCMT();
        return this.m_sub.receive(ms);
    }

    public synchronized Message receiveNoWait() throws JMSException {
        this.m_sess.checkForCMT();
        return this.m_sub.receiveNoWait();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.m_sub.setMessageListener(listener);
    }
}

