/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTTopicSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public final class CMTTopicPublisher
implements TopicPublisher {
    private final CMTTopicSession m_sess;
    private final TopicPublisher m_pub;

    CMTTopicPublisher(CMTTopicSession sess, TopicPublisher pub) {
        this.m_sess = sess;
        this.m_pub = pub;
    }

    public TopicPublisher unwrap() {
        return this.m_pub;
    }

    public String toString() {
        return "CMTTopicPublisher[" + this.m_sess + "," + this.m_pub + "]";
    }

    public void close() throws JMSException {
        this.m_pub.close();
    }

    public int getDeliveryMode() throws JMSException {
        return this.m_pub.getDeliveryMode();
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.m_pub.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.m_pub.getDisableMessageTimestamp();
    }

    public int getPriority() throws JMSException {
        return this.m_pub.getPriority();
    }

    public long getTimeToLive() throws JMSException {
        return this.m_pub.getTimeToLive();
    }

    public Topic getTopic() throws JMSException {
        return this.m_pub.getTopic();
    }

    public Destination getDestination() throws JMSException {
        return this.m_pub.getTopic();
    }

    public synchronized void publish(Topic t, Message msg) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_pub.publish(t, msg);
    }

    public synchronized void publish(Topic t, Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_pub.publish(t, msg, deliveryMode, priority, ttl);
    }

    public synchronized void publish(Message msg) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_pub.publish(msg);
    }

    public synchronized void publish(Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_pub.publish(msg, deliveryMode, priority, ttl);
    }

    public synchronized void send(Destination d, Message msg) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_pub.send(d, msg);
    }

    public synchronized void send(Destination d, Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_pub.send(d, msg, deliveryMode, priority, ttl);
    }

    public synchronized void send(Message msg) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_pub.send(msg);
    }

    public synchronized void send(Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_pub.send(msg, deliveryMode, priority, ttl);
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.m_pub.setDeliveryMode(deliveryMode);
    }

    public void setDisableMessageID(boolean noMsgID) throws JMSException {
        this.m_pub.setDisableMessageID(noMsgID);
    }

    public void setDisableMessageTimestamp(boolean noTimestamp) throws JMSException {
        this.m_pub.setDisableMessageTimestamp(noTimestamp);
    }

    public void setPriority(int priority) throws JMSException {
        this.m_pub.setPriority(priority);
    }

    public void setTimeToLive(long ttl) throws JMSException {
        this.m_pub.setTimeToLive(ttl);
    }
}

