/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTConnection;
import com.evermind.server.jms.CMTQueueConnection;
import com.evermind.server.jms.CMTTopicConnection;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;

public final class CMTConnectionFactory
implements Serializable,
ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private final Object m_fact;
    private final boolean m_isXA;

    public CMTConnectionFactory(Object fact, boolean isXA) {
        this.m_fact = fact;
        this.m_isXA = isXA;
    }

    public CMTConnectionFactory(Object fact) {
        this(fact, fact instanceof XAConnectionFactory || fact instanceof XAQueueConnectionFactory || fact instanceof XATopicConnectionFactory);
    }

    public Object unwrap() {
        return this.m_fact;
    }

    public String toString() {
        return "CMTConnectionFactory[" + this.m_fact + "]";
    }

    public Connection createConnection() throws JMSException {
        return this.m_isXA ? new CMTConnection(((XAConnectionFactory)this.m_fact).createXAConnection()) : ((ConnectionFactory)this.m_fact).createConnection();
    }

    public Connection createConnection(String user, String pass) throws JMSException {
        return this.m_isXA ? new CMTConnection(((XAConnectionFactory)this.m_fact).createXAConnection(user, pass)) : ((ConnectionFactory)this.m_fact).createConnection(user, pass);
    }

    public synchronized QueueConnection createQueueConnection() throws JMSException {
        return this.m_isXA ? new CMTQueueConnection(((XAQueueConnectionFactory)this.m_fact).createXAQueueConnection()) : ((QueueConnectionFactory)this.m_fact).createQueueConnection();
    }

    public synchronized QueueConnection createQueueConnection(String user, String pass) throws JMSException {
        return this.m_isXA ? new CMTQueueConnection(((XAQueueConnectionFactory)this.m_fact).createXAQueueConnection(user, pass)) : ((QueueConnectionFactory)this.m_fact).createQueueConnection(user, pass);
    }

    public synchronized TopicConnection createTopicConnection() throws JMSException {
        return this.m_isXA ? new CMTTopicConnection(((XATopicConnectionFactory)this.m_fact).createXATopicConnection()) : ((TopicConnectionFactory)this.m_fact).createTopicConnection();
    }

    public synchronized TopicConnection createTopicConnection(String user, String pass) throws JMSException {
        return this.m_isXA ? new CMTTopicConnection(((XATopicConnectionFactory)this.m_fact).createXATopicConnection(user, pass)) : ((TopicConnectionFactory)this.m_fact).createTopicConnection(user, pass);
    }
}

