/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.util.ServerProperties;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterMapping
implements XMLizable,
Serializable {
    private String filterName;
    private String urlPattern;
    private String servletName;
    public static final String DISPATCHER_REQUEST = "REQUEST";
    public static final String DISPATCHER_FORWARD = "FORWARD";
    public static final String DISPATCHER_INCLUDE = "INCLUDE";
    public static final String DISPATCHER_ERROR = "ERROR";
    public static final int MASK_REQUEST = 1;
    public static final int MASK_INCLUDE = 16;
    public static final int MASK_FORWARD = 256;
    public static final int MASK_ERROR = 4096;
    static final String DISPATCHER_FORMAUTH = "FORMAUTH";
    public static final int MASK_FORMAUTH = 65536;
    private int dispatchMode;
    private List dispatchers;
    private boolean isPartOfOrionWeb = false;

    public FilterMapping() {
    }

    public FilterMapping(String filterName, String URLPattern, String servletName, String[] dispatchers) throws InstantiationException {
        this(filterName, URLPattern, servletName, dispatchers, false);
    }

    protected FilterMapping(String filterName, String URLPattern, String servletName, String[] dispatchers, boolean isParsingOrionXML) throws InstantiationException {
        this.filterName = filterName;
        this.urlPattern = URLPattern;
        this.servletName = servletName;
        if (dispatchers != null) {
            for (int i = 0; i < dispatchers.length; ++i) {
                this.addDispatcher(dispatchers[i], isParsingOrionXML);
            }
        }
    }

    public FilterMapping(Node node) throws InstantiationException {
        this(node, false);
    }

    protected FilterMapping(Node node, boolean isParsingOrionXML) throws InstantiationException {
        NodeList childNodes = node.getChildNodes();
        String childNodeName = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            childNodeName = childNodes.item(i).getNodeName();
            if (childNodeName.startsWith("#")) continue;
            if (childNodeName.equals("filter-name")) {
                this.filterName = XMLUtils.getStringValue(childNodes.item(i));
                continue;
            }
            if (childNodeName.equals("url-pattern")) {
                if (ServerProperties.getOracleCtsUseCtsFlags() && this.filterName == null) {
                    throw new InstantiationException("filter-mapping subelement is not defined in correct order: url-pattern");
                }
                this.urlPattern = XMLUtils.getUrlPatternValue(childNodes.item(i));
                continue;
            }
            if (childNodeName.equals("servlet-name")) {
                if (ServerProperties.getOracleCtsUseCtsFlags() && this.filterName == null) {
                    throw new InstantiationException("filter-mapping subelement is not defined in correct order: servlet-name");
                }
                this.servletName = XMLUtils.getStringValue(childNodes.item(i));
                continue;
            }
            if (!childNodeName.equals("dispatcher")) continue;
            this.addDispatcher(XMLUtils.getStringValue(childNodes.item(i)), isParsingOrionXML);
        }
        if (this.filterName == null) {
            throw new InstantiationException("No filter-name specified in filter-mapping tag");
        }
        if (this.urlPattern != null && !this.urlPattern.startsWith("/") && !this.urlPattern.startsWith("*.")) {
            this.urlPattern = "/".concat(this.urlPattern);
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setFilterName(String name) {
        this.filterName = name;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String name) {
        if (name != null && name.equals("")) {
            name = null;
        }
        this.servletName = name;
    }

    public void setURLPattern(String name) {
        if (name != null && name.equals("")) {
            name = null;
        }
        this.urlPattern = name;
    }

    void addDispatcher(String dispatcher, boolean isParsingOrionXML) throws InstantiationException {
        if (dispatcher.equals(DISPATCHER_REQUEST)) {
            this.dispatchMode |= 1;
        } else if (dispatcher.equals(DISPATCHER_FORWARD)) {
            this.dispatchMode |= 0x100;
        } else if (dispatcher.equals(DISPATCHER_INCLUDE)) {
            this.dispatchMode |= 0x10;
        } else if (dispatcher.equals(DISPATCHER_ERROR)) {
            this.dispatchMode |= 0x1000;
        } else if (dispatcher.equals(DISPATCHER_FORMAUTH)) {
            if (!isParsingOrionXML) {
                throw new InstantiationException("filter-mapping FORMAUTH can only be used in <orion-web-app> config files");
            }
            this.dispatchMode |= 0x10000;
            this.isPartOfOrionWeb = true;
        } else {
            throw new InstantiationException("Unknown dispatcher specified in filter-mapping tag :" + dispatcher);
        }
        if (this.dispatchers == null) {
            this.dispatchers = new ArrayList();
        }
        this.dispatchers.add(dispatcher);
    }

    public int getDispatchMode() throws InstantiationException {
        if (this.dispatchMode == 0) {
            this.dispatchMode = 1;
        }
        return this.dispatchMode;
    }

    public List getDispatchers() {
        return this.dispatchers;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<filter-mapping>");
        if (this.filterName != null) {
            out.println(indention + "\t<filter-name>" + XMLUtils.encode(this.filterName) + "</filter-name>");
        }
        if (this.urlPattern != null) {
            out.println(indention + "\t<url-pattern>" + XMLUtils.encode(this.urlPattern) + "</url-pattern>");
        } else if (this.servletName != null) {
            out.println(indention + "\t<servlet-name>" + XMLUtils.encode(this.servletName) + "</servlet-name>");
        }
        if (this.dispatchers != null) {
            Iterator iter = this.dispatchers.iterator();
            while (iter.hasNext()) {
                out.println(indention + "\t<dispatcher>" + XMLUtils.encode((String)iter.next()) + "</dispatcher>");
            }
        }
        out.println(indention + "</filter-mapping>");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("filter-mapping: ");
        buf.append("  filter-name: ");
        buf.append(this.getFilterName());
        buf.append("  url-pattern: ");
        buf.append(this.getURLPattern());
        buf.append("  servlet-name: ");
        buf.append(this.getServletName());
        buf.append("  dispatcher: ");
        buf.append(this.getDispatchers());
        buf.append("\n");
        return buf.toString();
    }

    public boolean isPartOfOrionWeb() {
        return this.isPartOfOrionWeb;
    }

    public void setPartOfOrionWeb(boolean partOfOrionWeb) {
        this.isPartOfOrionWeb = partOfOrionWeb;
    }
}

