/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.http.deployment.WebApp24Descriptor;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Node;

public class ContextParam
implements XMLizable,
Serializable,
WebApp24Descriptor {
    private String name;
    private String value;
    private String runtimeValue;
    private String description;

    public ContextParam() {
    }

    public ContextParam(String name, String value, String description) {
        this.name = name;
        this.value = value;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.runtimeValue != null) {
            return this.runtimeValue;
        }
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<context-param>");
        out.println(indention + "\t<param-name>" + XMLUtils.encode(this.name) + "</param-name>");
        out.println(indention + "\t<param-value>" + XMLUtils.encode(this.value) + "</param-value>");
        if (this.description != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        }
        out.println(indention + "</context-param>");
    }

    public void writeWebApp24XML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<context-param>");
        if (this.description != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        }
        out.println(indention + "\t<param-name>" + XMLUtils.encode(this.name) + "</param-name>");
        out.println(indention + "\t<param-value>" + XMLUtils.encode(this.value) + "</param-value>");
        out.println(indention + "</context-param>");
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.println(indention + "<context-param-mapping name=\"" + XMLUtils.encode(this.name) + "\">" + XMLUtils.encode(this.getValue()) + "</context-param-mapping>");
    }

    public void parseOrionXML(Node parent) {
        this.runtimeValue = XMLUtils.getStringValue(parent);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setRuntimeValue(String value) {
        this.runtimeValue = value;
    }

    public boolean hasRuntimeValue() {
        return this.runtimeValue != null;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("context-param      : ");
        buf.append("  description      : ");
        buf.append(this.getDescription());
        buf.append("\n");
        buf.append("  param-name      : ");
        buf.append(this.getName());
        buf.append("\n");
        buf.append("  param-value      : ");
        buf.append(this.getValue());
        buf.append("\n");
        return buf.toString();
    }
}

