/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.administration;

import com.evermind.naming.ContextRemote;
import com.evermind.naming.DefaultContextRemote;
import com.evermind.server.ServerComponent;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.administration.HttpApplicationAdministrator;
import com.evermind.server.http.administration.HttpSessionRuntimeInfo;
import com.evermind.server.http.deployment.ServletDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.naming.NamingException;

public class DefaultHttpApplicationAdministrator
implements HttpApplicationAdministrator {
    protected HttpApplication application;
    protected HttpApplicationConfig config;

    public DefaultHttpApplicationAdministrator(HttpApplication application, HttpApplicationConfig config) {
        this.application = application;
        this.config = config;
    }

    public List getDefinedServlets() {
        return this.config.getLocallyDefinedServlets();
    }

    public ServletDescriptor getServlet(String name) {
        return this.config.getServletDescriptor(name, true);
    }

    public String[][] getSessionIDs() {
        if (this.application == null) {
            return new String[0][2];
        }
        return this.application.getSessionIDs();
    }

    public HttpSessionRuntimeInfo getSession(String id) {
        if (this.application == null) {
            return null;
        }
        return this.application.getSessionByID(id);
    }

    public void setSessionAttribute(String id, String name, Object value) {
        if (this.application != null) {
            this.application.setSessionAttribute(id, name, value);
        }
    }

    public void invalidateSessions(Collection ids) {
        if (this.application != null) {
            this.application.invalidateSessions(ids);
        }
    }

    public ContextRemote getFileContext() {
        if (this.config.getContext() == null) {
            return null;
        }
        return new DefaultContextRemote(this.config.getContext());
    }

    public void setEnvironmentEntry(String name, Object value) throws InstantiationException, IOException {
        try {
            ServerComponent.setEnvironmentEntry((ServerComponent)((Object)this.config), name, value, this.config.getEnvironmentEntry(name), this.application.getEnvironmentContext());
        }
        catch (NamingException e) {
            throw new InstantiationException(e.getMessage());
        }
    }
}

