/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.io.IOUtils;
import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.OC4JMonitorThread;
import com.evermind.server.OC4JServer;
import com.evermind.server.OC4JServiceInfo;
import com.evermind.server.XMLApplicationServerConfig;
import com.evermind.server.XMLServerConfig;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.http.FormattedRequestLogger;
import com.evermind.server.http.HttpApplicationConfigContext;
import com.evermind.server.http.HttpApplicationReference;
import com.evermind.server.http.HttpSiteConfig;
import com.evermind.server.http.ODLRequestLogger;
import com.evermind.server.http.RequestLogger;
import com.evermind.server.http.StandardRequestLogger;
import com.evermind.server.http.XMLHttpApplicationConfigContext;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.ConfigUtils;
import com.evermind.util.HTTPProperties;
import com.evermind.xml.XMLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.management.shared.WebSiteAccessLog;
import oracle.oc4j.admin.management.shared.WebSiteODLAccessLog;
import org.w3c.dom.Node;

public class XMLHttpSiteConfig
extends XMLServerConfig
implements HttpSiteConfig {
    protected XMLHttpSiteConfig parent;
    protected SSLConfig sslConfig;
    protected List hostNameHeaders;
    protected HttpApplicationReference defaultApplication;
    protected boolean logRequestInfo;
    protected boolean useKeepAlives = true;
    protected long userApplicationMaxInactivityTime;
    protected boolean secure;
    protected String userDirPrefix;
    protected String userDirSuffix;
    protected RequestLogger requestLogger;
    protected String requestLogPath;
    protected String requestLogFormat;
    protected String requestLogSuffix;
    protected int requestLogSplitType;
    protected XMLApplicationServerConfig serverConfig;
    protected List applications;
    protected String posingAsHostname;
    protected int posingAsPort = -1;
    protected int islandID = -1;
    protected boolean useMultiInstanceIslandID = false;
    protected byte protocol;
    private String threadPoolNm = null;
    protected int requestMaxSize = 15000;
    private final String WriteXMLVersusInitializeStateSynchronizationLock = "WriteXMLVersusInitializeStateSynchronizationLock";
    private static Logger m_traceLogger = TraceLogger.getLogger(XMLHttpSiteConfig.class);

    public XMLHttpSiteConfig(XMLServerConfig parent, XMLApplicationServerConfig serverConfig) {
        super(parent);
        if (parent instanceof XMLHttpSiteConfig) {
            this.parent = (XMLHttpSiteConfig)parent;
        }
        this.serverConfig = serverConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.startsWith("#")) {
            return;
        }
        if (name.equals("name")) {
            this.setName(XMLUtils.getStringValue(node));
            return;
        } else if (name.equals("default-web-app")) {
            try {
                this.defaultApplication = new HttpApplicationReference(node, true);
                if (this.defaultApplication.getRoot() == null || this.defaultApplication.getRoot().equals("/")) return;
                this.addApplication(this.defaultApplication);
                return;
            }
            catch (InstantiationException e) {
                throw new InstantiationException("Error initializing web-site at " + this + ", error instantiating default web-app: " + e.getMessage());
            }
        } else if (name.equals("description")) {
            this.setDescription(XMLUtils.getStringValue(node));
            return;
        } else if (name.equals("web-app")) {
            if (this.applications == null) {
                this.applications = new Vector();
            }
            try {
                this.addApplication(new HttpApplicationReference(node, false));
                return;
            }
            catch (InstantiationException e) {
                throw new InstantiationException("Error initializing web-site at " + this + ": " + e.getMessage());
            }
        } else if (name.equals("odl-access-log")) {
            this.requestLogPath = XMLUtils.getNodeAttribute(node, "path");
            if (this.requestLogPath == null) {
                this.requestLogPath = XMLUtils.getStringValue(node);
            }
            if (this.requestLogPath == null || this.requestLogPath.trim().length() <= 0) return;
            int maxFileSize = Integer.parseInt(XMLUtils.getNodeAttribute(node, "max-file-size"));
            int maxDirectorySize = Integer.parseInt(XMLUtils.getNodeAttribute(node, "max-directory-size"));
            this.parseAccessLogFormat(node);
            try {
                URL url = this.determineMultiInstancePath();
                this.requestLogger = new ODLRequestLogger(this.requestLogPath, url.getPath(), maxFileSize, maxDirectorySize, null);
                return;
            }
            catch (Exception e) {
                if (!(e instanceof InstantiationException)) throw new InstantiationException("Could not start access logfile for " + this.getName() + "(" + this.requestLogPath + ")");
                throw (InstantiationException)e;
            }
        } else if (name.equals("access-log")) {
            this.requestLogPath = XMLUtils.getNodeAttribute(node, "path");
            if (this.requestLogPath == null) {
                this.requestLogPath = XMLUtils.getStringValue(node);
            }
            if (this.requestLogPath == null || this.requestLogPath.trim().length() <= 0) return;
            this.parseAccessLogFormat(node);
            URL url = null;
            try {
                url = this.determineMultiInstancePath();
                if (this.requestLogSplitType != 0 || this.requestLogFormat != null && !this.requestLogFormat.equals("$ip - - [$time] '$request' $status $size")) {
                    if (!url.getProtocol().equals("file")) {
                        throw new InstantiationException("File URL needed for access log");
                    }
                    this.requestLogger = new FormattedRequestLogger(url.getFile(), this.requestLogSplitType, this.requestLogFormat, false, this.requestLogSuffix);
                    return;
                }
                OutputStream stream = url.getProtocol().equalsIgnoreCase("file") ? new FileOutputStream(url.getFile(), true) : url.openConnection().getOutputStream();
                this.requestLogger = new StandardRequestLogger(stream, false);
                return;
            }
            catch (Exception e) {
                if (!(e instanceof InstantiationException)) throw new InstantiationException("Could not start access logfile for " + this.getName() + "(" + url + ")");
                throw (InstantiationException)e;
            }
        } else if (name.equals("user-web-apps")) {
            this.parseUserWebAppsNode(node);
            return;
        } else if (name.equals("log-request-info")) {
            this.logRequestInfo = "true".equalsIgnoreCase(XMLUtils.getStringValue(node));
            return;
        } else if (name.equals("ssl-config")) {
            this.sslConfig = new SSLConfig(node, this.getURL());
            return;
        } else if (name.equals("frontend")) {
            this.parseFrontendNode(node);
            return;
        } else {
            super.parseDeploymentMainNode(node);
        }
    }

    public void parseAccessLogFormat(Node node) {
        this.requestLogFormat = XMLUtils.getNodeAttribute(node, "format");
        this.requestLogSplitType = 0;
        this.requestLogSuffix = XMLUtils.getNodeAttribute(node, "suffix");
        String splitString = XMLUtils.getNodeAttribute(node, "split");
        if (splitString != null) {
            if (splitString.equalsIgnoreCase("month")) {
                this.requestLogSplitType = 4;
            } else if (splitString.equalsIgnoreCase("week")) {
                this.requestLogSplitType = 3;
            } else if (splitString.equalsIgnoreCase("day")) {
                this.requestLogSplitType = 2;
            } else if (splitString.equalsIgnoreCase("hour")) {
                this.requestLogSplitType = 1;
            }
        }
    }

    protected URL determineMultiInstancePath() throws IOException, MalformedURLException {
        URL url = ConfigUtils.getURL(this.getURL(), this.requestLogPath);
        if (url.getProtocol().equals("file") && OC4JServer.getInstanceId() != null) {
            String tmpPath = IOUtils.getInstancePath(url.getFile(), OC4JServer.getInstanceId(), true);
            url = new File(tmpPath).toURL();
        }
        return url;
    }

    public RequestLogger getRequestLogger() {
        return this.requestLogger;
    }

    public boolean getUseKeepAlives() {
        return this.useKeepAlives;
    }

    public void init(URL url) throws InstantiationException, IOException {
        this.applications = null;
        if (this.parent != null) {
            this.userDirPrefix = this.parent.userDirPrefix;
            this.userDirSuffix = this.parent.userDirSuffix;
        }
        super.init(url);
        this._setIslandID(this.islandID);
        if (this.defaultApplication == null) {
            throw new InstantiationException("default-web-app not specified for " + this);
        }
    }

    protected synchronized void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("virtual-hosts")) {
            this.setVirtualHosts(value);
        } else if (name.equals("secure")) {
            this.secure = "true".equalsIgnoreCase(value);
        } else if (name.equals("use-keep-alives")) {
            this.useKeepAlives = !"false".equalsIgnoreCase(value);
        } else if (name.equals("cluster-island")) {
            this._setIslandID(Integer.parseInt(value));
        } else if (name.equals("log-request-info")) {
            this.logRequestInfo = "true".equalsIgnoreCase(value);
        } else if (name.equals("display-name")) {
            this.setDisplayName(value);
        } else if (name.equals("custom-thread-pool")) {
            this.setThreadPoolNm(value);
        } else if (name.equals("protocol")) {
            this.setProtocol(XMLHttpSiteConfig.getProtocol(value));
        } else if (name.equals("max-request-size")) {
            this.requestMaxSize = XMLUtils.parseInt("max-request-size", value);
        } else {
            super.parseDeploymentRootNodeValue(name, value);
        }
    }

    public synchronized void parseFrontendNode(Node node) {
        String portString;
        String hostname = XMLUtils.getNodeAttribute(node, "host");
        if (hostname != null) {
            this.posingAsHostname = hostname;
        }
        if ((portString = XMLUtils.getNodeAttribute(node, "port")) != null) {
            try {
                this.posingAsPort = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this.posingAsHostname != null && this.posingAsPort > -1) {
            HTTPProperties.setUseCanonicalName(true);
        }
    }

    public String getPosingAsHostname() {
        return this.posingAsHostname;
    }

    public int getPosingAsPort() {
        return this.posingAsPort;
    }

    public List getHostNameHeaders() {
        if (this.hostNameHeaders == null) {
            return Collections.EMPTY_LIST;
        }
        return this.hostNameHeaders;
    }

    public List getApplications() throws InstantiationException {
        if (this.applications == null) {
            return Collections.EMPTY_LIST;
        }
        return this.applications;
    }

    public HttpApplicationReference getDefaultApplication() {
        return this.defaultApplication;
    }

    public boolean isSecure() {
        return this.secure;
    }

    protected int getDefaultPort() {
        if (this.protocol == 2) {
            return 0;
        }
        return this.secure ? 443 : 80;
    }

    public HttpApplicationConfigContext getUserApplication(String username) throws InstantiationException {
        if (this.userDirPrefix == null) {
            return null;
        }
        StringBuffer path = new StringBuffer();
        path.append(this.userDirPrefix);
        path.append(username);
        if (this.userDirSuffix != null) {
            path.append(this.userDirSuffix);
        }
        if (new File(path.toString()).exists()) {
            File descriptorFile = new File(path.toString() + File.separatorChar + "WEB-INF" + File.separatorChar + "web.xml");
            if (descriptorFile.exists()) {
                XMLHttpApplicationConfigContext context = new XMLHttpApplicationConfigContext((EnterpriseArchive)this.serverConfig.getDefaultApplicationConfig(), username + " web-app", this.getURL(), path.toString(), (XMLHttpApplicationConfigContext)this.serverConfig.getDefaultHttpApplicationConfig(), "/~" + username, null, -1L, false, false, false, null);
                return context;
            }
            new File(path.toString() + File.separatorChar + "WEB-INF").mkdir();
            new File(path.toString() + File.separatorChar + "WEB-INF" + File.separatorChar + "lib").mkdir();
            new File(path.toString() + File.separatorChar + "WEB-INF" + File.separatorChar + "classes").mkdir();
            XMLHttpApplicationConfigContext context = new XMLHttpApplicationConfigContext((EnterpriseArchive)this.serverConfig.getDefaultApplicationConfig(), username + " web-app", this.getURL(), path.toString(), this.serverConfig.getDefaultHttpApplicationConfig(), "/~" + username, null, this.getUserApplicationMaxInactivityTime(), false, false, false, null);
            HttpApplicationDescriptor descriptor = new HttpApplicationDescriptor((EnterpriseArchive)this.serverConfig.getDefaultApplicationConfig(), username + " web-app", (HttpApplicationDescriptor)this.serverConfig.getDefaultHttpApplicationConfig().getConfiguration(), null, false);
            context.setConfiguration(descriptor);
            try {
                descriptor.setPackaged(true);
                descriptor.setURL(descriptorFile.toURL());
                descriptor.store();
            }
            catch (IOException e) {
                return null;
            }
            return context;
        }
        return null;
    }

    public boolean equals(Object otherObject) {
        try {
            XMLHttpSiteConfig other = (XMLHttpSiteConfig)otherObject;
            if (!this.getURL().equals(other.getURL())) {
                return false;
            }
            if (this.lastModified != other.lastModified) {
                return false;
            }
            if (this.parent != null) {
                if (other.parent == null) {
                    return false;
                }
                return this.parent.lastModified == this.lastModified;
            }
            return other.parent == null;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() throws InstantiationException {
        String string = "WriteXMLVersusInitializeStateSynchronizationLock";
        synchronized ("WriteXMLVersusInitializeStateSynchronizationLock") {
            this.hostNameHeaders = null;
            this.setDescription(null);
            this.defaultApplication = null;
            this.secure = false;
            this.sslConfig = null;
            this.userDirPrefix = null;
            this.userDirSuffix = null;
            super.update();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void parseUserWebAppsNode(Node parent) {
        String homeDir = XMLUtils.getNodeAttribute(parent, "path");
        String maxInactiveTimeString = XMLUtils.getNodeAttribute(parent, "max-inactivity-time");
        if (maxInactiveTimeString != null) {
            try {
                this.userApplicationMaxInactivityTime = Long.parseLong(maxInactiveTimeString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (homeDir == null) {
            return;
        }
        int wildcardPos = homeDir.indexOf(42);
        if (wildcardPos < 0) {
            this.userDirPrefix = homeDir;
        } else if (wildcardPos == homeDir.length() - 1 && wildcardPos > 0) {
            this.userDirPrefix = homeDir.substring(0, homeDir.length() - 1);
        } else {
            this.userDirPrefix = homeDir.substring(0, wildcardPos);
            this.userDirSuffix = homeDir.substring(wildcardPos + 1, homeDir.length());
            if (this.userDirSuffix.endsWith("/") || this.userDirSuffix.endsWith(File.separator)) {
                this.userDirSuffix = this.userDirSuffix.substring(0, this.userDirSuffix.length() - 1);
            }
        }
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (!name.equals("web-site")) {
            throw new InstantiationException(this.getName() + " contained a " + name + " file, not a web-site file as expected");
        }
    }

    public long getUserApplicationMaxInactivityTime() {
        return this.userApplicationMaxInactivityTime;
    }

    public String getID() {
        if (this.getURL() == null) {
            return "";
        }
        return this.getURL().toString();
    }

    public boolean getLogRequestInfo() {
        return this.logRequestInfo;
    }

    public SSLConfig getSSLConfig() {
        if (null != this.sslConfig) {
            return this.sslConfig;
        }
        if (null != this.serverConfig) {
            return this.serverConfig.getSslConfig();
        }
        return null;
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println();
        this.writeXML(out, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXML(PrintWriter out, String indention) throws IOException {
        String string = "WriteXMLVersusInitializeStateSynchronizationLock";
        synchronized ("WriteXMLVersusInitializeStateSynchronizationLock") {
            out.print(indention + "<web-site " + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/web-site-10_0.xsd\" ");
            if (this.getAddress() != null && !this.getAddress().getHostAddress().equals("0.0.0.0")) {
                out.print(" host=\"" + XMLUtils.encode(this.getAddress().getHostName()) + "\"");
            }
            if (this.port != (this.secure ? 443 : 80) && this.port > 0) {
                out.print(" port=\"" + this.port + "\"");
            }
            if (this.secure) {
                out.print(" secure=\"true\"");
            }
            if (this.islandID >= 0) {
                out.print(" cluster-island=\"" + this.islandID + "\"");
            }
            if (this.requestMaxSize != 15000) {
                out.print(" max-request-size=\"" + this.requestMaxSize + "\"");
            }
            if (this.protocol != 0 && this.protocol != 1) {
                try {
                    out.print(" protocol=\"" + XMLHttpSiteConfig.getProtocolName(this.getProtocol()) + "\"");
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
            if (this.hostNameHeaders != null && !this.hostNameHeaders.isEmpty()) {
                out.print(" virtual-hosts=\"");
                for (int i = 0; i < this.hostNameHeaders.size(); ++i) {
                    if (i != 0) {
                        out.print(", ");
                    }
                    out.print(XMLUtils.encode(this.hostNameHeaders.get(i).toString()));
                }
                out.print("\"");
            }
            if (this.logRequestInfo) {
                out.print(" log-request-info=\"true\"");
            }
            if (this.getDisplayName() != null) {
                out.print(" display-name=\"" + XMLUtils.encode(this.getDisplayName()) + "\"");
            }
            if (this.getThreadPoolNm() != null) {
                out.print(" custom-thread-pool=\"" + XMLUtils.encode(this.getThreadPoolNm()) + "\"");
            }
            out.println(" schema-major-version=\"10\" schema-minor-version=\"0\" > ");
            if (this.getDescription() != null) {
                out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
            }
            if (this.posingAsHostname != null && this.posingAsPort > 0) {
                out.print(indention + "\t<frontend ");
                if (this.posingAsHostname != null) {
                    out.print(" host=\"" + XMLUtils.encode(this.posingAsHostname) + "\"");
                }
                if (this.posingAsPort > 0) {
                    out.print(" port=\"" + this.posingAsPort + "\"");
                }
                out.println(" />");
            }
            if (this.defaultApplication != null && (this.defaultApplication.getRoot() == null || this.defaultApplication.getRoot().equals("/"))) {
                this.defaultApplication.writeXML(out, indention + "\t");
            }
            if (this.applications != null) {
                XMLUtils.writeAll(this.applications, out, indention + "\t");
            }
            if (this.userDirPrefix != null) {
                out.write(indention + "\t<user-web-apps path=\"" + XMLUtils.encode(this.userDirPrefix) + "*");
                if (this.userDirSuffix != null) {
                    out.write(XMLUtils.encode(this.userDirSuffix));
                }
                out.write("\"");
                if (this.userApplicationMaxInactivityTime != 0L) {
                    out.write(" max-inactivity-time=\"" + this.userApplicationMaxInactivityTime + "\"");
                }
                out.println(" />");
            }
            if (this.requestLogPath != null) {
                if (this.requestLogger instanceof ODLRequestLogger) {
                    ((ODLRequestLogger)this.requestLogger).writeXML(out, indention);
                } else {
                    out.write(indention + "\t<access-log path=\"" + XMLUtils.encode(this.requestLogPath) + "\"");
                    if (this.requestLogFormat != null) {
                        out.write(" format=\"" + XMLUtils.encode(this.requestLogFormat) + "\"");
                    }
                    if (this.requestLogSuffix != null) {
                        out.write(" suffix=\"" + XMLUtils.encode(this.requestLogSuffix) + "\"");
                    }
                    if (this.requestLogSplitType != 0) {
                        out.write(" split=\"");
                        switch (this.requestLogSplitType) {
                            case 1: {
                                out.write("hour");
                                break;
                            }
                            case 2: {
                                out.write("day");
                                break;
                            }
                            case 3: {
                                out.write("week");
                                break;
                            }
                            case 4: {
                                out.write("month");
                            }
                        }
                        out.write("\"");
                    }
                    out.println(" />");
                }
            }
            if (this.sslConfig != null) {
                this.sslConfig.writeXML(out, "\t");
            }
            out.println(indention + "</web-site>");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected String getAssemblyDescriptorPath() {
        return "web-site.xml";
    }

    public String getDeploymentDescriptorPath() {
        return "web-site.xml";
    }

    protected String getDefaultDeploymentSubname() {
        return "config";
    }

    public void addApplication(HttpApplicationReference reference) {
        String referenceRoot = reference.getRoot();
        if (this.defaultApplication != null && referenceRoot.equals(this.defaultApplication.getRoot())) {
            reference.setDefault(true);
            this.defaultApplication = reference;
            if (!referenceRoot.equals("/")) {
                if (this.applications == null) {
                    this.applications = new Vector();
                }
                this.removeApplication(this.defaultApplication.getRoot());
                this.applications.add(reference);
            }
            return;
        }
        if (this.applications == null) {
            this.applications = new Vector();
        }
        int overloadIndex = -1;
        for (int i = 0; i < this.applications.size(); ++i) {
            HttpApplicationReference other = (HttpApplicationReference)this.applications.get(i);
            String otherRoot = other.getRoot();
            if (otherRoot.equals(referenceRoot)) {
                if (!other.getApplicationName().equals(reference.getApplicationName()) || !other.getHttpApplicationName().equals(reference.getHttpApplicationName())) {
                    System.out.println("WARNING: In web site '" + this.getDisplayName() + "', web application '" + reference.getHttpApplicationName() + "' in application '" + reference.getApplicationName() + "' has just replaced the binding for web application '" + other.getHttpApplicationName() + "' in application '" + other.getApplicationName() + "' for context root '" + other.getRoot() + "'.\n");
                }
                this.applications.set(i, reference);
                return;
            }
            if (overloadIndex != -1 || referenceRoot.indexOf(otherRoot) == -1) continue;
            overloadIndex = i;
        }
        if (overloadIndex != -1) {
            this.applications.add(overloadIndex, reference);
        } else {
            this.applications.add(reference);
        }
    }

    public boolean unBindApplication(String j2eeAppName) {
        try {
            boolean found = false;
            Iterator appIter = this.getApplications().iterator();
            HttpApplicationReference reference = null;
            while (appIter.hasNext()) {
                reference = (HttpApplicationReference)appIter.next();
                if (!j2eeAppName.equals(reference.getApplicationName())) continue;
                found = true;
                appIter.remove();
            }
            if (found && reference == this.defaultApplication || !found && this.defaultApplication.getApplicationName().equals(j2eeAppName)) {
                this.defaultApplication = new HttpApplicationReference("default", "defaultWebApp");
                if (found) {
                    this.defaultApplication.setRoot(reference.getRoot());
                    this.applications.add(this.defaultApplication);
                } else {
                    this.defaultApplication.setRoot("/");
                }
                this.defaultApplication.setDefault(true);
                this.defaultApplication.setPreload();
                found = true;
            }
            if (found && OC4JServer.getOPMNEnabled() && this.getProtocol() == 2) {
                OC4JMonitorThread.removeAppRoutingId(j2eeAppName);
            }
            return found;
        }
        catch (InstantiationException e) {
            m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
            return false;
        }
    }

    private ApplicationConfigReference getJ2EEAppConfigRef(String appName) {
        try {
            ApplicationConfigReference defAppConfigRef = this.serverConfig.getDefaultApplicationConfigReference();
            if (defAppConfigRef != null && defAppConfigRef.getName().equals(appName)) {
                return defAppConfigRef;
            }
            ApplicationConfigReference sysAppConfigRef = this.serverConfig.getSystemApplicationConfigReference();
            if (sysAppConfigRef != null && sysAppConfigRef.getName().equals(appName)) {
                return sysAppConfigRef;
            }
            List appConfigRefs = this.serverConfig.getApplicationConfigs();
            if (appConfigRefs != null) {
                ApplicationConfigReference appConfigRef = null;
                for (int i = 0; i < appConfigRefs.size(); ++i) {
                    appConfigRef = (ApplicationConfigReference)appConfigRefs.get(i);
                    if (!appConfigRef.getName().equals(appName)) continue;
                    return appConfigRef;
                }
            }
        }
        catch (InstantiationException e) {
            m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
        }
        return null;
    }

    public void setVirtualHosts(String value) {
        ArrayList<String> hosts = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, ", ");
        while (tokenizer.hasMoreTokens()) {
            hosts.add(tokenizer.nextToken().toLowerCase());
        }
        this.hostNameHeaders = hosts;
    }

    public void removeApplication(String path) {
        if (path.length() <= 1) {
            return;
        }
        if (this.applications == null) {
            return;
        }
        Iterator iterator = this.applications.iterator();
        while (iterator.hasNext()) {
            HttpApplicationReference reference = (HttpApplicationReference)iterator.next();
            if (!path.equals(reference.getRoot())) continue;
            iterator.remove();
        }
    }

    public int getIslandID() {
        return this.islandID;
    }

    public int getProtocol() {
        if (this.protocol == 0) {
            return 1;
        }
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = (byte)protocol;
    }

    public void setThreadPoolNm(String threadPoolNm) {
        this.threadPoolNm = threadPoolNm;
    }

    public String getThreadPoolNm() {
        return this.threadPoolNm;
    }

    public static int getProtocol(String name) throws InstantiationException {
        if (name.equalsIgnoreCase("http") || name.equalsIgnoreCase("https")) {
            return 1;
        }
        if (name.equalsIgnoreCase("ajp") || name.equalsIgnoreCase("ajp13") || name.equalsIgnoreCase("ajps")) {
            return 2;
        }
        if (name.equalsIgnoreCase("jni")) {
            return 3;
        }
        throw new InstantiationException("Invalid protocol name: " + name);
    }

    public static String getProtocolName(int protocol) throws InstantiationException {
        switch (protocol) {
            case 1: {
                return OC4JServiceInfo.HTTP;
            }
            case 2: {
                return OC4JServiceInfo.AJP13;
            }
            case 3: {
                return "jni";
            }
        }
        throw new InstantiationException("Unknown protocol number: " + protocol);
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setIslandID(int id) {
        this._setIslandID(id);
    }

    public int getRequestMaxSize() {
        return this.requestMaxSize;
    }

    public void setRequestMaxSize(int size) {
        this.requestMaxSize = size;
    }

    public void setSSLConfig(SSLConfig p_sslCfg) {
        this.sslConfig = p_sslCfg;
    }

    private void _setIslandID(int newId) {
        if (HTTPProperties.getOc4JClusterIslandIDClassic()) {
            this.islandID = newId;
            return;
        }
        String prop = HTTPProperties.getIsland();
        if (prop != null) {
            try {
                this.islandID = Integer.parseInt(prop);
            }
            catch (NumberFormatException e) {
                this.islandID = 0;
            }
        } else {
            this.islandID = newId;
        }
    }

    public String getRequestLogPath() {
        return this.requestLogPath;
    }

    public String getRequestLogFormat() {
        return this.requestLogFormat;
    }

    public String getRequestLogSplit() {
        switch (this.requestLogSplitType) {
            case 1: {
                return "hour";
            }
            case 2: {
                return "day";
            }
            case 3: {
                return "week";
            }
            case 4: {
                return "month";
            }
        }
        return null;
    }

    public String getRequestLogSuffix() {
        return this.requestLogSuffix;
    }

    public void setAccessLog(WebSiteAccessLog logger) throws InstantiationException {
        this.requestLogPath = logger.getPath().trim();
        this.requestLogFormat = logger.getFormat();
        this.requestLogSuffix = logger.getSuffix();
        String splitString = logger.getSplit();
        if (splitString == null) {
            this.requestLogSplitType = 0;
        } else if (splitString.equalsIgnoreCase("month")) {
            this.requestLogSplitType = 4;
        } else if (splitString.equalsIgnoreCase("week")) {
            this.requestLogSplitType = 3;
        } else if (splitString.equalsIgnoreCase("day")) {
            this.requestLogSplitType = 2;
        } else if (splitString.equalsIgnoreCase("hour")) {
            this.requestLogSplitType = 1;
        }
        URL url = null;
        try {
            url = this.determineMultiInstancePath();
            if (this.requestLogSplitType != 0 || this.requestLogFormat != null && !this.requestLogFormat.equals("$ip - - [$time] '$request' $status $size")) {
                if (!url.getProtocol().equals("file")) {
                    throw new InstantiationException("File URL needed for access log");
                }
                this.requestLogger = new FormattedRequestLogger(url.getFile(), this.requestLogSplitType, this.requestLogFormat, false, this.requestLogSuffix);
            } else {
                OutputStream stream = url.getProtocol().equalsIgnoreCase("file") ? new FileOutputStream(url.getFile(), true) : url.openConnection().getOutputStream();
                this.requestLogger = new StandardRequestLogger(stream, false);
            }
        }
        catch (Exception e) {
            if (e instanceof InstantiationException) {
                throw (InstantiationException)e;
            }
            throw new InstantiationException("Could not start access logfile for " + this.getName() + "(" + url + ")");
        }
    }

    public void setODLAccessLog(WebSiteODLAccessLog logger) throws InstantiationException {
        this.requestLogPath = logger.getPath();
        try {
            URL url = this.determineMultiInstancePath();
            this.requestLogger = new ODLRequestLogger(this.requestLogPath, url.getPath(), logger.getMaxFileSize(), logger.getMaxDirectorySize(), null);
        }
        catch (Exception e) {
            if (e instanceof InstantiationException) {
                throw (InstantiationException)e;
            }
            throw new InstantiationException("Could not start access logfile for " + this.getName() + "(" + this.requestLogPath + ")");
        }
    }

    public String getShortName() {
        String name = this.getName();
        if (name.endsWith(".xml")) {
            int idx1 = name.lastIndexOf(47);
            int idx2 = name.lastIndexOf(46);
            return name.substring(idx1 + 1, idx2);
        }
        return name;
    }
}

