/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ParameterMap
implements Serializable {
    private static final int INITIAL_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private boolean committed;
    private boolean tableBorrowed;
    private int size;
    private int threshold;
    private ArrayEntry[] table;
    private ParameterMap previous;
    private Map cachedMap;
    private static final int KEY_ARRAY = 0;
    private static final int VALUE_ARRAY = 1;
    private static final int ENTRY_ARRAY = 2;

    public ParameterMap(ParameterMap previous) {
        this.reset(previous);
    }

    public ParameterMap reset(ParameterMap previous) {
        this.previous = previous;
        this.committed = false;
        this.cachedMap = null;
        if (this.tableBorrowed) {
            this.size = 0;
            this.table = null;
            this.tableBorrowed = false;
        } else if (this.table != null) {
            this.clear();
        }
        return this;
    }

    public void add(String key, String value) {
        if (this.committed) {
            throw new IllegalStateException("Map is committed.");
        }
        if (this.table == null) {
            this.threshold = 16;
            this.table = new ArrayEntry[16];
        }
        int hash = ParameterMap.hash(key);
        int i = ParameterMap.indexFor(hash, this.table.length);
        ArrayEntry a = this.table[i];
        while (a != null) {
            if (a.hash == hash && ParameterMap.eq(key, a.key)) {
                a.add(value);
                return;
            }
            a = a.next;
        }
        this.table[i] = new ArrayEntry(key, hash, value, this.table[i]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    public void add(String key, String[] value) {
        if (this.committed) {
            throw new IllegalStateException("Map is committed.");
        }
        if (this.table == null) {
            this.threshold = 16;
            this.table = new ArrayEntry[16];
        }
        int hash = ParameterMap.hash(key);
        int i = ParameterMap.indexFor(hash, this.table.length);
        ArrayEntry a = this.table[i];
        while (a != null) {
            if (a.hash == hash && ParameterMap.eq(key, a.key)) {
                a.add(value);
                return;
            }
            a = a.next;
        }
        this.table[i] = new ArrayEntry(key, hash, value, this.table[i], false);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    public String getFirstValue(Object key) {
        String[] value = this.getValue(key);
        if (value != null) {
            return value[0];
        }
        return null;
    }

    public String[] getValue(Object key) {
        ArrayEntry array;
        if (!this.committed) {
            this.commit();
        }
        if (this.size > 0 && (array = this.find(key)) != null) {
            return array.getValueAsArray();
        }
        return null;
    }

    public Enumeration getKeys() {
        if (!this.committed) {
            this.commit();
        }
        if (this.size > 0) {
            return new ArrayEntryIterator();
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Map getUnmodifiableMap() {
        if (!this.committed) {
            this.commit();
        }
        if (this.cachedMap == null) {
            this.cachedMap = this.size > 0 ? new UnmodifiableMap(this) : Collections.EMPTY_MAP;
        }
        return this.cachedMap;
    }

    private void clear() {
        if (this.size > 0) {
            ArrayEntry[] tab = this.table;
            for (int i = 0; i < tab.length; ++i) {
                tab[i] = null;
            }
            this.size = 0;
        }
    }

    private void commit() {
        if (this.previous != null) {
            if (!this.previous.committed) {
                this.previous.commit();
            }
            while (this.previous != null && this.previous.size == 0) {
                this.previous = this.previous.previous;
            }
            if (this.previous != null) {
                if (this.size > 0) {
                    ArrayEntry[] entries = this.previous.table;
                    for (int i = 0; i < entries.length; ++i) {
                        if (entries[i] == null) continue;
                        ArrayEntry entry = entries[i];
                        while (entry != null) {
                            if (!this.contains(entry)) {
                                this.addAggregate(entry);
                            }
                            entry = entry.next;
                        }
                    }
                } else {
                    this.size = this.previous.size;
                    this.table = this.previous.table;
                    this.threshold = this.previous.threshold;
                    this.previous = this.previous.previous;
                    this.tableBorrowed = true;
                }
            }
        }
        this.committed = true;
    }

    private void addAggregate(ArrayEntry entry) {
        int hash = entry.hash;
        int i = ParameterMap.indexFor(hash, this.table.length);
        this.table[i] = new ArrayEntry(entry.key, hash, entry.getValueAsArray(), this.table[i], true);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private ArrayEntry find(Object key) {
        int hash = ParameterMap.hash(key);
        int i = ParameterMap.indexFor(hash, this.table.length);
        ArrayEntry a = this.table[i];
        while (a != null) {
            if (a.hash == hash && ParameterMap.eq(key, a.key)) {
                return a;
            }
            a = a.next;
        }
        return a;
    }

    private boolean contains(ArrayEntry entry) {
        int hash = entry.hash;
        int i = ParameterMap.indexFor(hash, this.table.length);
        ArrayEntry a = this.table[i];
        while (a != null) {
            if (a.hash == hash && ParameterMap.eq(entry.key, a.key)) {
                return true;
            }
            a = a.next;
        }
        return false;
    }

    private void resize(int newCapacity) {
        ArrayEntry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        ArrayEntry[] newTable = new ArrayEntry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * 0.75f);
    }

    private void transfer(ArrayEntry[] newTable) {
        ArrayEntry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            ArrayEntry next;
            ArrayEntry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = ParameterMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    private static boolean arraysEqual(String[] one, String[] two) {
        if (one.length == two.length) {
            for (int i = 0; i < one.length; ++i) {
                if (one[i].equals(two[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int arrayHash(String[] array) {
        int hash = array.length;
        for (int i = 0; i < array.length; ++i) {
            hash ^= array[i].hashCode();
        }
        return hash;
    }

    private static void appendArray(String[] array, StringBuffer buffer) {
        buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(array[i]);
        }
        buffer.append('}');
    }

    private static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    private int size() {
        return this.size;
    }

    private ArrayEntryIterator iterator() {
        return new ArrayEntryIterator();
    }

    private boolean containsKey(Object key) {
        int hash = ParameterMap.hash(key);
        int i = ParameterMap.indexFor(hash, this.table.length);
        ArrayEntry a = this.table[i];
        while (a != null) {
            if (a.hash == hash && ParameterMap.eq(key, a.key)) {
                return true;
            }
            a = a.next;
        }
        return false;
    }

    private boolean containsValue(Object value) {
        if (value == null || !(value instanceof String[])) {
            return false;
        }
        String[] array = (String[])value;
        ArrayEntry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            ArrayEntry a = tab[i];
            while (a != null) {
                if (a.contains(array)) {
                    return true;
                }
                a = a.next;
            }
        }
        return false;
    }

    private Object[] toArray(int type) {
        Object[] result = new Object[this.size];
        return this.fillArray(result, type);
    }

    private Object[] toArray(Object[] array, int type) {
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        } else if (array.length > this.size) {
            array[this.size] = null;
        }
        return this.fillArray(array, type);
    }

    private Object[] fillArray(Object[] array, int type) {
        ArrayEntry[] tab = this.table;
        int index = 0;
        for (int i = 0; i < tab.length; ++i) {
            ArrayEntry a = tab[i];
            while (a != null) {
                switch (type) {
                    case 0: {
                        array[index++] = a.getKey();
                        break;
                    }
                    case 1: {
                        array[index++] = (String[])a.getValueAsArray().clone();
                        break;
                    }
                    case 2: {
                        array[index++] = a;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("type should be KEY_ARRAY || VALUE_ARRAY || ENTRY_ARRAY");
                    }
                }
                a = a.next;
            }
        }
        return array;
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private final ParameterMap map;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        UnmodifiableMap(ParameterMap map) {
            this.map = map;
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.size() == 0;
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        public boolean containsValue(Object val) {
            return this.map.containsValue(val);
        }

        public Object get(Object key) {
            String[] values = this.map.getValue(key);
            if (values == null) {
                return null;
            }
            return values.clone();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = new UnmodifiableSet(this.map);
            }
            return this.keySet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet(this.map);
            }
            return this.entrySet;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new UnmodifiableCollection(this.map);
            }
            return this.values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            Map t = (Map)o;
            if (t.size() != this.size()) {
                return false;
            }
            try {
                ArrayEntryIterator i = this.map.iterator();
                while (i.hasNext()) {
                    ArrayEntry e = i.nextEntry();
                    Object key = e.getKey();
                    String[] value = e.getValueAsArray();
                    if (value == null) {
                        if (t.get(key) == null && t.containsKey(key)) continue;
                        return false;
                    }
                    Object tValue = t.get(key);
                    if (tValue == null || !(tValue instanceof String[])) {
                        return false;
                    }
                    String[] otherValue = (String[])tValue;
                    if (ParameterMap.arraysEqual(value, otherValue)) continue;
                    return false;
                }
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            ArrayEntryIterator i = this.map.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                ArrayEntry e = i.nextEntry();
                buf.append(e.key);
                buf.append('=');
                ParameterMap.appendArray(e.getValueAsArray(), buf);
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("}");
            return buf.toString();
        }
    }

    static class UnmodifiableEntrySet
    extends UnmodifiableSet {
        UnmodifiableEntrySet(ParameterMap map) {
            super(map);
        }

        public Object[] toArray() {
            return this.map.toArray(2);
        }

        public Object[] toArray(Object[] a) {
            return this.map.toArray(a, 2);
        }

        public Iterator iterator() {
            return new Iterator(this){
                ArrayEntryIterator i;
                private final /* synthetic */ UnmodifiableEntrySet this$0;
                {
                    this.this$0 = this$0;
                    this.i = ParameterMap.access$1500(this.this$0.map);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.nextEntry();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object v = entry.getValue();
            if (!(v instanceof String[])) {
                return false;
            }
            ArrayEntry array = this.map.find(entry.getKey());
            if (array == null) {
                return false;
            }
            String[] value = (String[])v;
            return array.contains(value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            ArrayEntryIterator i = this.map.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                ArrayEntry e = i.nextEntry();
                buf.append(e);
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set {
        UnmodifiableSet(ParameterMap map) {
            super(map);
        }

        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        public Object[] toArray() {
            return this.map.toArray(0);
        }

        public Object[] toArray(Object[] a) {
            return this.map.toArray(a, 0);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        public int hashCode() {
            int h = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        public Iterator iterator() {
            return new Iterator(this){
                ArrayEntryIterator i;
                private final /* synthetic */ UnmodifiableSet this$0;
                {
                    this.this$0 = this$0;
                    this.i = ParameterMap.access$1500(this.this$0.map);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.nextKey();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            ArrayEntryIterator i = this.map.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                String o = i.nextKey();
                buf.append((Object)o);
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    private static class UnmodifiableCollection
    implements Collection,
    Serializable {
        protected final ParameterMap map;

        UnmodifiableCollection(ParameterMap map) {
            this.map = map;
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.size() == 0;
        }

        public boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        public Object[] toArray() {
            return this.map.toArray(1);
        }

        public Object[] toArray(Object[] a) {
            return this.map.toArray(a, 1);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            ArrayEntryIterator i = this.map.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                String[] o = i.nextValue();
                ParameterMap.appendArray(o, buf);
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("]");
            return buf.toString();
        }

        public Iterator iterator() {
            return new Iterator(this){
                ArrayEntryIterator i;
                private final /* synthetic */ UnmodifiableCollection this$0;
                {
                    this.this$0 = this$0;
                    this.i = ParameterMap.access$1500(this.this$0.map);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.nextValue();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection coll) {
            Iterator e = coll.iterator();
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class ArrayEntryIterator
    implements Enumeration,
    Serializable {
        private ArrayEntry next;
        private int slot;

        public ArrayEntryIterator() {
            ArrayEntry[] t = ParameterMap.this.table;
            int i = t.length;
            ArrayEntry n = null;
            if (ParameterMap.this.size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.slot = i;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public ArrayEntry nextEntry() {
            ArrayEntry a = this.next;
            if (a == null) {
                throw new NoSuchElementException();
            }
            ArrayEntry n = a.next;
            ArrayEntry[] t = ParameterMap.this.table;
            int i = this.slot;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.slot = i;
            this.next = n;
            return a;
        }

        public String nextKey() {
            return this.nextEntry().key;
        }

        public String[] nextValue() {
            return (String[])this.nextEntry().getValueAsArray().clone();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.nextKey();
        }
    }

    private class ArrayEntry
    implements Map.Entry,
    Serializable {
        private static final int INITIAL_ARRAY_SIZE = 8;
        private static final int ARRAY_GROWTH_FACTOR = 2;
        private String key;
        private int hash;
        private ArrayEntry next;
        private String value;
        private int arraySize;
        private String[] array;
        private String[] aggregateArray;

        public ArrayEntry(String key, int hash, String value, ArrayEntry next) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }

        public ArrayEntry(String key, int hash, String[] value, ArrayEntry next, boolean isAggregate) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            if (isAggregate) {
                this.aggregateArray = value;
            } else {
                this.array = value;
                this.arraySize = value.length;
            }
        }

        public String getKeyAsString() {
            return this.key;
        }

        public void add(String value) {
            if (this.array == null) {
                this.array = new String[8];
                this.array[0] = this.value;
                this.array[1] = value;
                this.arraySize = 2;
                this.value = null;
            } else {
                if (this.arraySize == this.array.length) {
                    String[] newArray = new String[this.arraySize * 2];
                    System.arraycopy(this.array, 0, newArray, 0, this.arraySize);
                    this.array = newArray;
                }
                this.array[this.arraySize++] = value;
            }
        }

        public void add(String[] value) {
            int valueLength = value.length;
            if (this.array == null) {
                int newSize = valueLength < 8 ? 8 : valueLength;
                this.array = new String[newSize];
                this.array[0] = this.value;
                System.arraycopy(value, 0, this.array, 1, valueLength);
                this.arraySize = valueLength + 1;
                this.value = null;
            } else {
                int remainder = this.array.length - this.arraySize;
                if (remainder < valueLength) {
                    int newSize = this.array.length * 2 + valueLength;
                    String[] newArray = new String[newSize];
                    System.arraycopy(this.array, 0, newArray, 0, this.arraySize);
                    this.array = newArray;
                }
                System.arraycopy(value, 0, this.array, this.arraySize, valueLength);
                this.arraySize += valueLength;
            }
        }

        public String[] getValueAsArray() {
            if (this.aggregateArray == null) {
                if (ParameterMap.this.previous != null) {
                    ArrayEntry entry = ParameterMap.this.previous.find(this.key);
                    if (entry != null) {
                        this.initAggregate(entry.getValueAsArray());
                    } else {
                        this.initAggregate();
                    }
                } else {
                    this.initAggregate();
                }
            }
            return this.aggregateArray;
        }

        private void initAggregate() {
            if (this.array == null) {
                this.aggregateArray = new String[]{this.value};
            } else if (this.arraySize == this.array.length) {
                this.aggregateArray = this.array;
            } else {
                String[] newArray = new String[this.arraySize];
                System.arraycopy(this.array, 0, newArray, 0, this.arraySize);
                this.aggregateArray = newArray;
            }
        }

        private void initAggregate(String[] previousArray) {
            String[] aggregate;
            int size = previousArray.length;
            if (this.value != null) {
                aggregate = new String[size + 1];
                aggregate[0] = this.value;
                System.arraycopy(previousArray, 0, aggregate, 1, size);
            } else {
                aggregate = new String[size + this.arraySize];
                System.arraycopy(this.array, 0, aggregate, 0, this.arraySize);
                System.arraycopy(previousArray, 0, aggregate, this.arraySize, size);
            }
            this.aggregateArray = aggregate;
        }

        public boolean contains(String[] value) {
            return ParameterMap.arraysEqual(this.getValueAsArray(), value);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.getValueAsArray().clone();
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.key.hashCode() ^ ParameterMap.arrayHash(this.getValueAsArray());
        }

        public boolean equals(Object o) {
            if (!(o instanceof ArrayEntry)) {
                return false;
            }
            ArrayEntry t = (ArrayEntry)o;
            return ParameterMap.eq(this.key, t.getKey()) && ParameterMap.arraysEqual(this.getValueAsArray(), t.getValueAsArray());
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getKey());
            buf.append('=');
            ParameterMap.appendArray(this.getValueAsArray(), buf);
            return buf.toString();
        }
    }
}

