/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.net.IONetworkConnection;
import com.evermind.net.NetworkConnection;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HttpTunnelProxyServletIOStream;
import com.evermind.util.TransientAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.security.jazn.oc4j.JAZNServletRequest;

public abstract class HttpTunnelProxyServlet
extends HttpServlet {
    public static final String TRANSIENT_ATTRIBUTE = "transient attribute";
    private static final String STUFF = "stuff";

    private void transferInboundData(HttpTunnelProxyServletIOStream pio, InputStream is, int sz) throws IOException {
        int bread;
        byte[] b = new byte[2048];
        OutputStream os = pio.getHttpEndOut();
        do {
            if ((bread = is.read(b)) < 0) {
                throw new IOException("Tunneling Data Corrupted");
            }
            os.write(b, 0, bread);
        } while ((sz -= bread) > 0);
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest genericRequest, HttpServletResponse response) throws IOException {
        EvermindHttpServletRequest request = genericRequest instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)genericRequest : (EvermindHttpServletRequest)((JAZNServletRequest)genericRequest).getRequest();
        request.socket.setSoTimeout(0);
        request.getInputStream();
        int bodySz = genericRequest.getContentLength();
        try {
            HttpTunnelProxyServletIOStream pio;
            response.setHeader("Oracle-Tunnel-Mode", "normal");
            response.setHeader("Dummy", "normal");
            response.setHeader("Content-type", "text/plain");
            HttpSession hsession = genericRequest.getSession();
            boolean _special = false;
            if (hsession.isNew()) {
                pio = this.connect(request, false);
            } else {
                TransientAttribute ta = (TransientAttribute)hsession.getAttribute(TRANSIENT_ATTRIBUTE);
                pio = (HttpTunnelProxyServletIOStream)ta.getAttr();
                if (pio == null) {
                    pio = this.connect(request, true);
                    _special = true;
                }
            }
            if (!_special) {
                this.transferInboundData(pio, (InputStream)request.getInputStream(), bodySz);
            }
            byte[] bs = pio.getHttpEndInData();
            response.setContentLength(bs.length);
            response.getOutputStream().write(bs);
            response.flushBuffer();
        }
        finally {
            request.servletIn.contentLength = 0L;
        }
    }

    private HttpTunnelProxyServletIOStream connect(EvermindHttpServletRequest request, boolean special) throws IOException {
        HttpTunnelProxyServletIOStream pio = new HttpTunnelProxyServletIOStream();
        TransientAttribute ta = new TransientAttribute();
        ta.setAttr(pio);
        request.getSession().setAttribute(TRANSIENT_ATTRIBUTE, (Object)ta);
        if (special) {
            this.transferInboundData(pio, (InputStream)request.getInputStream(), request.getContentLength());
        }
        this.connect(new IONetworkConnection(pio.getRmiEndIn(), pio.getRmiEndOut(), request.socket.getInetAddress(), request.socket.getPort()), request.getSession(), special);
        return pio;
    }

    protected abstract void connect(NetworkConnection var1, HttpSession var2, boolean var3) throws IOException;

    static class MyOutputStream
    extends OutputStream {
        HttpServletResponse resp;
        OutputStream os;

        MyOutputStream(HttpServletResponse resp) throws IOException {
            this.resp = resp;
            this.os = resp.getOutputStream();
        }

        public void close() throws IOException {
            this.os.close();
        }

        public void write(byte[] b, int off, int length) throws IOException {
            this.os.write(b, off, length);
        }

        public void write(int b) throws IOException {
            this.os.write(b);
        }

        public void flush() throws IOException {
            this.resp.flushBuffer();
        }
    }
}

