/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import EDU.oswego.cs.dl.util.concurrent.CountDown;
import com.evermind.net.NetUtils;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.Lock;
import com.evermind.server.OC4JServiceInfo;
import com.evermind.server.Refreshable;
import com.evermind.server.Server;
import com.evermind.server.XMLApplicationServerConfig;
import com.evermind.server.XMLServerConfig;
import com.evermind.server.http.AJPConnectionListener;
import com.evermind.server.http.EvermindJSPFactory;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.HttpApplicationConfigContext;
import com.evermind.server.http.HttpApplicationDestroyer;
import com.evermind.server.http.HttpApplicationReference;
import com.evermind.server.http.HttpConnectionListener;
import com.evermind.server.http.HttpMessages;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.HttpSiteConfig;
import com.evermind.server.http.ServletInstanceInfo;
import com.evermind.server.http.SessionTimeoutTask;
import com.evermind.server.http.TagLibraryArchive;
import com.evermind.server.http.TagLibraryStorage;
import com.evermind.server.http.XMLHttpSiteConfig;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.ByteString;
import com.evermind.util.ConfigUtils;
import com.evermind.util.TaskManager;
import com.evermind.xml.XMLConfig;
import com.evermind.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.servlet.jsp.JspFactory;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.config.HttpServerConfig;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEAJPWebSiteCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEWebSiteCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEAJPWebSite;
import oracle.oc4j.admin.management.mbeans.J2EEWebSite;
import oracle.oc4j.admin.management.shared.WebSiteAccessLog;

public class HttpServer
extends Server
implements Refreshable {
    protected HttpServerConfig config;
    protected Map sharedApplications;
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final int MAJOR_SERVLET_VERSION = 2;
    public static final int MINOR_SERVLET_VERSION = 4;
    protected ApplicationServer server;
    protected SessionTimeoutTask sessionTimeoutTask;
    byte[] maxConnectionsRedirectReply;
    int maxConnections = 1000000;
    public long hitsLastHourCleared;
    public long hitsLastHourClearedPrevious = this.hitsLastHourCleared = System.currentTimeMillis();
    public long hitsLastMinuteCleared = this.hitsLastHourCleared;
    public long hitsLastMinuteClearedPrevious = this.hitsLastHourCleared;
    int queueLength = 0;
    int waitingHandlers = 0;
    int runningHandlers = 0;
    public Object handlerLock = new Object();
    public Object dispatcherLock = new Object();
    Socket[] queue = new Socket[1024];
    HttpSite[][] queueSites = new HttpSite[1024][];
    int activeSockets = 0;
    ThreadGroup threadGroup;
    private TagLibraryStorage tagLibraryStorage;
    protected PrintWriter requestWriter;
    List sites = new ArrayList();
    List sitesInProgress;
    List siteConfigs = new ArrayList();
    List listeners = new ArrayList();
    private final Map sharedServlets = new TreeMap();
    private static String[] statusCodeDescription;
    private static byte[][] statusCodeDescriptionByteArray;
    private static Logger m_traceLogger;
    private static final String DEFAULT_ISLAND_MULTICAST_GROUP = "230.230.0.2";
    private InstantiationException hasChangedException;

    public HttpServer(ApplicationServer server) {
        this.server = server;
        this.threadGroup = Thread.currentThread().getThreadGroup();
    }

    public void setConfig(HttpServerConfig config) throws InstantiationException {
        super.setConfig(config);
        this.config = config;
        this.maxConnections = config.getConnectionLimit();
        String maxConnectionsRedirectString = config.getConnectionLimitRedirectURL();
        this.maxConnectionsRedirectReply = (byte[])(maxConnectionsRedirectString != null ? ("HTTP/1.1 302 Moved Temporarily\r\nLocation: " + maxConnectionsRedirectString + "\r\n\r\n" + "<HTML><HEAD><TITLE>Redirect to " + maxConnectionsRedirectString + "</TITLE></HEAD><BODY>" + "<A HREF=\"" + maxConnectionsRedirectString + "\">" + maxConnectionsRedirectString + "</A></BODY></HTML>").getBytes() : null);
        this.setSites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSites() throws InstantiationException {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpServer httpServer = this;
            synchronized (httpServer) {
                HttpConnectionListener listener;
                HttpConnectionListener listener2;
                InetAddress address;
                int i;
                this.server.getTaskManager().removeTask(this.sessionTimeoutTask);
                List oldSiteConfigs = this.siteConfigs;
                this.siteConfigs = new ArrayList(this.config.getSiteConfigs());
                ArrayList sitesToRemove = new ArrayList(oldSiteConfigs);
                sitesToRemove.removeAll(this.siteConfigs);
                ArrayList sitesToAdd = new ArrayList(this.siteConfigs);
                sitesToAdd.removeAll(oldSiteConfigs);
                Iterator iterator = sitesToRemove.iterator();
                HashSet<Integer> bindToAllPorts = new HashSet<Integer>();
                for (i = 0; i < this.siteConfigs.size(); ++i) {
                    HttpSiteConfig config = (HttpSiteConfig)this.siteConfigs.get(i);
                    if (config.getProtocol() != 1 || !config.getAddress().equals(NetUtils.ZERO_ADDRESS)) continue;
                    bindToAllPorts.add(new Integer(config.getPort()));
                }
                while (iterator.hasNext()) {
                    HttpSiteConfig config = (HttpSiteConfig)iterator.next();
                    if (config.getProtocol() != 1) continue;
                    address = config.getAddress();
                    if (bindToAllPorts.contains(new Integer(config.getPort()))) {
                        address = NetUtils.ZERO_ADDRESS;
                    }
                    listener2 = this.getListener(address, config);
                    listener2.remove(config);
                    this.removeJ2EEWebSiteMBean(this.getWebSiteName((XMLHttpSiteConfig)config));
                }
                for (i = 0; i < this.listeners.size(); ++i) {
                    listener = (HttpConnectionListener)this.listeners.get(i);
                    if (!listener.address.equals(NetUtils.ZERO_ADDRESS) || bindToAllPorts.contains(new Integer(listener.port)) || listener instanceof AJPConnectionListener) continue;
                    HttpSite[] removedSites = listener.sites;
                    if (this.sites != null) {
                        for (int x = 0; x < removedSites.length; ++x) {
                            removedSites[x].address = removedSites[x].particularAddress;
                            removedSites[x].particularAddress = null;
                            HttpSiteConfig config = removedSites[x].config;
                            HttpConnectionListener addListener = this.getListener(config.getAddress(), config);
                            addListener.add(removedSites[x]);
                        }
                    }
                    this.listeners.remove(listener);
                    listener.destroy();
                }
                iterator = sitesToAdd.iterator();
                while (iterator.hasNext()) {
                    HttpSiteConfig config = (HttpSiteConfig)iterator.next();
                    address = config.getAddress();
                    if (bindToAllPorts.contains(new Integer(config.getPort()))) {
                        address = NetUtils.ZERO_ADDRESS;
                    }
                    listener2 = this.getListener(address, config);
                    HttpMessages.infoListenerInitialized(listener2.getPort());
                    HttpSite site = new HttpSite(this);
                    try {
                        site.setConfig(config);
                        if (!config.getAddress().equals(address)) {
                            site.address = address;
                            site.particularAddress = config.getAddress();
                        }
                        listener2.add(site);
                        this.addJ2EEWebSiteMBean(site, this.getWebSiteName((XMLHttpSiteConfig)config));
                    }
                    catch (InstantiationException e) {
                        int idx = this.server.getConfig().getDefaultWebSiteIndex();
                        HttpSiteConfig defaultWebSiteConfig = (HttpSiteConfig)this.siteConfigs.get(idx);
                        this.siteConfigs.remove(config);
                        iterator.remove();
                        if (site.getConfig() == defaultWebSiteConfig) {
                            throw e;
                        }
                        HttpMessages.internalErrorWhileTryingToInstantiateSite(site.getdisplayName(), config.getName(), e);
                    }
                }
                for (i = 0; i < this.listeners.size(); ++i) {
                    listener = (HttpConnectionListener)this.listeners.get(i);
                    if (listener.sites != null && listener.sites.length != 0) continue;
                    this.listeners.remove(listener);
                    listener.destroy();
                }
                this.sites = this.getSites();
                this.sessionTimeoutTask = new SessionTimeoutTask(this, this.sites);
                this.server.getTaskManager().addTask(this.sessionTimeoutTask);
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public List getHttpApplicationsOf(Application application) {
        ArrayList httpApplications = new ArrayList();
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                HttpConnectionListener listener = (HttpConnectionListener)iterator.next();
                HttpSite[] sites = listener.sites;
                if (sites == null) continue;
                for (int i = 0; i < sites.length; ++i) {
                    HttpSite site = sites[i];
                    if (site == null) continue;
                    site.addHttpApplicationsOf(application, httpApplications);
                }
            }
        }
        return httpApplications;
    }

    public void forceCheckForUpdates() throws InstantiationException {
    }

    public List getSites() {
        ArrayList<HttpSite> sites = new ArrayList<HttpSite>();
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                HttpConnectionListener listener = (HttpConnectionListener)iterator.next();
                if (listener.sites == null) continue;
                sites.addAll(Arrays.asList(listener.sites));
            }
        }
        return sites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletInstanceInfo getSharedServlet(ByteString name) {
        Map map = this.sharedServlets;
        synchronized (map) {
            return (ServletInstanceInfo)this.sharedServlets.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSharedServlet(ByteString name, ServletInstanceInfo info) {
        Map map = this.sharedServlets;
        synchronized (map) {
            this.sharedServlets.put(name, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSharedServlet(ByteString name) {
        Map map = this.sharedServlets;
        synchronized (map) {
            this.sharedServlets.remove(name);
        }
    }

    public HttpSite getSite(String name) {
        for (int i = 0; i < this.sites.size(); ++i) {
            if (!((HttpSite)this.sites.get(i)).getName().equals(name)) continue;
            return (HttpSite)this.sites.get(i);
        }
        return null;
    }

    public void start() {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public HttpConnectionListener getListener(InetAddress address, HttpSiteConfig site) throws InstantiationException {
        destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        var4_4 = this;
        // MONITORENTER : var4_4
        protocol = site.getProtocol();
        for (i = 0; i < this.listeners.size(); ++i) {
            listener = (HttpConnectionListener)this.listeners.get(i);
            if (protocol != 2) ** break block15
            if (!(listener instanceof AJPConnectionListener)) continue;
            var8_11 = listener;
            // MONITOREXIT : var4_4
            destroyLock.unlock();
            return var8_11;
        }
        {
            catch (Throwable var10_14) {
                destroyLock.unlock();
                throw var10_14;
            }
        }
        {
            if (!listener.address.equals(address) || listener.port != site.getPort()) continue;
            if (listener.isSecure() != site.isSecure()) {
                throw new IllegalArgumentException("Mixing secure and non-secure sites on the same ip + port");
            }
            var8_12 = listener;
            // MONITOREXIT : var4_4
            destroyLock.unlock();
            return var8_12;
        }
        try {
            listener = protocol == 2 ? this.getAJPConnectionListener(address, site) : new HttpConnectionListener(this, address, site);
            this.listeners.add(listener);
            this.server.getThreadPool().launch(listener);
            listener = listener;
            // MONITOREXIT : var4_4
            destroyLock.unlock();
            return listener;
        }
        catch (BindException be) {
            hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
                throw new InstantiationException(new File(site.getName()).getName() + ", " + hostname + ":" + site.getPort() + ", error: " + be.getMessage());
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
            throw new InstantiationException(new File(site.getName()).getName() + ", " + hostname + ":" + site.getPort() + ", error: " + be.getMessage());
            catch (IOException e) {
                iae = new InstantiationException(e.getMessage());
                iae.initCause(e);
                throw iae;
            }
        }
    }

    private HttpConnectionListener getAJPConnectionListener(InetAddress address, HttpSiteConfig config) throws IOException, InstantiationException {
        return new AJPConnectionListener(this, address, config);
    }

    public static void parseServletProperties(Properties properties) {
        String base = properties.getProperty("properties.directory");
        if (base != null) {
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String key = (String)entry.getKey();
                if (!key.endsWith(".relativeInitArgs")) continue;
                String newValue = ConfigUtils.canonicalizeEntries(base, (String)entry.getValue(), true);
                properties.put(key, newValue);
            }
        }
    }

    public ApplicationServer getApplicationServer() {
        return this.server;
    }

    public void updateSites() throws InstantiationException {
        this.setSites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String reason) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().writeLock();
        destroyLock.lock();
        try {
            HttpServer httpServer = this;
            synchronized (httpServer) {
                try {
                    Iterator iterator = this.listeners.iterator();
                    while (iterator.hasNext()) {
                        HttpConnectionListener listener = (HttpConnectionListener)iterator.next();
                        iterator.remove();
                        listener.destroy();
                    }
                    iterator = this.sites.iterator();
                    while (iterator.hasNext()) {
                        HttpSite site = (HttpSite)iterator.next();
                        site.destroy(false);
                    }
                    this.sites.clear();
                    EvermindJSPFactory.resetPageContextsPool();
                    JspFactory.setDefaultFactory(null);
                }
                catch (Throwable t) {
                    m_traceLogger.log(Level.SEVERE, "Destroying http server, " + this.getName() + " failed.", t);
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.server.getRequestThreadGroup();
    }

    public HttpServerConfig getConfig() {
        return this.config;
    }

    public TagLibraryArchive getTagLibContext(String url, Object compilationContext) throws InstantiationException {
        if (this.tagLibraryStorage == null) {
            this.tagLibraryStorage = new TagLibraryStorage(this.server.getLibraryClassLoader(), null, this.server.getDefaultApplication());
        }
        return this.tagLibraryStorage.getTagLibContext(null, null, url, compilationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpApplication getHttpApplicationFromSite(String applicationName, String name) {
        List sites;
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpServer httpServer = this;
            synchronized (httpServer) {
                sites = this.getSites();
            }
        }
        finally {
            destroyLock.unlock();
        }
        Iterator iterator = sites.iterator();
        while (iterator.hasNext()) {
            HttpSite site = (HttpSite)iterator.next();
            HttpApplication application = site.getHttpApplication(applicationName, name);
            if (application == null) continue;
            return application;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateHttpApplications(HttpApplicationReference reference, boolean removeEntryFromArray, boolean includeUserApplications) {
        ArrayList sites;
        ArrayList appsToDestroy = new ArrayList();
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpServer httpServer = this;
            synchronized (httpServer) {
                sites = new ArrayList(this.sites);
            }
        }
        finally {
            destroyLock.unlock();
        }
        for (int i = 0; i < sites.size(); ++i) {
            Collection userAppsToDestroy;
            HttpSite site = (HttpSite)sites.get(i);
            ArrayList sitesAppToDestroy = removeEntryFromArray ? site.invalidateHttpApplicationsAndRemoveEntry(reference) : site.invalidateHttpApplications(reference);
            if (sitesAppToDestroy.size() > 0) {
                appsToDestroy.addAll(sitesAppToDestroy);
            }
            if (!includeUserApplications || (userAppsToDestroy = site.getUserApplications()) == null) continue;
            appsToDestroy.addAll(userAppsToDestroy);
        }
        int appsToDestroyCnt = appsToDestroy.size();
        if (appsToDestroyCnt > 0) {
            CountDown done = new CountDown(appsToDestroyCnt);
            for (int i = 0; i < appsToDestroyCnt; ++i) {
                this.server.getThreadPool().launch(new HttpApplicationDestroyer((HttpApplication)appsToDestroy.get(i), done));
            }
            try {
                done.acquire();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void invalidateHttpApplications(HttpApplicationReference reference) {
        this.invalidateHttpApplications(reference, false, false);
    }

    public List getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningHandlers() {
        Object object = this.handlerLock;
        synchronized (object) {
            return this.runningHandlers;
        }
    }

    protected static final byte[] getStatusCodeDescriptionByteArray(int sc, String message) {
        if (sc < 0 || sc > statusCodeDescription.length) {
            if (message != null) {
                return message.getBytes();
            }
            return null;
        }
        if (HttpServer.isSSOReturnCode(sc, message)) {
            return message.getBytes();
        }
        return statusCodeDescriptionByteArray[sc];
    }

    protected static final String getStatusCodeDescription(int sc, String message) {
        if (sc < 0 || sc > statusCodeDescription.length) {
            return message;
        }
        if (HttpServer.isSSOReturnCode(sc, message)) {
            return message;
        }
        return statusCodeDescription[sc];
    }

    private static boolean isSSOReturnCode(int sc, String message) {
        return (sc == 499 || sc == 470 || sc == 480) && message != null;
    }

    public void hasChanged(List componentsToRefresh) {
        try {
            HttpApplicationConfig globalApplicationConfig;
            HttpApplicationConfigContext globalApplicationConfigContext = this.config.getDefaultHttpApplicationConfig();
            if (globalApplicationConfigContext != null && (globalApplicationConfig = globalApplicationConfigContext.getConfiguration()).isUpdated()) {
                m_traceLogger.log(Level.FINEST, "change in global-web-application.xml. Adding httpserver to the list that needs to be refreshed");
                componentsToRefresh.add(this);
            }
        }
        catch (InstantiationException e) {
            if (this.hasChangedException == null) {
                this.hasChangedException = e;
                if (m_traceLogger.isLoggable(Level.FINEST)) {
                    m_traceLogger.log(Level.FINEST, "Error in global web-config: " + e.getMessage(), e);
                }
            }
            try {
                ((XMLConfig)((Object)this.config.getDefaultHttpApplicationConfig().getConfiguration())).initLastModifieds();
            }
            catch (InstantiationException ie) {
                // empty catch block
            }
        }
        Iterator iterator = this.sites.iterator();
        while (iterator.hasNext()) {
            HttpSite httpSite = (HttpSite)iterator.next();
            httpSite.hasChanged(componentsToRefresh);
        }
    }

    public void refresh() {
        this.server.flushWebConfigs();
        this.invalidateHttpApplications(new HttpApplicationReference(null, null), false, true);
    }

    private void addJ2EEWebSiteMBean(J2EEWebSiteCallBackIf cback, String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        J2EEWebSite mbean = OC4JServiceInfo.AJP13.equalsIgnoreCase(cback.getProtocol()) ? new J2EEAJPWebSite((J2EEAJPWebSiteCallBackIf)cback, name) : new J2EEWebSite(cback, name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                this.removeJ2EEWebSiteMBean(name);
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            m_traceLogger.log(Level.FINEST, "Internal Error", e);
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            m_traceLogger.log(Level.FINEST, "Internal Error", e);
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            m_traceLogger.log(Level.FINEST, "Internal Error", e);
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            m_traceLogger.log(Level.FINEST, "Internal Error", e);
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            m_traceLogger.log(Level.FINEST, "Internal Error", e);
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void removeJ2EEWebSiteMBean(String name) {
        try {
            J2EEWebSite mbean = new J2EEWebSite(null, name);
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            m_traceLogger.log(Level.FINEST, "Internal Error", e);
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            m_traceLogger.log(Level.FINEST, "Internal Error", e);
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            m_traceLogger.log(Level.FINEST, "Internal Error", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private final String getWebSiteName(XMLHttpSiteConfig site) {
        String websitePath = site.getName();
        websitePath = XMLUtils.encode(websitePath);
        int begin = websitePath.lastIndexOf(47) + 1;
        int end = websitePath.lastIndexOf(46);
        return websitePath.substring(begin, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHttpApplications(String applicationName) {
        ArrayList sites;
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpServer httpServer = this;
            synchronized (httpServer) {
                sites = new ArrayList(this.sites);
            }
        }
        finally {
            destroyLock.unlock();
        }
        for (int i = 0; i < sites.size(); ++i) {
            HttpSite site = (HttpSite)sites.get(i);
            site.startHttpApplications(applicationName);
        }
    }

    public TaskManager getTaskManager() {
        return this.server.getTaskManager();
    }

    public void addWebsite(String name, String protocol, int port, String keystorePath, String keystorePassword, String sslProvider) throws IOException, InstantiationException {
        HttpSiteConfig config;
        int i;
        if (!(protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https") || protocol.equalsIgnoreCase("ajp") || protocol.equalsIgnoreCase("ajps"))) {
            throw new InstantiationException("Invalid protocol: " + protocol + ". Only http, https, ajp, and ajps are supported.");
        }
        if (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("ajp")) {
            if (keystorePath != null || keystorePassword != null) {
                throw new InstantiationException("keystorePath and keystorePassword are not required for non-secure web site.");
            }
        } else if (keystorePath == null || keystorePassword == null) {
            throw new InstantiationException("keystorePath and keystorePassword are required for secure web site.");
        }
        if (!name.endsWith("-web-site")) {
            throw new InstantiationException("Invalid web-site name: " + name + ". A valid web-site name must ends with \"-web-site\".");
        }
        String siteName = name.substring(0, name.length() - 9);
        String possibleName = "/" + siteName + "-web-site.xml";
        for (i = 0; i < this.siteConfigs.size(); ++i) {
            config = (HttpSiteConfig)this.siteConfigs.get(i);
            String id = config.getID();
            if (id.endsWith(possibleName)) {
                throw new InstantiationException("web site " + siteName + "-web-site already exists.");
            }
            if (config.getPort() != port || config.getProtocol() == XMLHttpSiteConfig.getProtocol(protocol) && !this.xor(config.isSecure(), protocol.toLowerCase().endsWith("s"))) continue;
            throw new InstantiationException("port number is used by web site " + this.getWebSiteNameFromConfigURLStr(config.getName()) + " with different protocol.");
        }
        if (protocol.equalsIgnoreCase("ajp") || protocol.equalsIgnoreCase("ajps")) {
            for (i = 0; i < this.siteConfigs.size(); ++i) {
                config = (HttpSiteConfig)this.siteConfigs.get(i);
                if (config.getProtocol() != 2) continue;
                throw new InstantiationException("Only one ajp web site is allowed. Exist ajp Web site: " + this.getWebSiteNameFromConfigURLStr(config.getName()) + ".");
            }
        }
        int idx = this.getApplicationServer().getConfig().getDefaultWebSiteIndex();
        HttpSiteConfig defSiteCfg = (HttpSiteConfig)this.siteConfigs.get(idx);
        HttpApplicationReference defaultHttpApp = defSiteCfg.getDefaultApplication();
        XMLHttpSiteConfig siteCfg = new XMLHttpSiteConfig((XMLServerConfig)((Object)this.server.getConfig()), (XMLApplicationServerConfig)this.getApplicationServer().getConfig());
        siteCfg.setAddress(InetAddress.getByName("0.0.0.0"));
        siteCfg.setDisplayName(siteName);
        if (protocol != null) {
            siteCfg.setProtocol(XMLHttpSiteConfig.getProtocol(protocol));
        }
        siteCfg.setPort(port);
        WebSiteAccessLog accessLog = new WebSiteAccessLog(null, "../log/" + siteName + "-web-access.log", "day", null);
        siteCfg.setAccessLog(accessLog);
        if (protocol.equalsIgnoreCase("https") || protocol.equalsIgnoreCase("ajps")) {
            siteCfg.setSecure(true);
            SSLConfig sslCfg = new SSLConfig(null, sslProvider, keystorePath, keystorePassword, null);
            siteCfg.setSSLConfig(sslCfg);
        }
        String filename = siteName + "-web-site.xml";
        URL cfgUrl = ConfigUtils.getURL(((XMLConfig)((Object)this.server.getConfig())).getURL(), filename);
        siteCfg.addApplication(defaultHttpApp);
        siteCfg.setURL(cfgUrl);
        siteCfg.store();
        siteCfg.init(cfgUrl);
        ((XMLApplicationServerConfig)this.getApplicationServer().getConfig()).addHttpSite("./" + filename, siteCfg);
        this.getApplicationServer().getConfig().store();
        this.setSites();
    }

    private String getWebSiteNameFromConfigURLStr(String urlstr) {
        if (urlstr == null || urlstr.trim().length() == 0 || !urlstr.endsWith("-web-site.xml")) {
            return urlstr;
        }
        int pos = urlstr.lastIndexOf(47);
        if (pos > 0) {
            return urlstr.substring(pos + 1, urlstr.length() - 4);
        }
        return urlstr.substring(0, urlstr.length() - 4);
    }

    private boolean xor(boolean a, boolean b) {
        return a && !b || b && !a;
    }

    static {
        m_traceLogger = TraceLogger.getLogger(HttpServer.class);
        statusCodeDescription = new String[506];
        statusCodeDescriptionByteArray = new byte[506][];
        HttpServer.statusCodeDescription[100] = "Continue";
        HttpServer.statusCodeDescription[101] = "Switching Protocols";
        HttpServer.statusCodeDescription[200] = "OK";
        HttpServer.statusCodeDescription[201] = "Created";
        HttpServer.statusCodeDescription[202] = "Accepted";
        HttpServer.statusCodeDescription[203] = "Non Authoritative Information";
        HttpServer.statusCodeDescription[204] = "No Content";
        HttpServer.statusCodeDescription[205] = "Reset Content";
        HttpServer.statusCodeDescription[206] = "Partial Content";
        HttpServer.statusCodeDescription[300] = "Multiple Choices";
        HttpServer.statusCodeDescription[301] = "Moved Permanently";
        HttpServer.statusCodeDescription[302] = "Moved Temporarily";
        HttpServer.statusCodeDescription[303] = "See Other";
        HttpServer.statusCodeDescription[304] = "Not Modified";
        HttpServer.statusCodeDescription[305] = "Use Proxy";
        HttpServer.statusCodeDescription[400] = "Bad Request";
        HttpServer.statusCodeDescription[401] = "Unauthorized";
        HttpServer.statusCodeDescription[402] = "Payment Required";
        HttpServer.statusCodeDescription[403] = "Forbidden";
        HttpServer.statusCodeDescription[404] = "Not Found";
        HttpServer.statusCodeDescription[405] = "Method Not Allowed";
        HttpServer.statusCodeDescription[406] = "Not Acceptable";
        HttpServer.statusCodeDescription[407] = "Proxy Authentication Required";
        HttpServer.statusCodeDescription[408] = "Request Timeout";
        HttpServer.statusCodeDescription[409] = "Conflict";
        HttpServer.statusCodeDescription[410] = "Gone";
        HttpServer.statusCodeDescription[411] = "Length Required";
        HttpServer.statusCodeDescription[412] = "Precondition Failed";
        HttpServer.statusCodeDescription[413] = "Request Entity Too Large";
        HttpServer.statusCodeDescription[414] = "Request URI Too Long";
        HttpServer.statusCodeDescription[415] = "Unsupported Media Type";
        HttpServer.statusCodeDescription[500] = "Internal Server Error";
        HttpServer.statusCodeDescription[501] = "Not Implemented";
        HttpServer.statusCodeDescription[502] = "Bad Gateway";
        HttpServer.statusCodeDescription[503] = "Service Unavailable";
        HttpServer.statusCodeDescription[504] = "Gateway Timeout";
        HttpServer.statusCodeDescription[505] = "HTTP Version Not Supported";
        for (int i = 0; i < statusCodeDescription.length; ++i) {
            if (statusCodeDescription[i] == null) continue;
            HttpServer.statusCodeDescriptionByteArray[i] = statusCodeDescription[i].getBytes();
        }
    }
}

