/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.reflect.Proxy;
import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.ejb.SessionBeanReferenceHolder;
import com.evermind.server.ejb.SessionContainer;
import com.evermind.server.ejb.StatefulSessionContext;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.http.HttpApplication;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.j2ee.util.TraceLogger;

public class HttpApplicationInputStream
extends EJBInputStream {
    private HttpApplication application;
    private Context context;
    private static Logger m_traceLogger = TraceLogger.getLogger(HttpApplicationInputStream.class);

    public HttpApplicationInputStream(InputStream in, HttpApplication application) throws IOException {
        super(in, application.getClassLoader());
        this.application = application;
        this.context = application.getApplication().getContext();
    }

    public HttpApplication getApplication() {
        return this.application;
    }

    public Context getLocalContext() {
        try {
            return this.application.getEnvironmentContext();
        }
        catch (NamingException e) {
            return null;
        }
    }

    public Context getInitialContext() {
        return this.context;
    }

    public Object resolveObject(Object object) throws IOException {
        try {
            if (object instanceof SessionBeanReferenceHolder) {
                SessionBeanReferenceHolder holder = (SessionBeanReferenceHolder)object;
                Object homeRemoteOrLocal = this.getInitialContext().lookup(holder.path);
                if (homeRemoteOrLocal instanceof Proxy) {
                    SessionContainer sessContainer = (SessionContainer)homeRemoteOrLocal;
                    return sessContainer.getSession(holder.id, holder.checksum);
                }
                StatefulSessionEJBHome home = (StatefulSessionEJBHome)homeRemoteOrLocal;
                StatefulSessionContext context = new StatefulSessionContext();
                context.remoteHome = home;
                return (StatefulSessionEJBObject)home.getInstances().get(holder.id);
            }
        }
        catch (NamingException nmex) {
            m_traceLogger.log(Level.FINE, "Attempt to resolveObject " + object + " on this server failed");
        }
        return super.resolveObject(object);
    }
}

