/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.EvermindJSPWriter;
import com.evermind.server.http.HttpIOException;
import com.evermind.util.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;

class EvermindServletOutputStream
extends ServletOutputStream {
    public static final int WRITE_CHUNK_SIZE = 100000;
    public static final int NO_WRITE_OR_FLUSH = -3;
    public static final int NO_WRITE = -2;
    public static final int MAX_INTEGER_LENGTH = 10;
    OutputStream out;
    boolean closed;
    EvermindHttpServletResponse response;
    int bytesWritten;
    int lastByteFlushed;
    int contentLength;
    byte[] buffer;
    int bufferLength;
    int bufferPos;
    private boolean ignoreWrites = false;

    EvermindServletOutputStream() {
    }

    public void setIgnoreWrites() {
        this.ignoreWrites = true;
    }

    protected int getContentLength() {
        return this.contentLength;
    }

    protected void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void reset(EvermindHttpServletResponse response) {
        this.response = response;
        this.bufferLength = 0;
        this.out = null;
        this.closed = false;
        this.bytesWritten = 0;
        this.contentLength = -1;
        this.bufferPos = 0;
        this.lastByteFlushed = 0;
        this.ignoreWrites = false;
    }

    protected void flushBuffer() throws HttpIOException {
        if (!this.response.committed) {
            this.response.commit();
        }
        try {
            if (this.bufferPos == 0) {
                return;
            }
            if (this.out == null) {
                this.response.commit();
            }
            this.out.write(this.buffer, 0, this.bufferPos);
            this.bufferPos = 0;
        }
        catch (IOException e) {
            this.response.request.application.log(e.getMessage());
        }
    }

    public synchronized void write(int i) throws HttpIOException {
        if (this.ignoreWrites) {
            return;
        }
        if (this.out == null && this.bufferLength == 0) {
            this.response.commit();
        }
        if (this.contentLength == -2 || this.contentLength == -3) {
            return;
        }
        try {
            if (this.bufferLength == 0) {
                this.out.write(i);
            } else {
                if (this.bufferPos >= this.bufferLength) {
                    this.flushBuffer();
                }
                this.buffer[this.bufferPos++] = (byte)i;
            }
            ++this.bytesWritten;
            this.checkContentLengthReached();
        }
        catch (IOException e) {
            throw new HttpIOException(e.getMessage());
        }
    }

    public void write(byte[] array) throws HttpIOException {
        this.write(array, 0, array.length);
    }

    protected int checkContentLength(int length) {
        if (this.contentLength != -1 && this.bytesWritten + length > this.contentLength) {
            if (this.contentLength == -2 || this.contentLength == -3) {
                return -1;
            }
            length = this.contentLength - this.bytesWritten;
        }
        return length;
    }

    public void write(byte[] array, int offset, int length) throws HttpIOException {
        if (this.ignoreWrites) {
            return;
        }
        try {
            if (offset < 0 || length < 0 || array.length < offset + length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.out == null && this.bufferLength == 0) {
                this.response.commit();
            }
            if ((length = this.checkContentLength(length)) < 0) {
                return;
            }
            if (this.bufferLength != 0) {
                if (length >= this.bufferLength) {
                    this.flushBuffer();
                    length = this.writeToOutputStream(array, offset, length);
                } else {
                    if (length >= this.bufferLength - this.bufferPos) {
                        this.flushBuffer();
                    }
                    try {
                        System.arraycopy(array, offset, this.buffer, this.bufferPos, length);
                    }
                    catch (IndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    this.bufferPos += length;
                }
            } else {
                length = this.writeToOutputStream(array, offset, length);
            }
            this.bytesWritten += length;
            this.checkContentLengthReached();
        }
        catch (IOException e) {
            throw new HttpIOException(e.getMessage());
        }
    }

    private void checkContentLengthReached() throws IOException {
        if (this.contentLength > 0 && this.bytesWritten >= this.contentLength) {
            this.response.commitAndIgnoreWrites();
        }
    }

    public void flush() throws HttpIOException {
        this.lastByteFlushed = this.bytesWritten;
        try {
            if (this.contentLength == -3) {
                return;
            }
            if (this.bufferLength != 0) {
                this.flushBuffer();
            }
            if (this.out == null) {
                this.response.commit();
            }
            try {
                this.out.flush();
            }
            catch (NullPointerException e) {}
        }
        catch (IOException e) {
            this.response.request.application.log(e.getMessage());
        }
    }

    void closeFinally() throws HttpIOException {
        if (!this.response.committed) {
            try {
                if (this.response.request.application.useHttpCompression && this.buffer != null && (this.response.status == 0 || this.response.status == 200) && this.response.request.canUseGzip() && !this.response.containsHeader("Content-Encoding")) {
                    this.response.setHeader("Content-Encoding", "gzip");
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    GZIPOutputStream zipOut = new GZIPOutputStream(bytes);
                    zipOut.write(this.buffer, 0, this.bufferPos);
                    zipOut.close();
                    byte[] zipData = bytes.toByteArray();
                    this.response.setContentLength(zipData.length);
                    System.arraycopy(zipData, 0, this.buffer, 0, zipData.length);
                    this.bufferPos = this.bytesWritten = zipData.length;
                }
                this.response.commit();
            }
            catch (IOException e) {
                return;
            }
        }
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.lastByteFlushed != this.bytesWritten) {
                if (!this.response.keepAlive && this.out == this.response.basicOut && this.bufferLength > 0) {
                    if (this.bufferPos > 0) {
                        this.out.write(this.buffer, 0, this.bufferPos);
                    }
                    this.out.flush();
                } else {
                    this.flush();
                }
            }
            if (this.contentLength >= 0 && this.bytesWritten != this.contentLength && this.bytesWritten < this.contentLength) {
                byte[] writeBuffer = new byte[10240];
                do {
                    int length;
                    if ((length = this.contentLength - this.bytesWritten) > writeBuffer.length) {
                        length = writeBuffer.length;
                    }
                    this.write(writeBuffer, 0, length);
                    this.bytesWritten += length;
                } while (this.bytesWritten < this.contentLength);
                this.out.flush();
            }
            if (this.out != this.response.basicOut) {
                this.out.close();
            }
        }
        catch (IOException e) {
            this.response.request.application.log(e.getMessage());
        }
    }

    protected void checkSetContentLength() {
        if (this.response.contentLength < 1 && this.bytesWritten > 0) {
            this.response.setContentLength(this.bytesWritten);
        }
    }

    protected void newLine() throws IOException {
        if (this.ignoreWrites) {
            return;
        }
        int length = this.checkContentLength(2);
        if (length < 0) {
            return;
        }
        if (this.bufferLength >= this.bufferPos + 2 && length == 2) {
            this.buffer[this.bufferPos++] = 13;
            this.buffer[this.bufferPos++] = 10;
            this.bytesWritten += 2;
        } else {
            this.write(13);
            this.write(10);
        }
        this.checkContentLengthReached();
    }

    public void print(boolean b) throws IOException {
        if (b) {
            this.write(EvermindJSPWriter.TRUE_ARRAY);
        } else {
            this.write(EvermindJSPWriter.FALSE_ARRAY);
        }
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(char[] c) throws IOException {
        this.print(c, 0, c.length);
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(int i) throws IOException {
        if (this.ignoreWrites) {
            return;
        }
        int length = this.checkContentLength(20);
        if (length < 0) {
            return;
        }
        if (this.bufferLength > this.bufferPos + 20 && length == 20) {
            int oldBufferPos = this.bufferPos;
            this.bufferPos = ArrayUtils.writeInt(this.buffer, this.bufferPos, i);
            this.bytesWritten += this.bufferPos - oldBufferPos;
            this.checkContentLengthReached();
        } else {
            this.print(String.valueOf(i));
        }
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(Object object) throws IOException {
        if (object == null) {
            return;
        }
        this.write(object.toString());
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(char[] c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.newLine();
    }

    public void println(String string) throws IOException {
        if (string == null || this.ignoreWrites) {
            return;
        }
        if (this.response.charset == null) {
            this.response.getCharacterEncoding();
        }
        if (this.response.charset == "ISO-8859-1") {
            int length = this.checkContentLength(string.length() + 2);
            if (length < 0) {
                return;
            }
            if (this.bufferLength >= this.bufferPos + length) {
                byte[] bytes = string.getBytes(this.response.charset);
                System.arraycopy(bytes, 0, this.buffer, this.bufferPos, length - 2);
                this.bufferPos += length;
                this.buffer[this.bufferPos - 2] = 13;
                this.buffer[this.bufferPos - 1] = 10;
                this.bytesWritten += length;
                this.checkContentLengthReached();
            } else {
                byte[] bytes = new byte[length];
                string.getBytes(0, length - 2, bytes, 0);
                bytes[length - 2] = 13;
                bytes[length - 1] = 10;
                this.write(bytes);
            }
        } else {
            this.print(string);
            this.newLine();
        }
    }

    public void write(char[] c) throws IOException {
        this.print(c, 0, c.length);
    }

    public void print(char[] array, int offset, int length) throws IOException {
        if (array == null || this.ignoreWrites) {
            return;
        }
        if ((length = this.checkContentLength(length)) < 0) {
            return;
        }
        if (this.bufferLength < this.bufferPos + array.length) {
            this.write(new String(array, offset, length).getBytes());
            return;
        }
        ArrayUtils.copyArray(array, offset, this.buffer, this.bufferPos, length);
        this.bufferPos += length;
        this.bytesWritten += length;
        this.checkContentLengthReached();
    }

    public void print(String string) throws IOException {
        if (string == null || this.ignoreWrites) {
            return;
        }
        if (this.response.charset == null) {
            this.response.getCharacterEncoding();
        }
        if (this.response.charset == "ISO-8859-1") {
            int length = this.checkContentLength(string.length());
            if (length < 0) {
                return;
            }
            if (this.bufferLength >= this.bufferPos + length) {
                byte[] bytes = string.getBytes(this.response.charset);
                System.arraycopy(bytes, 0, this.buffer, this.bufferPos, length);
                this.bufferPos += length;
                this.bytesWritten += length;
                this.checkContentLengthReached();
            } else {
                byte[] bytes = new byte[length];
                string.getBytes(0, length, bytes, 0);
                this.write(bytes);
            }
        } else {
            this.write(string.getBytes(this.response.charset));
        }
    }

    public void write(char[] c, int offset, int length) throws IOException {
        this.print(c, offset, length);
    }

    public void write(String string) throws IOException {
        this.print(string);
    }

    public void write(String string, int offset, int length) throws IOException {
        this.write(string.toCharArray(), offset, length);
    }

    private int writeToOutputStream(byte[] array, int offset, int length) throws IOException {
        if (this.out == null) {
            this.response.commit();
        }
        while (length > 100000) {
            this.out.write(array, offset, 100000);
            this.bytesWritten += 100000;
            offset += 100000;
            length -= 100000;
        }
        this.out.write(array, offset, length);
        return length;
    }

    public void close() throws IOException {
        this.response.commitAndIgnoreWrites();
    }

    public void resetBuffer() {
        this.bufferPos = 0;
        this.bytesWritten = 0;
    }
}

