/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.EvermindPageContext;
import com.evermind.server.http.JspCommonExtraWriter;
import com.evermind.util.ArrayUtils;
import com.evermind.util.HTTPProperties;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.JspWriter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;

public class EvermindJSPWriter
extends JspWriter
implements JspCommonExtraWriter {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    static final byte[] TRUE_ARRAY = "true".getBytes();
    static final byte[] FALSE_ARRAY = "false".getBytes();
    static String THAI_CHARSET_IANA = "TIS-620";
    static String THAI_CHARSET_JAVA = "TIS620";
    static Class orionOutputStream = null;
    static Class sunCTBConverter = null;
    protected boolean closed;
    protected byte[] buffer;
    protected int pos;
    protected int bytesFlushed;
    private OutputStream out;
    private String charSet;
    private int charSetCode = 0;
    public static final int CHARSET_ISO_8859_1 = -1;
    public static final int CHARSET_UTF8 = -2;
    private EvermindPageContext context;
    private ServletResponse response;
    protected boolean printNullStr;
    protected boolean isISO8859Convert;
    protected boolean explicitCharSet;
    protected int givenBufferSize;
    private CharToByteConverter ctbConverter = null;
    private boolean ctbConverterInit;
    private String ctbConverterEncoding;
    private String ctbConverterEncodingAlias;
    private byte[] newLineBytes = null;
    private String lastCheckedRespCharSet;
    private boolean checkCharSetDone;
    private String lastCheckedCharSet;

    public EvermindJSPWriter(EvermindPageContext context, int bufferSize, boolean autoFlush, boolean printNullStr, boolean isISO8859Convert) throws IOException {
        super(bufferSize, autoFlush);
        if (bufferSize == -1) {
            bufferSize = 8192;
        }
        this.bufferSize = bufferSize;
        this.givenBufferSize = bufferSize;
        this.context = context;
        this.response = context.getResponse();
        this.printNullStr = printNullStr;
        this.isISO8859Convert = isISO8859Convert;
        this.explicitCharSet = false;
        if (bufferSize > 0) {
            this.buffer = new byte[bufferSize];
        }
        this.ctbConverterInit = false;
        if (!HTTPProperties.getCheckDynamicCharset()) {
            this.checkCharSet();
            this.checkCharSetDone = true;
        }
    }

    void initialize(int bufferSize, boolean autoFlush, boolean printNullStr, boolean isISO8859Convert) throws IOException {
        if (bufferSize == -1) {
            bufferSize = 8192;
        }
        this.bufferSize = bufferSize;
        this.givenBufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.printNullStr = printNullStr;
        this.isISO8859Convert = isISO8859Convert;
        if (this.buffer == null || this.buffer.length != bufferSize) {
            this.buffer = (byte[])(bufferSize > 0 ? new byte[bufferSize] : null);
        }
        this.charSet = null;
        this.lastCheckedRespCharSet = null;
        this.lastCheckedCharSet = null;
        this.checkCharSetDone = false;
        this.response = this.context.getResponse();
        this.explicitCharSet = false;
        this.ctbConverterInit = false;
        this.newLineBytes = null;
        if (!HTTPProperties.getCheckDynamicCharset()) {
            this.checkCharSet();
            this.checkCharSetDone = true;
        }
    }

    public void setExplicitCharSet(String charSet) {
        this.explicitCharSet = true;
        this.setCharSet(charSet);
    }

    protected void checkCharSet() throws UnsupportedEncodingException {
        String respCharSet;
        if (this.checkCharSetDone) {
            return;
        }
        if (!this.explicitCharSet && this.lastCheckedRespCharSet != (respCharSet = this.response.getCharacterEncoding())) {
            this.setCharSet(respCharSet);
            this.lastCheckedRespCharSet = respCharSet;
        }
        if (this.lastCheckedCharSet != this.charSet && this.isNonDefaultCharSet() && sunCTBConverter != null) {
            this.getCTBConverter();
        }
        this.lastCheckedCharSet = this.charSet;
    }

    protected void reset() {
        this.out = null;
        this.pos = 0;
        this.charSetCode = 0;
        this.closed = false;
        this.bytesFlushed = 0;
        this.response = null;
        if (this.buffer != null && this.buffer.length > 8192) {
            this.buffer = null;
        }
    }

    public void clear() throws IOException {
        if (this.bytesFlushed > 0) {
            throw new IOException("Data has already been flushed to the client");
        }
        this.pos = 0;
    }

    public void clearBuffer() throws IOException {
        this.pos = 0;
    }

    public void close() throws IOException {
        if (this.context.evermindResponse != null && this.context.evermindResponse.status == 302 && this.context.evermindResponse.contentLength >= 0 && this.context.evermindResponse.contentLength < this.pos + this.context.evermindResponse.out.bytesWritten) {
            this.closed = true;
            return;
        }
        if (this.closed) {
            return;
        }
        if (this.context.evermindRequest != null && this.context.evermindRequest.originalApplication == null) {
            int len;
            try {
                PrintWriter writer = ((EvermindHttpServletResponse)this.context.response).getCurrentWriter();
                if (writer != null) {
                    writer.flush();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (this.context.evermindResponse != null && !this.context.evermindResponse.committed && (len = this.pos + this.context.evermindResponse.out.bytesWritten) != 0) {
                this.context.response.setContentLength(len);
            }
        }
        this.jspflush();
        this.closed = true;
    }

    public void flush() throws IOException {
        this.jspflush();
        this.initServletOut();
        this.out.flush();
    }

    private void jspflush() throws IOException {
        if (this.closed) {
            throw new IOException("The Writer is closed");
        }
        if (this.pos > 0) {
            this.writeOut(this.buffer, 0, this.pos);
            this.pos = 0;
        }
    }

    public int getBufferSize() {
        if (this.buffer != null) {
            return this.buffer.length;
        }
        return 0;
    }

    public int getRemaining() {
        if (this.buffer != null) {
            return this.bufferSize - this.pos;
        }
        return 0;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void newLine() throws IOException {
        if (this.closed) {
            throw new IOException("The Writer is closed");
        }
        if (this.newLineBytes == null) {
            this.newLineBytes = this.charSet == null ? System.getProperty("line.separator").getBytes() : System.getProperty("line.separator").getBytes(this.charSet);
        }
        if (this.buffer != null) {
            int reqLength = this.newLineBytes.length;
            if (reqLength > this.bufferSize - this.pos) {
                this.assureSpace(this.newLineBytes.length);
            }
            for (int i = 0; i < this.newLineBytes.length; ++i) {
                this.buffer[this.pos++] = this.newLineBytes[i];
            }
        } else {
            this.write(this.newLineBytes);
        }
    }

    public void print(boolean b) throws IOException {
        if (b) {
            this.write(TRUE_ARRAY);
        } else {
            this.write(FALSE_ARRAY);
        }
    }

    private void initServletOut() throws IOException {
        if (this.out == null) {
            this.out = this.context.evermindResponse != null ? this.context.evermindResponse.getJspOutputStream() : this.getProperOutputStream(this.response);
        }
    }

    private ServletOutputStream getProperOutputStream(ServletResponse aResponse) throws IOException {
        if (!(aResponse instanceof HttpServletResponseWrapper)) {
            return aResponse.getOutputStream();
        }
        HttpServletResponseWrapper resp = (HttpServletResponseWrapper)aResponse;
        while (resp.getResponse() instanceof HttpServletResponseWrapper) {
            resp = (HttpServletResponseWrapper)resp.getResponse();
        }
        ServletResponse unwrappedResponse = resp.getResponse();
        if (unwrappedResponse instanceof EvermindHttpServletResponse) {
            ((EvermindHttpServletResponse)unwrappedResponse).setUseJspOutputStream(true);
            ServletOutputStream outputStream = aResponse.getOutputStream();
            ((EvermindHttpServletResponse)unwrappedResponse).setUseJspOutputStream(false);
            return outputStream;
        }
        return aResponse.getOutputStream();
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    private void writeOut(byte[] data, int start, int length) throws IOException {
        this.initServletOut();
        this.bytesFlushed += length;
        this.out.write(data, start, length);
    }

    private void writeOut(int i) throws IOException {
        this.initServletOut();
        ++this.bytesFlushed;
        this.out.write(i);
    }

    public void writeByte(int i) throws IOException {
        if (this.closed) {
            throw new IOException("The Writer is closed");
        }
        if (this.buffer != null) {
            this.assureSpace(1);
            this.buffer[this.pos++] = (byte)i;
        } else {
            this.initServletOut();
            ++this.bytesFlushed;
            this.out.write(i);
        }
    }

    public void write(byte[] data, int start, int length) throws IOException {
        if (this.closed) {
            throw new IOException("The Writer is closed");
        }
        if (this.buffer != null) {
            if (length > this.bufferSize - this.pos) {
                this.assureSpace(length);
            }
            System.arraycopy(data, start, this.buffer, this.pos, length);
            this.pos += length;
        } else {
            this.writeOut(data, start, length);
        }
    }

    public void print(char c) throws IOException {
        char[] ca = new char[]{c};
        this.write(ca, 0, 1);
    }

    public void print(char[] c) throws IOException {
        this.print(c, 0, c.length);
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(int i) throws IOException {
        if (this.bufferSize > 0) {
            this.assureSpace(20);
            this.pos = ArrayUtils.writeInt(this.buffer, this.pos, i);
        } else {
            this.print(String.valueOf(i));
        }
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(Object object) throws IOException {
        if (object == null) {
            if (this.printNullStr) {
                this.print("null");
                return;
            }
            return;
        }
        this.write(object.toString());
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(char[] c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.newLine();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.newLine();
    }

    public void write(char[] c) throws IOException {
        this.print(c, 0, c.length);
    }

    public void print(char[] array, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("The Writer is closed");
        }
        this.checkCharSet();
        if (array == null) {
            return;
        }
        if (offset < 0 || offset > array.length || offset + length < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (array.length == 0 || length == 0) {
            return;
        }
        if (this.bufferSize < 1) {
            if (this.charSet != null) {
                this.write(new String(array, offset, length).getBytes(this.charSet));
            } else {
                this.write(new String(array, offset, length).getBytes());
            }
            return;
        }
        if (this.charSet == null || this.charSetCode == -1) {
            if (length > this.bufferSize - this.pos) {
                this.assureSpace(length);
            }
            ArrayUtils.copyArray(array, offset, this.buffer, this.pos, length);
            this.pos += length;
            return;
        }
        if (this.charSetCode != -2) {
            if (this.ctbConverter != null) {
                this.assureSpace(length);
                this.convertAndWriteCharacters(array, offset, length);
            } else {
                this.write(new String(array, offset, length).getBytes(this.charSet));
            }
            return;
        }
        this.javaCharsToAL32UTF8(array, offset, length);
    }

    public void print(String string) throws IOException {
        if (this.closed) {
            throw new IOException("The Writer is closed");
        }
        if (string == null) {
            if (this.printNullStr) {
                string = "null";
            } else {
                return;
            }
        }
        this.checkCharSet();
        if (this.bufferSize < 1) {
            if (this.charSet != null) {
                this.write(string.getBytes(this.charSet));
            } else {
                this.write(string.getBytes());
            }
            return;
        }
        int stringLength = string.length();
        if (this.charSet == null || this.charSetCode == -1) {
            if (stringLength > this.bufferSize - this.pos) {
                this.assureSpace(stringLength);
            }
            if (this.isISO8859Convert) {
                byte[] byteArr = null;
                byteArr = this.charSet != null ? string.getBytes(this.charSet) : string.getBytes();
                System.arraycopy(byteArr, 0, this.buffer, this.pos, stringLength);
            } else {
                string.getBytes(0, stringLength, this.buffer, this.pos);
            }
            this.pos += stringLength;
            return;
        }
        if (this.charSetCode != -2) {
            if (this.ctbConverter != null) {
                if (stringLength > this.bufferSize - this.pos) {
                    this.assureSpace(stringLength);
                }
                this.convertAndWriteCharacters(string.toCharArray(), 0, stringLength);
            } else {
                this.write(string.getBytes(this.charSet));
            }
            return;
        }
        this.javaCharsToAL32UTF8(string, 0, stringLength);
    }

    public void write(char[] c, int offset, int length) throws IOException {
        this.print(c, offset, length);
    }

    public void write(int i) throws IOException {
        this.print((char)i);
    }

    public void write(String string) throws IOException {
        this.print(string);
    }

    public void write(String string, int offset, int length) throws IOException {
        this.write(string.toCharArray(), offset, length);
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
        if (charSet.equalsIgnoreCase("iso-8859-1") || charSet.equalsIgnoreCase("iso8859_1")) {
            this.charSetCode = -1;
        } else if (charSet.equalsIgnoreCase("utf-8") || charSet.equalsIgnoreCase("utf8")) {
            this.charSetCode = -2;
        } else if (charSet.equalsIgnoreCase(THAI_CHARSET_IANA)) {
            this.charSet = THAI_CHARSET_JAVA;
            this.charSetCode = 0;
        } else {
            this.charSetCode = 0;
        }
    }

    public String getCharSet() {
        return this.charSet;
    }

    private final void assureSpace(int length) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[200];
        }
        if (this.givenBufferSize != 0 && this.givenBufferSize != -2 && length > this.bufferSize - this.pos) {
            if (this.autoFlush) {
                if (this.context.evermindResponse == null) {
                    this.jspflush();
                }
            } else {
                throw new IOException("buffer overflow");
            }
        }
        this.increaseBuffer(length);
    }

    private void increaseBuffer(int length) {
        while (length > this.buffer.length - this.pos) {
            byte[] newBuffer = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.bufferSize = this.buffer.length;
    }

    private void getCTBConverter() throws UnsupportedEncodingException {
        if (this.ctbConverter != null && (this.ctbConverterEncoding.equalsIgnoreCase(this.charSet) || this.ctbConverterEncodingAlias.equalsIgnoreCase(this.charSet))) {
            if (this.ctbConverterInit) {
                return;
            }
            this.ctbConverter.reset();
        } else {
            this.ctbConverter = CharToByteConverter.getConverter((String)this.charSet);
            this.ctbConverterEncoding = this.ctbConverter.getCharacterEncoding();
            this.ctbConverterEncodingAlias = this.charSet;
        }
        this.ctbConverterInit = true;
    }

    private boolean isNonDefaultCharSet() {
        return this.charSet != null && this.charSetCode == 0;
    }

    private void convertAndWriteCharacters(char[] cbuf, int off, int len) throws IOException {
        int charIndex = off;
        int end = off + len;
        boolean isBufferFlushed = false;
        while (charIndex < end) {
            try {
                this.pos += this.ctbConverter.convertAny(cbuf, charIndex, end, this.buffer, this.pos, this.buffer.length);
                charIndex = end;
            }
            catch (ConversionBufferFullException e) {
                int nextCharIndex = this.ctbConverter.nextCharIndex();
                if (nextCharIndex == charIndex && isBufferFlushed) {
                    throw new CharConversionException("Converter malfunction : buffer too small");
                }
                charIndex = nextCharIndex;
                int remainChars = end - charIndex;
                this.pos = this.ctbConverter.nextByteIndex();
                this.assureSpace(remainChars * this.ctbConverter.getMaxBytesPerChar());
                isBufferFlushed = true;
            }
        }
    }

    int javaCharsToAL32UTF8(String string, int chars_offset, int chars_count) throws IOException {
        int chars_begin = chars_offset;
        int chars_end = chars_offset + chars_count;
        boolean allocated = false;
        for (int i = chars_begin; i < chars_end; ++i) {
            char c;
            if (!allocated && this.buffer.length - this.pos < 3) {
                this.assureSpace((chars_end - i) * 3);
                allocated = true;
            }
            if ((c = string.charAt(i)) >= '\u0000' && c <= '\u007f') {
                this.buffer[this.pos++] = (byte)c;
                continue;
            }
            if (c >= '\ud800' && c <= '\udb00') {
                char c2;
                if (i + 1 >= chars_end || !((c2 = string.charAt(i + 1)) >= '\udc00' & c2 <= '\udf00')) continue;
                int uuuuu = (c >> 6 & 0xF) + 1;
                this.buffer[this.pos++] = (byte)(uuuuu >> 2 | 0xF0);
                this.buffer[this.pos++] = (byte)((uuuuu & 3) << 4 | c >> 2 & 0xF | 0x80);
                this.buffer[this.pos++] = (byte)((c & 3) << 4 | c2 >> 6 & 0xF | 0x80);
                this.buffer[this.pos++] = (byte)(c2 & 0x3F | 0x80);
                ++i;
                continue;
            }
            if (c > '\u07ff') {
                this.buffer[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buffer[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return this.pos;
    }

    int javaCharsToAL32UTF8(char[] chars, int chars_offset, int chars_count) throws IOException {
        int chars_begin = chars_offset;
        int chars_end = chars_offset + chars_count;
        boolean allocated = false;
        for (int i = chars_begin; i < chars_end; ++i) {
            char c;
            if (!allocated && this.buffer.length - this.pos < 3) {
                this.assureSpace((chars_end - i) * 3);
                allocated = true;
            }
            if ((c = chars[i]) >= '\u0000' && c <= '\u007f') {
                this.buffer[this.pos++] = (byte)c;
                continue;
            }
            if (c >= '\ud800' && c <= '\udb00') {
                char c2;
                if (i + 1 >= chars_end || !((c2 = chars[i + 1]) >= '\udc00' & c2 <= '\udf00')) continue;
                int uuuuu = (c >> 6 & 0xF) + 1;
                this.buffer[this.pos++] = (byte)(uuuuu >> 2 | 0xF0);
                this.buffer[this.pos++] = (byte)((uuuuu & 3) << 4 | c >> 2 & 0xF | 0x80);
                this.buffer[this.pos++] = (byte)((c & 3) << 4 | c2 >> 6 & 0xF | 0x80);
                this.buffer[this.pos++] = (byte)(c2 & 0x3F | 0x80);
                ++i;
                continue;
            }
            if (c > '\u07ff') {
                this.buffer[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buffer[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return this.pos;
    }

    static {
        try {
            orionOutputStream = Class.forName("com.evermind.server.http.EvermindServletOutputStream");
            sunCTBConverter = Class.forName("sun.io.CharToByteConverter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

