/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.io.IOUtils;
import com.evermind.security.User;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationInputStream;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.http.ParameterMap;
import com.evermind.server.http.administration.HttpSessionRuntimeInfo;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.j2ee.util.TraceLogger;
import oracle.security.jazn.realm.DeactivatableUser;

public class EvermindHttpSession
implements HttpSession,
Serializable,
SSLSessionBindingListener {
    public static final int STATUS_PERFORMING_LOGIN = 1;
    public static final int STATUS_SUPPLIED_USERNAME = 2;
    public static final long serialVersionUID = 5676799332747648088L;
    transient HttpApplication application;
    transient User user;
    protected Object[] values;
    protected int valueCount;
    protected long creationTime = System.currentTimeMillis();
    protected long lastAccessedTime;
    private transient long mostRecentAccessedTime;
    private int threadHash = Thread.currentThread().hashCode();
    int maxInactiveInterval;
    ByteString id;
    boolean invalidated;
    private transient boolean invalidating = false;
    public byte[] idByte;
    public String loginMethod;
    public ByteString loginPath;
    ParameterMap loginParameters;
    ByteString loginQueryString;
    private String loginUnparsedURI;
    public int status;
    private int activeRequestsCount;
    int ip;
    private PhaseEventIntf sessionActivationPhase;
    private long sessionActivationToken;
    private static String localHostIPAddressInHex = null;
    private static Logger m_traceLogger = TraceLogger.getLogger(EvermindHttpSession.class);
    private static final byte[] toHex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static SecureRandom secRandom;
    private static final String ALGORITHM = "SHA1PRNG";
    private static final int INTEGER_SIZE = 32;
    private static final int LONG_SIZE = 64;
    private static boolean shouldLogNoSuchAlgorithmException;

    protected EvermindHttpSession() {
        this.lastAccessedTime = this.creationTime;
    }

    private EvermindHttpSession(HttpApplication application) {
        this.lastAccessedTime = this.creationTime;
        this.application = application;
        this.startDMSSessionActivationPhase();
    }

    public EvermindHttpSession(HttpApplication application, ByteString id, byte[] idByte, int maxInactiveInterval) {
        this.application = application;
        this.maxInactiveInterval = maxInactiveInterval;
        this.id = id;
        this.idByte = idByte;
        this.lastAccessedTime = this.creationTime;
        this.startDMSSessionActivationPhase();
    }

    private void startDMSSessionActivationPhase() {
        if (ApplicationServer.DMS_GATE) {
            this.setSessionActivationToken(this.getSessionActivationPhase().start());
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value, true);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAttribute(String name, Object value, boolean executeListeners) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name can not be null");
        }
        if (!(!this.application.distributable || value == null || value instanceof EJBObject || value instanceof Serializable || value instanceof EJBHome || value instanceof byte[] || value.getClass().isArray())) {
            throw new IllegalArgumentException("Only java.io.Serializable, javax.ejb.EJBObject and javax.ejb.EJBHome instances can be bound to a session in a distributable web-application, not: " + value + " (" + value.getClass() + ")");
        }
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        if (value == null) {
            if (executeListeners) {
                this.removeAttribute(name);
            } else {
                this.removeValueSilently(name);
            }
            return;
        }
        EvermindHttpSession evermindHttpSession = this;
        synchronized (evermindHttpSession) {
            Object previous = this.putValueToMap(name, value);
            if (executeListeners && previous instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)previous).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            if (executeListeners && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            if (executeListeners && this.application.sessionAttributeListeners != null) {
                HttpSessionAttributeListener[] listeners = this.application.sessionAttributeListeners;
                for (int i = 0; i < listeners.length; ++i) {
                    if (previous != null) {
                        listeners[i].attributeReplaced(new HttpSessionBindingEvent((HttpSession)this, name, previous));
                        continue;
                    }
                    listeners[i].attributeAdded(new HttpSessionBindingEvent((HttpSession)this, name, value));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putValueSilently(String name, Object value) {
        EvermindHttpSession evermindHttpSession = this;
        synchronized (evermindHttpSession) {
            this.putValueToMap(name, value);
        }
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        if (name == null) {
            return null;
        }
        EvermindHttpSession evermindHttpSession = this;
        synchronized (evermindHttpSession) {
            Object value = this.getValueFromMap(name);
            return value;
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        if (name == null) {
            return;
        }
        EvermindHttpSession evermindHttpSession = this;
        synchronized (evermindHttpSession) {
            Object value = this.removeValueFromMap(name);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            if (value != null && this.application.sessionAttributeListeners != null) {
                HttpSessionAttributeListener[] listeners = this.application.sessionAttributeListeners;
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].attributeRemoved(new HttpSessionBindingEvent((HttpSession)this, name, value));
                }
            }
        }
    }

    void removeValueSilently(String name) {
        this.removeValueFromMap(name);
    }

    public HttpSessionContext getSessionContext() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        return this.application;
    }

    public long getCreationTime() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        return this.lastAccessedTime;
    }

    protected long getLastAccessedTimeWithoutRuntimeCheck() {
        if (this.invalidated) {
            throw new IllegalStateException("Session was invalidated");
        }
        return this.lastAccessedTime;
    }

    void accessed() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public boolean isInvalid() {
        if (this.invalidated) {
            return true;
        }
        if (this.invalidating) {
            return false;
        }
        if (this.isTimedOut(HttpDateFormat.currentTimeLong)) {
            try {
                this.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean getInvalidated() {
        return this.invalidated;
    }

    public synchronized void invalidateLocal() {
        if (HTTPProperties.getHttpSessionDebug()) {
            m_traceLogger.log(Level.FINE, this + ".invalidate(), session was invalid:" + this.invalidated);
        }
        if (this.getInvalidated()) {
            throw new IllegalStateException("Session was invalidated");
        }
        this.application.invalidateLocalSession(this);
        if (this.user != null) {
            this.user = null;
        }
        this.invalidated = true;
    }

    public void checkTimedOut() {
        if (this.isTimedOut(HttpDateFormat.currentTimeLong)) {
            try {
                this.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            throw new IllegalStateException("Session was invalidated");
        }
    }

    public synchronized void invalidate() {
        this.invalidate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void invalidate(boolean executeListeners) {
        if (this.invalidating) {
            return;
        }
        this.invalidating = true;
        try {
            if (HTTPProperties.getHttpSessionDebug()) {
                m_traceLogger.log(Level.FINE, this + ".invalidate(), session was invalid:" + this.invalidated);
            }
            if (this.getInvalidated()) {
                throw new IllegalStateException("Session was invalidated");
            }
            this.application.invalidateSession(this, executeListeners);
            if (this.user != null) {
                this.user = null;
            }
        }
        finally {
            this.invalidated = true;
            this.invalidating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy(boolean timedOut, boolean executeListeners) {
        if (HTTPProperties.getHttpSessionDebug()) {
            if (timedOut) {
                m_traceLogger.log(Level.FINE, "Invalidating session with id '" + this.getId() + "' at " + new Date(System.currentTimeMillis()) + " (created at " + new Date(this.getCreationTime()) + ") due to timeout");
            } else {
                m_traceLogger.log(Level.FINE, "Invalidating session with id '" + this.getId() + "' at " + new Date(System.currentTimeMillis()) + " (created at " + new Date(this.getCreationTime()) + ") due to explicit invalidate() call");
                m_traceLogger.log(Level.FINE, "Call stack of invalidate()", new Throwable("invalidate() called"));
            }
        }
        EvermindHttpSession evermindHttpSession = this;
        synchronized (evermindHttpSession) {
            if (executeListeners) {
                for (int i = 0; i < this.valueCount; i += 2) {
                    if (!(this.values[i + 1] instanceof HttpSessionBindingListener)) continue;
                    ((HttpSessionBindingListener)this.values[i + 1]).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, (String)this.values[i]));
                }
            }
            this.valueCount = 0;
            this.values = null;
        }
    }

    public String getId() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        return this.id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        if (this.valueCount == 0) {
            return new String[0];
        }
        EvermindHttpSession evermindHttpSession = this;
        synchronized (evermindHttpSession) {
            String[] names = new String[this.valueCount / 2];
            for (int i = 0; i < this.valueCount; i += 2) {
                names[i / 2] = (String)this.values[i];
            }
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        if (this.valueCount > 0) {
            EvermindHttpSession evermindHttpSession = this;
            synchronized (evermindHttpSession) {
                ArrayList<Object> names = new ArrayList<Object>();
                for (int i = 0; i < this.valueCount; i += 2) {
                    names.add(this.values[i]);
                }
                return Collections.enumeration(names);
            }
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public boolean isNew() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        if (this.lastAccessedTime != this.creationTime) {
            return false;
        }
        return Thread.currentThread().hashCode() == this.threadHash;
    }

    public int getMaxInactiveInterval() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        this.maxInactiveInterval = maxInactiveInterval;
    }

    private static String toHex(byte value) {
        String result = Integer.toHexString(value & 0xFF);
        if (result.length() < 2) {
            result = "0".concat(result);
        }
        return result;
    }

    public static byte[] encodeSession(byte[] suffix) {
        byte[] uid = new byte[32];
        EvermindHttpSession.getSecureRandom().nextBytes(uid);
        uid = EvermindHttpSession.convertToHex(uid);
        if (suffix != null && suffix.length > 0) {
            byte[] array = new byte[uid.length + suffix.length];
            System.arraycopy(uid, 0, array, 0, uid.length);
            System.arraycopy(suffix, 0, array, array.length - suffix.length, suffix.length);
            return array;
        }
        return uid;
    }

    public static byte[] convertToHex(byte[] bytes) {
        byte[] result = new byte[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result[2 * i] = toHex[(b & 0xF0) >> 4];
            result[2 * i + 1] = toHex[b & 0xF];
        }
        return result;
    }

    private static SecureRandom getSecureRandom() {
        if (secRandom == null) {
            ApplicationServerThread thread = ThreadState.getInheritableCurrentState().getApplicationServerThread();
            EvermindHttpServletRequest request = thread == null ? null : (thread.httpHandler == null ? null : thread.httpHandler.request);
            int portNo = request == null ? 0 : request.socket.getLocalPort();
            long nanoTime = System.currentTimeMillis();
            try {
                byte[] localAddress = InetAddress.getLocalHost().getAddress();
                secRandom = EvermindHttpSession.getNewSecureRandom(EvermindHttpSession.makeSeed(localAddress, portNo, nanoTime));
            }
            catch (UnknownHostException e) {
                m_traceLogger.log(Level.SEVERE, "The host has an illegal ip address. Stop OC4J and check your environment", e);
            }
        }
        return secRandom;
    }

    private static byte[] makeSeed(byte[] localAddress, int portNo, long nanoTime) {
        int i;
        int l = localAddress.length + 12;
        byte[] seed = new byte[l];
        System.arraycopy(localAddress, 0, seed, 0, localAddress.length);
        int offset = localAddress.length;
        for (i = 0; i < 8; ++i) {
            seed[i + offset] = (byte)(nanoTime >> i * 8);
        }
        offset += 8;
        for (i = 0; i < 4; ++i) {
            seed[i + offset] = (byte)(portNo >> i * 8);
        }
        return seed;
    }

    private static SecureRandom getNewSecureRandom(byte[] seed) {
        SecureRandom result;
        block2: {
            try {
                result = SecureRandom.getInstance(ALGORITHM);
            }
            catch (NoSuchAlgorithmException ex) {
                result = new SecureRandom();
                if (!shouldLogNoSuchAlgorithmException) break block2;
                m_traceLogger.log(Level.WARNING, "The specified SecureRandom algorithm, SHA1PRNG, was not found. The default algorithm was used instead.");
                m_traceLogger.log(Level.FINER, "    The exception follows:", ex);
                shouldLogNoSuchAlgorithmException = false;
            }
        }
        result.setSeed(seed);
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.write(out);
    }

    void write(ObjectOutputStream out) throws IOException {
        out.writeLong(this.creationTime);
        out.writeLong(this.lastAccessedTime);
        IOUtils.writeCompressedInt(out, this.maxInactiveInterval);
        this.id.write(out);
        IOUtils.writeCompressedInt(out, this.ip);
        out.writeBoolean(this.invalidated);
        out.writeUTF(this.user == null || this.user.getName() == null ? "" : this.user.getName());
        IOUtils.writeCompressedInt(out, this.valueCount);
        for (int i = 0; i < this.valueCount; i += 2) {
            out.writeUTF((String)this.values[i]);
            IOUtils.writeSimpleObject(out, this.values[i + 1]);
        }
    }

    static EvermindHttpSession read(ObjectInputStream in, HttpApplication application) throws IOException, ClassNotFoundException {
        EvermindHttpSession session = new EvermindHttpSession(application);
        session.readObject(in);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushObsoletedClasses(ClassLoader obsoletedClassLoader) {
        boolean removeMe = false;
        EvermindHttpSession evermindHttpSession = this;
        synchronized (evermindHttpSession) {
            for (int i = 0; i < this.valueCount; i += 2) {
                Object value = this.values[i + 1];
                if (obsoletedClassLoader != null && value.getClass().getClassLoader() != obsoletedClassLoader) continue;
                removeMe = true;
                if (value instanceof HttpSessionBindingListener) {
                    ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, (String)this.values[i]));
                }
                this.removeValueFromMap((String)this.values[i]);
                i -= 2;
            }
        }
        if (removeMe) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String username;
        if (HTTPProperties.getHttpSessionDebug()) {
            m_traceLogger.log(Level.FINE, "EvermindHttpSession.readObject(" + in + ")");
            if (in instanceof ClassLoaderObjectInputStream) {
                m_traceLogger.log(Level.FINE, "\tusing loader:" + ((ClassLoaderObjectInputStream)in).getClassLoader());
            }
        }
        if (this.application == null && in instanceof HttpApplicationInputStream) {
            this.application = ((HttpApplicationInputStream)in).getApplication();
        }
        if (this.application == null && in instanceof EJBInputStream) {
            this.application = ((EJBInputStream)in).getHttpApplication();
        }
        this.creationTime = in.readLong();
        this.lastAccessedTime = in.readLong();
        this.maxInactiveInterval = IOUtils.readCompressedInt(in);
        this.id = ByteString.read(in);
        this.idByte = this.id.data;
        this.ip = IOUtils.readCompressedInt(in);
        this.invalidated = in.readBoolean();
        if (HTTPProperties.getHttpClusterDebug()) {
            m_traceLogger.log(Level.FINE, "Reading session " + this.id);
        }
        if ((username = in.readUTF()) != null && !username.equals("")) {
            ThreadState state = ThreadState.getInheritableCurrentState();
            ContextContainer previousContainer = state.contextContainer;
            try {
                state.contextContainer = this.application;
                this.user = this.application.getUserManager().getUser(username);
            }
            finally {
                state.contextContainer = previousContainer;
            }
        }
        this.valueCount = IOUtils.readCompressedInt(in);
        if (this.valueCount != 0) {
            this.values = new Object[this.valueCount];
            for (int i = 0; i < this.valueCount; i += 2) {
                String utf = in.readUTF();
                if (HTTPProperties.getHttpSessionDebug()) {
                    m_traceLogger.log(Level.FINE, "Reading attribute " + utf);
                }
                this.values[i] = utf.intern();
                this.values[i + 1] = IOUtils.readSimpleObject(in);
            }
        }
    }

    protected void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readObject(in);
    }

    public HttpSessionRuntimeInfo getRuntimeInfo() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (int i = 0; i < this.valueCount; i += 2) {
            String name = (String)this.values[i];
            attributes.put(name, this.getAttribute(name));
        }
        return new HttpSessionRuntimeInfo(this.creationTime, this.lastAccessedTime, this.user == null ? null : this.user.getName(), attributes);
    }

    public void valueBound(SSLSessionBindingEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(SSLSessionBindingEvent event) {
        ThreadState state = ThreadState.getInheritableCurrentState();
        ContextContainer previousContainer = state.contextContainer;
        try {
            state.contextContainer = this.application;
            if (!(this.application != null && this.application.shared || this.invalidated)) {
                this.invalidate();
            }
        }
        finally {
            state.contextContainer = previousContainer;
        }
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isValidIP(byte[] address, int hostmask) {
        int requestingAddress = (address[0] << 24) + (address[1] << 16 & 0xFF0000) + (address[2] << 8 & 0xFF00) + (address[3] & 0xFF);
        return (requestingAddress & hostmask) == (this.ip & hostmask);
    }

    protected Object removeValueFromMap(String name) {
        int i;
        for (i = 0; i < this.valueCount; i += 2) {
            if (name != this.values[i]) continue;
            Object reply = this.values[i + 1];
            this.values[i] = this.values[this.valueCount - 2];
            this.values[i + 1] = this.values[this.valueCount - 1];
            this.values[this.valueCount - 1] = null;
            this.values[this.valueCount - 2] = null;
            this.valueCount -= 2;
            return reply;
        }
        for (i = 0; i < this.valueCount; i += 2) {
            if (!name.equals(this.values[i])) continue;
            Object reply = this.values[i + 1];
            this.values[i] = this.values[this.valueCount - 2];
            this.values[i + 1] = this.values[this.valueCount - 1];
            this.values[this.valueCount - 1] = null;
            this.values[this.valueCount - 2] = null;
            this.valueCount -= 2;
            return reply;
        }
        return null;
    }

    protected Object getValueFromMap(String name) {
        int i;
        for (i = 0; i < this.valueCount; i += 2) {
            if (name != this.values[i]) continue;
            Object reply = this.values[i + 1];
            return reply;
        }
        for (i = 0; i < this.valueCount; i += 2) {
            if (!name.equals(this.values[i])) continue;
            Object reply = this.values[i + 1];
            return reply;
        }
        return null;
    }

    protected Object putValueToMap(String name, Object value) {
        int i;
        for (i = 0; i < this.valueCount; i += 2) {
            if (name != this.values[i]) continue;
            Object reply = this.values[i + 1];
            this.values[i + 1] = value;
            return reply;
        }
        for (i = 0; i < this.valueCount; i += 2) {
            if (!name.equals(this.values[i])) continue;
            Object reply = this.values[i + 1];
            this.values[i + 1] = value;
            return reply;
        }
        if (this.valueCount == 0) {
            this.values = new Object[4];
        } else if (this.valueCount >= this.values.length) {
            Object[] newValues = new Object[this.valueCount * 2];
            System.arraycopy(this.values, 0, newValues, 0, this.valueCount);
            this.values = newValues;
        }
        this.values[this.valueCount] = name;
        this.values[this.valueCount + 1] = value;
        this.valueCount += 2;
        return null;
    }

    public String toString() {
        return "HTTP Session " + this.id;
    }

    PhaseEventIntf getSessionActivationPhase() {
        if (this.sessionActivationPhase == null) {
            try {
                this.sessionActivationPhase = ApplicationServer.phaseEventFactory().create(this.application.getNoun(), "sessionActivation", "oc4j_context");
                this.sessionActivationPhase.deriveMetric(511);
            }
            catch (Exception e) {
                this.application.log("Unable to create phase sensor", e);
            }
        }
        return this.sessionActivationPhase;
    }

    long getSessionActivationToken() {
        return this.sessionActivationToken;
    }

    void setSessionActivationToken(long token) {
        this.sessionActivationToken = token;
    }

    public ServletContext getServletContext() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        return this.application;
    }

    protected long getMostRecentAccessedTime() {
        return this.mostRecentAccessedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginRequest() {
        if (HTTPProperties.getHttpSessionDebug()) {
            m_traceLogger.log(Level.FINE, "EvermindHttpSession.beginRequest()");
        }
        EvermindHttpSession evermindHttpSession = this;
        synchronized (evermindHttpSession) {
            this.mostRecentAccessedTime = System.currentTimeMillis();
            if (this.mostRecentAccessedTime == this.creationTime) {
                ++this.mostRecentAccessedTime;
            }
            ++this.activeRequestsCount;
            if (this.user != null && this.user instanceof DeactivatableUser) {
                boolean isDeactivated = true;
                try {
                    isDeactivated = ((DeactivatableUser)this.user).isDeactivated();
                }
                catch (Throwable t) {
                    m_traceLogger.log(Level.FINE, "The activated state of the session user cannot be ascertained.", t);
                }
                if (isDeactivated) {
                    this.invalidate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endRequest() {
        if (HTTPProperties.getHttpSessionDebug()) {
            m_traceLogger.log(Level.FINE, "EvermindHttpSession.endRequest()");
        }
        EvermindHttpSession evermindHttpSession = this;
        synchronized (evermindHttpSession) {
            this.lastAccessedTime = this.mostRecentAccessedTime;
            --this.activeRequestsCount;
        }
    }

    protected boolean isTimedOut() {
        return this.isTimedOut(System.currentTimeMillis());
    }

    protected boolean isTimedOut(long currentTime) {
        long timeOut;
        if (this.invalidated) {
            return true;
        }
        return !this.invalidated && this.activeRequestsCount == 0 && this.maxInactiveInterval >= 0 && (timeOut = this.lastAccessedTime + (long)(this.maxInactiveInterval * 1000)) < currentTime && this.shouldDestroyOnTimeOut();
    }

    protected boolean shouldDestroyOnTimeOut() {
        return true;
    }

    String getLoginUnparsedURI() {
        return this.loginUnparsedURI;
    }

    void setLoginUnparsedURI(String unparsedURI) {
        this.loginUnparsedURI = unparsedURI;
    }

    protected Cookie createSessionCookie() {
        Cookie sessionCookie = new Cookie(this.application.getSessionCookieName(), this.getId());
        sessionCookie.setPath(this.application.getSessionCookiePath());
        String domain = this.application.config.getSessionCookieDomain();
        if (domain != null) {
            sessionCookie.setDomain(domain);
        }
        if (this.application.config.getSessionCookieIsSecure()) {
            sessionCookie.setSecure(true);
        }
        return sessionCookie;
    }

    static {
        shouldLogNoSuchAlgorithmException = true;
    }
}

