/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

class ErrorRequestDispatcher
implements RequestDispatcher {
    public static final RequestDispatcher DIRECTORY_BROWSING_NOT_ALLOWED = new ErrorRequestDispatcher(403, "Directory browsing not allowed");
    private int errorCode;
    private String reason;

    public ErrorRequestDispatcher(int errorCode, String reason) {
        this.errorCode = errorCode;
        this.reason = reason;
    }

    public void forward(ServletRequest request, ServletResponse response) throws IOException {
        if (this.reason == null) {
            ((HttpServletResponse)response).sendError(this.errorCode);
        } else {
            ((HttpServletResponse)response).sendError(this.errorCode, this.reason);
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws IOException {
        if (this.reason == null) {
            ((HttpServletResponse)response).sendError(this.errorCode);
        } else {
            ((HttpServletResponse)response).sendError(this.errorCode, this.reason);
        }
    }
}

