/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.security.MemoryUser;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.http.AJPRequestHandler;
import com.evermind.server.http.BasicHttpAuthenticator;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.FormHttpAuthenticator;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.SecurityUtil;
import oracle.security.jazn.oc4j.WebSSOAuthenticator;

public class AJPHttpServletRequest
extends EvermindHttpServletRequest {
    private static CertificateFactory certificateFactory;
    protected int port;
    protected boolean secure;
    protected ByteString remoteAddress;
    protected ByteString remoteHost;
    protected ByteString sslSession;
    protected ByteString sslCipher;
    protected ArrayList sslCertificate;
    protected ByteString remoteUserString;
    protected ByteString serverName;
    private String m_unparsedURI;
    private static Logger m_traceLogger;
    private boolean m_ssoUserInitialized = false;

    void setUnparsedURI(String unparsedURI) {
        this.m_unparsedURI = unparsedURI;
    }

    String getUnparsedURI() {
        return this.m_unparsedURI;
    }

    protected boolean useSSLSession() {
        return false;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getRequestURI() {
        if (HTTPProperties.getAjpUseUnparsedUri() && this.m_unparsedURI != null && (this.getCurrentDispatcher() == null || this.isDirectCall())) {
            return this.m_unparsedURI;
        }
        return super.getRequestURI();
    }

    public String getServerName() {
        if (this.serverName == null) {
            return super.getServerName();
        }
        return this.serverName.toString();
    }

    public int getServerPort() {
        return this.port;
    }

    public String getRemoteAddr() {
        if (this.remoteAddress != null) {
            return this.remoteAddress.toString();
        }
        return null;
    }

    public String getRemoteHost() {
        String rh = null;
        rh = this.remoteHost != null ? this.remoteHost.toString() : super.getRemoteHost();
        if (AJPRequestHandler.AJP_DEBUG) {
            m_traceLogger.log(Level.FINE, "AJP: Remote Host is " + rh);
        }
        return rh;
    }

    protected boolean sendPostContinue() {
        return false;
    }

    public ByteString getSSLSession() {
        return this.sslSession;
    }

    public ByteString getSSLCipher() {
        return this.sslCipher;
    }

    public ByteString getSSLCert() {
        if (this.sslCertificate.size() > 0) {
            Object rawCert = this.sslCertificate.get(0);
            ByteString sslCert = new ByteString(rawCert.toString());
            return sslCert;
        }
        return null;
    }

    public void reset() {
        this.remoteUserString = null;
        this.m_unparsedURI = null;
        this.m_ssoUserInitialized = false;
        super.reset();
    }

    public X509Certificate[] getCertificate() throws IllegalArgumentException, RuntimeException {
        try {
            if (certificateFactory == null) {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            X509Certificate[] certs = new X509Certificate[this.sslCertificate.size()];
            for (int i = 0; i < this.sslCertificate.size(); ++i) {
                Object rawCert = this.sslCertificate.get(i);
                ByteString stringCert = new ByteString(rawCert.toString());
                ByteArrayInputStream streamCert = new ByteArrayInputStream(stringCert.data);
                certs[i] = (X509Certificate)certificateFactory.generateCertificate(streamCert);
            }
            if (certs.length == 0) {
                return null;
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Must use a JSSE-compliant SSL engine in order to access the X509 cert: " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new RuntimeException("Certificate error: " + e.getMessage());
        }
    }

    public String getCipherSuite() {
        ByteString cipher = this.getSSLCipher();
        if (cipher != null) {
            String cipherString = new String(cipher.data);
            return cipherString;
        }
        return null;
    }

    public User getUserPrincipalInternal() {
        if (!this.m_ssoUserInitialized) {
            this.loadSSORemoteUser();
        }
        return super.getUserPrincipalInternal();
    }

    protected void loadSSORemoteUser() {
        this.m_ssoUserInitialized = true;
        String ru = null;
        String remoteUser = null;
        if (this.remoteUserString == null) {
            if (this.application != null && this.application.authenticator != null && (this.application.authenticator instanceof FormHttpAuthenticator || this.application.authenticator instanceof BasicHttpAuthenticator)) {
                return;
            }
            remoteUser = this.getRemoteUser();
            if (remoteUser == null) {
                return;
            }
            if (this.application != null && this.application.authenticator != null && this.application.authenticator instanceof WebSSOAuthenticator) {
                this.setRemoteUser(null);
            }
            return;
        }
        remoteUser = this.getRemoteUser();
        if (remoteUser == null) {
            ru = this.remoteUserString.toString();
        } else {
            if (this.remoteUserString.compareTo(remoteUser) == 0) {
                return;
            }
            ru = this.remoteUserString.toString();
        }
        this.setSSORemoteUser(ru);
    }

    private void setSSORemoteUser(String ru) {
        UserManager um = null;
        User u = null;
        if (this.application != null) {
            um = this.application.getUserManager();
        }
        if (um != null) {
            u = SecurityUtil.isJAZN(um) ? SecurityUtil.toJAZN(um).getUser((HttpServletRequest)this, ru) : um.getUser(ru);
            try {
                if (u == null) {
                    u = new MemoryUser(ru, null);
                }
            }
            catch (Exception e) {
                m_traceLogger.log(Level.FINEST, e.getMessage(), e);
            }
            if (u != null) {
                this.setRemoteUser(u);
            }
        }
    }

    public String getContextPath() {
        String contextPath = null;
        contextPath = this.originalApplication != null ? this.originalApplication.contextPath : this.application.contextPath;
        if (this.isDirectCall() && this.requestURI.data == this.input) {
            try {
                char[] charArray = contextPath.toCharArray();
                int numSlash = 0;
                for (int i = 0; i < charArray.length; ++i) {
                    if (charArray[i] != '/') continue;
                    ++numSlash;
                }
                int _idx = -1;
                String _uri = this.getRequestURI();
                for (int i = 0; i < numSlash + 1 && (_idx = _uri.indexOf(47, _idx + 1)) != -1; ++i) {
                }
                contextPath = _idx == -1 ? _uri : _uri.substring(0, _idx);
            }
            catch (Exception e) {
                m_traceLogger.log(Level.FINE, "Error processing context path: " + e.getMessage(), e);
            }
        }
        return contextPath;
    }

    void restoreFormAuthInfo() {
        if (this.session == null) {
            return;
        }
        super.restoreFormAuthInfo();
        this.m_unparsedURI = this.session.getLoginUnparsedURI();
        this.session.setLoginUnparsedURI(null);
    }

    void saveFormAuthInfo() {
        if (this.session == null) {
            return;
        }
        super.saveFormAuthInfo();
        this.session.setLoginUnparsedURI(this.m_unparsedURI);
    }

    static {
        m_traceLogger = TraceLogger.getLogger(AJPHttpServletRequest.class);
    }
}

