/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.proxy;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.proxy.ProxyClassLoader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Constants;

public class CombinedInterfaceGenerator
implements Constants {
    private SessionBeanDescriptor descriptor;

    public CombinedInterfaceGenerator(SessionBeanDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Class generateCombinedInterface(boolean local, ProxyClassLoader cl) {
        Object[] classes = (local ? this.descriptor.getLocalInterfaceNames() : this.descriptor.getRemoteInterfaceNames()).toArray();
        String[] classNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            classNames[i] = ((String)classes[i]).replace('.', '/');
        }
        String intfName = this.descriptor.getName() + "_" + (local ? "Local" : "Remote") + "Combined_" + EJBUtils.buildProxyId(this.descriptor);
        ClassWriter cw = new ClassWriter(true);
        cw.visit(46, 1537, intfName, "java/lang/Object", classNames, null);
        cw.visitEnd();
        return cl.makeProxy(intfName, cw.toByteArray(), this.descriptor.getEJBClass().getProtectionDomain());
    }
}

