/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.database.Table;
import com.evermind.server.ejb.database.TableNameContainer;
import com.evermind.server.ejb.deployment.ORMapping;
import com.evermind.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class ORNameMapper {
    private Map tables;

    public final Map getTables() {
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        return this.tables;
    }

    public final boolean hasTables() {
        return this.tables != null;
    }

    public Table getTable(TableNameContainer requestedName) {
        return (Table)this.getTables().get(requestedName.getTableName());
    }

    public Table lookupTable(TableNameContainer requestedName, boolean firmRequest, DatabaseSchema schema) {
        String currentName;
        String[] parsedNames = Table.parseTableName(requestedName.getTableName());
        String fullTablePrefix = parsedNames[0];
        String schemaName = parsedNames[1];
        String tableName = parsedNames[2];
        while (schema != null && !schema.isValid(tableName)) {
            tableName = tableName + "_";
        }
        if (schema.getMaxTableNameLength() > 0 && tableName.length() > schema.getMaxTableNameLength()) {
            tableName = StringUtils.getShortName(tableName, schema.getMaxTableNameLength());
        }
        if (tableName.indexOf(47) >= 0) {
            tableName = tableName.replace('/', '_');
        }
        if (tableName.indexOf(45) >= 0) {
            tableName = tableName.replace('-', '_');
        }
        parsedNames[2] = tableName;
        requestedName.setTableName((fullTablePrefix != null ? fullTablePrefix + (schemaName != null ? "." : "@") : "") + tableName);
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        Table table = null;
        while ((table = (Table)this.tables.get(currentName = requestedName.getTableName())) != null) {
            ORMapping mapping;
            if (firmRequest) {
                return table;
            }
            if (requestedName instanceof ORMapping && !(mapping = (ORMapping)requestedName).getORField().isManyToMany() && !mapping.associateUsingThirdTable) {
                return table;
            }
            requestedName.setTableName(this.generateNewTableName(currentName));
            parsedNames[2] = this.generateNewTableName(parsedNames[2]);
        }
        table = new Table(requestedName, parsedNames);
        this.tables.put(requestedName.getTableName(), table);
        return table;
    }

    private String generateNewTableName(String currentName) {
        int length = currentName.length();
        String partOfTableName = currentName.substring(0, length - 1);
        char lastChar = currentName.charAt(length - 1);
        String newTableName = null;
        newTableName = Character.isDigit(lastChar) ? (lastChar == '9' ? currentName.substring(0, length - 2) + "10" : partOfTableName + (char)(lastChar + '\u0001')) : partOfTableName + "2";
        return newTableName;
    }
}

