/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.deployment.AnnotationManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.ActivationConfig;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.BeanDescriptorAnnotationParser;
import com.evermind.server.ejb.deployment.EJBJarAnnotations;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import com.evermind.server.ejb.logging.EJBAnnotationMessages;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import oracle.j2ee.deployment.AnnotationParsingMessages;
import oracle.j2ee.ejb.MessageDrivenDeployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDrivenBeanDescriptorAnnotationParser
extends BeanDescriptorAnnotationParser {
    private static MessageDrivenBeanDescriptorAnnotationParser instance = new MessageDrivenBeanDescriptorAnnotationParser();

    private MessageDrivenBeanDescriptorAnnotationParser() {
    }

    public static MessageDrivenBeanDescriptorAnnotationParser getInstance() {
        return instance;
    }

    @Override
    protected BeanDescriptor getDescriptor(EJBPackage ejbPackage, Class cls) {
        String ejbName;
        MessageDriven annot = (MessageDriven)MessageDrivenBeanDescriptorAnnotationParser.getAnnotation(cls, EJBJarAnnotations.MESSAGE_DRIVEN_ANNOTATION);
        if (!MessageDrivenBeanDescriptorAnnotationParser.valueIsEmpty(annot.mappedName())) {
            AnnotationParsingMessages.infoIgnoredAnnotationAttribute("mappedName", "@MessageDriven", cls.getName());
        }
        if (MessageDrivenBeanDescriptorAnnotationParser.valueIsEmpty(ejbName = annot.name())) {
            ejbName = this.getDefaultBeanName(cls);
        }
        EJBAnnotationMessages.fineEJBName(cls.getName(), ejbName);
        MessageDrivenBeanDescriptor descriptor = (MessageDrivenBeanDescriptor)ejbPackage.getBean(ejbName);
        if (descriptor == null) {
            descriptor = new MessageDrivenBeanDescriptor(ejbPackage, ejbName);
            ejbPackage.addBean(descriptor);
        }
        return descriptor;
    }

    @Override
    protected Set<String> getBusinessMethods(BeanDescriptor descriptor, Class cls) throws InstantiationException {
        HashSet<String> methods = new HashSet<String>();
        MessageDrivenBeanDescriptor desc = (MessageDrivenBeanDescriptor)descriptor;
        Class messageListener = desc.getMessageListener();
        for (Method method : messageListener.getDeclaredMethods()) {
            methods.add(EJBUtils.getUniqueMethodSignature(method));
        }
        return methods;
    }

    @Override
    public void parseInjectedMethodAndCallbacks(BeanDescriptor descriptor, Method method) throws InstantiationException {
        super.parseInjectedMethodAndCallbacks(descriptor, method);
        this.parseTimeoutMethod(descriptor, method);
    }

    @Override
    protected void parseBeanAnnotations(BeanDescriptor desc, Class cls, AnnotationManager annotationManager) throws InstantiationException {
        Class messageListenerInterface;
        super.parseBeanAnnotations(desc, cls, annotationManager);
        MessageDrivenBeanDescriptor descriptor = (MessageDrivenBeanDescriptor)desc;
        MessageDriven annot = (MessageDriven)MessageDrivenBeanDescriptorAnnotationParser.getAnnotation(cls, EJBJarAnnotations.MESSAGE_DRIVEN_ANNOTATION);
        ActivationConfigProperty[] properties = annot.activationConfig();
        if (properties != null) {
            for (ActivationConfigProperty property : properties) {
                descriptor.addActivationConfigProperty(new ActivationConfig(property.propertyName(), null, property.propertyValue()));
                descriptor.addOracleActivationConfig(new ActivationConfig(property.propertyName(), null, property.propertyValue(), "config-property"));
            }
        }
        if (!MessageDrivenBeanDescriptorAnnotationParser.valueIsEmpty(messageListenerInterface = annot.messageListenerInterface())) {
            descriptor.setMessagingType(messageListenerInterface.getName());
            EJBAnnotationMessages.finerMessageListenerInterface(descriptor.getMessagingType());
        } else {
            Collection businessInterfaces = EJBUtils.getImplementedBusinessInterfaces(cls);
            if (businessInterfaces.size() == 1) {
                descriptor.setMessagingType(((Class)businessInterfaces.iterator().next()).getName());
                EJBAnnotationMessages.finerMessageListenerInterface(descriptor.getMessagingType());
            }
        }
        MessageDrivenDeployment deployment = (MessageDrivenDeployment)MessageDrivenBeanDescriptorAnnotationParser.getAnnotation(cls, EJBJarAnnotations.MESSAGE_DRIVEN_DEPLOYMENT);
        if (deployment != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.MESSAGE_DRIVEN_DEPLOYMENT.getName());
            if (!MessageDrivenBeanDescriptorAnnotationParser.valueIsEmpty(deployment.connectionFactoryLocation())) {
                descriptor.setConnectionFactoryLocation(deployment.connectionFactoryLocation());
            }
            if (!MessageDrivenBeanDescriptorAnnotationParser.valueIsEmpty(deployment.destinationLocation())) {
                descriptor.setDestinationLocation(deployment.destinationLocation());
            }
            if (!MessageDrivenBeanDescriptorAnnotationParser.valueIsEmpty(deployment.resourceAdapter())) {
                descriptor.setResourceAdapter(deployment.resourceAdapter());
            }
            if (!MessageDrivenBeanDescriptorAnnotationParser.valueIsEmpty(deployment.subscriptionName())) {
                descriptor.setSubscriptionName(deployment.subscriptionName());
            }
            if (deployment.listenerThreads() != 1) {
                descriptor.setListenerThreads(deployment.listenerThreads());
            }
            if (deployment.dequeueRetryCount() != 0) {
                descriptor.setDequeueRetryCount(deployment.dequeueRetryCount());
            }
            if (deployment.dequeueRetryInterval() != 60) {
                descriptor.setDequeueRetryInterval(deployment.dequeueRetryInterval());
            }
            if (deployment.transactionTimeout() != 86400) {
                descriptor.setTransactionTimeout(deployment.transactionTimeout());
            }
            if (deployment.maxInstances() != 0) {
                descriptor.setMaxInstances(deployment.maxInstances());
            }
            if (deployment.minInstances() != 0) {
                descriptor.setMinInstances(deployment.minInstances());
            }
            if (deployment.poolCacheTimeout() != 60) {
                descriptor.setCacheTimeout(deployment.poolCacheTimeout());
            }
            if (deployment.maxDeliveryCount() != 5) {
                descriptor.setMaxDeliveryCount(deployment.maxDeliveryCount());
            }
            if (!MessageDrivenBeanDescriptorAnnotationParser.valueIsEmpty(deployment.interceptorType())) {
                descriptor.setInterceptorType(deployment.interceptorType());
            }
        }
    }
}

